// ControlTeclado.cpp: implementation of the CControlTeclado class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "defines.h"
#include "ExcepcionTU.h"
#include "ControlTeclado.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//##ModelId=3FB214420095
CControlTeclado::CControlTeclado()
{
	key_der = 0;
	key_izq = 0;
	key_rotar_der = 0;
	key_rotar_izq = 0;
	key_abajo = 0;
}

//##ModelId=3FB214420096
CControlTeclado::~CControlTeclado()
{

}

void CControlTeclado::ConfigurarControl(CControles::control c, int t)
{
	switch(c)
	{
	case ctrl_izq:
		key_izq = t;
		break;
	case ctrl_der:
		key_der = t;
		break;
	case ctrl_abajo:
		key_abajo = t;
		break;
	case ctrl_rotar_der:
		key_rotar_der = t;
		break;
	case ctrl_rotar_izq:
		key_rotar_izq = t;
		break;
	default:
		throw new ExcepcionTU("Error al configurar los controles", -1);
	}
}

//##ModelId=3FB2144200A0
void CControlTeclado::Iniciar()
{
	ant_ctrl = 0;
	ant_no_back = 0;
	time = 0;

	CControlHumano::Iniciar();
}

//##ModelId=3FB2144200A1
void CControlTeclado::Ciclo()
{
	int tecla = 0;
	if (ant_ctrl)
	{
		if (key[ant_ctrl])
		{
			tecla = ant_ctrl;
			if (key[key_der] && ant_ctrl!=key_der && ant_no_back!=key_der)
			{
				ant_no_back = ant_ctrl;
				tecla = key_der;
			}
			else if (key[key_izq] && ant_ctrl!=key_izq && ant_no_back!=key_izq)
			{
				ant_no_back = ant_ctrl;
				tecla = key_izq;
			}
			else if (key[key_rotar_der] && ant_ctrl!=key_rotar_der && ant_no_back!=key_rotar_der)
			{
				ant_no_back = ant_ctrl;
				tecla = key_rotar_der;
			}
			else if (key[key_rotar_izq] && ant_ctrl!=key_rotar_izq && ant_no_back!=key_rotar_izq)
			{
				ant_no_back = ant_ctrl;
				tecla = key_rotar_izq;
			}
			else if (key[key_abajo] && ant_ctrl!=key_abajo && ant_no_back!=key_abajo)
			{
				ant_no_back = ant_ctrl;
				tecla = key_abajo;
			}
			else if (!key[ant_no_back]) ant_no_back=0;
		}
		else
		{
			if (key[key_der]) tecla = key_der;
			else if (key[key_izq]) tecla = key_izq;
			else if (key[key_rotar_der]) tecla = key_rotar_der;
			else if (key[key_rotar_izq]) tecla = key_rotar_izq;
			else if (key[key_abajo]) tecla = key_abajo;
		}
	}
	else
	{
		if (key[key_der]) tecla = key_der;
		else if (key[key_izq]) tecla = key_izq;
		else if (key[key_rotar_der]) tecla = key_rotar_der;
		else if (key[key_rotar_izq]) tecla = key_rotar_izq;
		else if (key[key_abajo]) tecla = key_abajo;
	}

	accion_izq = false;
	accion_der = false;
	accion_abajo = false;
	accion_rotar_der = false;
	accion_rotar_izq = false;

	if (time > 0) time-=16;
	if(tecla == key_izq && (ant_ctrl!=key_izq || time<=0))
	{
		accion_izq = true;
		if (ant_ctrl != key_izq)
		{
			time = key_rate_delay;
		}
		else
		{
			time = key_rate_repeat;
		}
	}
	else if(tecla == key_der && (ant_ctrl!=key_der || time<=0))
	{
		accion_der = true;
		if (ant_ctrl != key_der)
		{
			time = key_rate_delay;
		}
		else
		{
			time = key_rate_repeat;
		}
	}
	else if(tecla == key_rotar_der && (ant_ctrl!=key_rotar_der || time<=0))
	{
		accion_rotar_der = true;
		if (ant_ctrl != key_rotar_der)
		{
			time = key_rate_delay;
		}
		else
		{
			time = key_rate_repeat;
		}
	}
	else if(tecla == key_rotar_izq && (ant_ctrl!=key_rotar_izq || time<=0))
	{
		accion_rotar_izq = true;
		if (ant_ctrl != key_rotar_izq)
		{
			time = key_rate_delay;
		}
		else
		{
			time = key_rate_repeat;
		}
	}
	else if(tecla == key_abajo && (ant_ctrl!=key_abajo || time<=0))
	{
		accion_abajo = true;
		if (ant_ctrl != key_abajo)
		{
			time = key_rate_repeat;
		}
		else
		{
			time = key_rate_repeat;
		}
	}
	ant_ctrl = tecla;
}
