// ControlJoystick.cpp: implementation of the CControlJoystick class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "defines.h"
#include "main.h"
#include "ExcepcionTU.h"
#include "ControlJoystick.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//##ModelId=3FB2144200E6
CControlJoystick::CControlJoystick()
{

}

//##ModelId=3FB2144200E7
CControlJoystick::~CControlJoystick()
{

}

//##ModelId=3FB2144200E9
void CControlJoystick::ConfigurarControl(control c, joy_stat &t)
{
	switch(c)
	{
	case ctrl_izq:
		joy_izq = t;
		break;
	case ctrl_der:
		joy_der = t;
		break;
	case ctrl_abajo:
		joy_abajo = t;
		break;
	case ctrl_rotar_der:
		joy_rotar_der = t;
		break;
	case ctrl_rotar_izq:
		joy_rotar_izq = t;
		break;
	}
}

//##ModelId=3FB2144200F1
void CControlJoystick::Iniciar()
{
	ant_ctrl.type = -1;
	ant_no_back.type = -1;
	time = 0;

	CControlHumano::Iniciar();
}

//##ModelId=3FB2144200F3
bool CControlJoystick::estado(joy_stat &j)
{
	bool b = false;

	switch(j.type)
	{
	case 0:
		if (j.dir == 1)
		{
			b = (joy[j.joy].stick[j.stick].axis[j.axis].d1 != 0);
		}
		else
		{
			b = (joy[j.joy].stick[j.stick].axis[j.axis].d2 != 0);
		}
		break;
	case 1:
		b = (joy[j.joy].button[j.boton].b != 0);
		break;
	}

	return b;
}

//##ModelId=3FB2144200F2
void CControlJoystick::Ciclo()
{
	joy_stat tecla;
	tecla.type = -1;
	poll_joystick();
	if (ant_ctrl.type > -1)
	{
		if (estado(ant_ctrl))
		{
			tecla = ant_ctrl;
			if (estado(joy_der) && ant_ctrl!=joy_der && ant_no_back!=joy_der)
			{
				ant_no_back = ant_ctrl;
				tecla = joy_der;
			}
			if (estado(joy_izq) && ant_ctrl!=joy_izq && ant_no_back!=joy_izq)
			{
				ant_no_back = ant_ctrl;
				tecla = joy_izq;
			}
			if (estado(joy_rotar_der) && ant_ctrl!=joy_rotar_der && ant_no_back!=joy_rotar_der)
			{
				ant_no_back = ant_ctrl;
				tecla = joy_rotar_der;
			}
			if (estado(joy_rotar_izq) && ant_ctrl!=joy_rotar_izq && ant_no_back!=joy_rotar_izq)
			{
				ant_no_back = ant_ctrl;
				tecla = joy_rotar_izq;
			}
			if (estado(joy_abajo) && ant_ctrl!=joy_abajo && ant_no_back!=joy_abajo)
			{
				ant_no_back = ant_ctrl;
				tecla = joy_abajo;
			}
			if (!estado(ant_no_back)) ant_no_back.type=-1;
		}
		else
		{
			if (estado(joy_der)) tecla = joy_der;
			if (estado(joy_izq)) tecla = joy_izq;
			if (estado(joy_rotar_der)) tecla = joy_rotar_der;
			if (estado(joy_rotar_izq)) tecla = joy_rotar_izq;
			if (estado(joy_abajo)) tecla = joy_abajo;
		}
	}
	else
	{
		if (estado(joy_der)) tecla = joy_der;
		if (estado(joy_izq)) tecla = joy_izq;
		if (estado(joy_rotar_der)) tecla = joy_rotar_der;
		if (estado(joy_rotar_izq)) tecla = joy_rotar_izq;
		if (estado(joy_abajo)) tecla = joy_abajo;
	}

	accion_izq = false;
	accion_der = false;
	accion_abajo = false;
	accion_rotar_der = false;
	accion_rotar_izq = false;

	if (time > 0) time-=16;
	if(tecla == joy_izq && (ant_ctrl!=joy_izq || time<=0))
	{
		accion_izq = true;
		if (ant_ctrl != joy_izq)
		{
			time = key_rate_delay;
		}
		else
		{
			time = key_rate_repeat;
		}
	}
	else if(tecla == joy_der && (ant_ctrl!=joy_der || time<=0))
	{
		accion_der = true;
		if (ant_ctrl != joy_der)
		{
			time = key_rate_delay;
		}
		else
		{
			time = key_rate_repeat;
		}
	}
	else if(tecla == joy_rotar_der && (ant_ctrl!=joy_rotar_der || time<=0))
	{
		accion_rotar_der = true;
		if (ant_ctrl != joy_rotar_der)
		{
			time = key_rate_delay;
		}
		else
		{
			time = key_rate_repeat;
		}
	}
	else if(tecla == joy_rotar_izq && (ant_ctrl!=joy_rotar_izq || time<=0))
	{
		accion_rotar_izq = true;
		if (ant_ctrl != joy_rotar_izq)
		{
			time = key_rate_delay;
		}
		else
		{
			time = key_rate_repeat;
		}
	}
	else if(tecla == joy_abajo && (ant_ctrl!=joy_abajo || time<=0))
	{
		accion_abajo = true;
		if (ant_ctrl != joy_abajo)
		{
			time = key_rate_repeat;
		}
		else
		{
			time = key_rate_repeat;
		}
	}
	ant_ctrl = tecla;
}
