//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include "stdafx.h"

#include "AnimData.h"

#include "consola.h"
#include "globals.h"
#include "ExcepcionTU.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//##ModelId=3FB214420244
CAnimData::CAnimData()
{

}

//##ModelId=3FB214420245
CAnimData::~CAnimData()
{
	Destruir();
}

//##ModelId=3FB214420247
void CAnimData::Cargar(const string &data)
{
	char str[255];
	t_Frame f;

	con_nueva_linea(consola_main, BLANCO);
	con_nueva_linea(consola_main, BLANCO);
	con_escribir(consola_main, "Cargando animacin '");
	con_escribir(consola_main, data.c_str());
	con_escribir_fn(consola_main, "'...", BLANCO);

	PACKFILE *fp = pack_fopen(data.c_str(), F_READ);

	if (!fp) throw new ExcepcionTU("No se pudo abrir el archivo '" + data + "'", -1);

	pack_fgets(str, 255, fp);
	int n = atoi(str);

	frames.reserve(n);

	longitud = 0;
	for(int i=0; i<n; i++)
	{
		pack_fgets(str, 255, fp);
		string path = path_data + "/" + str;
		con_escribir(consola_main, path.c_str());
		BITMAP *bmp = video.CargarPng(path, Video::no_hw);
		f.bmp = bmp;
		pack_fgets(str, 255, fp);
		con_escribir_fn(consola_main, (" - " + string(str)).c_str(), BLANCO);
		f.time = atoi(str);
		longitud += f.time;

		frames.push_back(f);
	}

	con_escribir(consola_main, "OK");

	pack_fclose(fp);
}

//##ModelId=3FB21442024F
void CAnimData::Destruir()
{
	if (!frames.empty())
	{
		con_nueva_linea(consola_main, BLANCO);
		con_escribir(consola_main, "Destruyendo datos de animacion... ");
		while (!frames.empty())
		{
			video.DestruirBitmap(frames.back().bmp);
			frames.pop_back();
		}
		con_escribir(consola_main, "OK");
	}
}
