//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include "stdafx.h"

#include "AnimData.h"
#include "Anim.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//##ModelId=3FB2144202B3
CAnim::CAnim()
{

}

//##ModelId=3FB2144202B4
CAnim::~CAnim()
{
	Vaciar();
}

//##ModelId=3FB2144202BD
void CAnim::Insertar(CAnimData *d, int x, int y)
{
	t_Animacion a;

	a.data = d;
	a.frame = 0;
	a.tiempo = 0;
	a.posx = x;
	a.posy = y;

	animaciones.push_back(a);
}

//##ModelId=3FB2144202C1
void CAnim::Ciclo()
{
	list<t_Animacion>::iterator it;
	list<t_Animacion>::iterator prev;
	int anim_end;

	it = animaciones.begin();
	while ( it != animaciones.end())
	{
		it->tiempo++;
		anim_end = false;
		while (!anim_end && it->tiempo >= it->data->ObtenerTiempo(it->frame))
		{
			it->tiempo -= it->data->ObtenerTiempo(it->frame);
			it->frame++;
			if (it->frame >= it->data->ObtenerNumFrames())
			{
				anim_end = true;
			}
		}

		prev = it;
		it++;
		if (anim_end)
		{
			animaciones.erase(prev);
		}
	}
}

//##ModelId=3FB2144202C6
void CAnim::Dibujar(BITMAP *dest)
{
	list<t_Animacion>::iterator it;

	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	set_alpha_blender();

	for (it = animaciones.begin(); it != animaciones.end(); it++)
	{
		BITMAP *b = it->data->ObtenerBitmap(it->frame);
		draw_trans_sprite(dest, b, it->posx-b->w/2, it->posy-b->h/2);
	}

	solid_mode();
}

//##ModelId=3FB2144202C8
void CAnim::Vaciar()
{
	animaciones.clear();
}
