//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#ifndef _SISTEMA_DE_PARTICULAS
#define _SISTEMA_DE_PARTICULAS

#define MAX_PART		500
#define PART_ANT		8
#define PART_TRAIL_DEC	30


//##ModelId=3FB2143F0376
class SistemaDeParticulas
{
public:
	//##ModelId=3FB2143F0380
	SistemaDeParticulas();
	//##ModelId=3FB2143F0381
	SistemaDeParticulas(int calidad,
		double suelo,
		double gravedad,
		double x,
		double y,
		unsigned posx_var,
		unsigned posy_var,
		unsigned velocidad_var,
		unsigned vida,
		unsigned fade_out,
		float angulo_max,
		float angulo_min,
		unsigned frecuencia=0,
		unsigned cantidad=1);

	//##ModelId=3FB2143F0397
	virtual ~SistemaDeParticulas();

	//##ModelId=3FB2143F0399
	void Iniciar(BITMAP *brillo);
	//##ModelId=3FB2143F039F
	void Ciclo ();
	//##ModelId=3FB2143F03A0
	void Dibujar(BITMAP *bmp);

	//##ModelId=3FB2143F03A8
	void ModificarVelocidad(double v) {vel = v;}
	//##ModelId=3FB2143F03AA
	void ModificarColor(int c) {col = c;}
	//##ModelId=3FB2143F03B2
	void ModificarPosicion(int x, int y) {posx = x; posy = y;}
	//##ModelId=3FB2143F03B5
	void Mover(int x, int y) {posx += x; posy += y;}
	//##ModelId=3FB2143F03BC
	void ModificarAngulo(double min, double max) {angulo_min = min; angulo_max = max;}
	//##ModelId=3FB2143F03BF
	void ModificarGravedad(double g) {this->g = g;}
	//##ModelId=3FB2143F03C6
	void ModificarCalidad(int c) {part_qual = c;}
	//##ModelId=3FB2143F03C8
	void ModificarPosicionSuelo(double p) {suelo = p;}
	//##ModelId=3FB2143F03D0
	void ModificarNumeroBotes(int n) {num_botes = n;}
	//##ModelId=3FB2143F03D2
	void ModificarVariavilidadPosicion(int vx, int vy) {posx_var = vx; posy_var = vy;}
	//##ModelId=3FB2143F03DA
	void ModificarVariabilidadVelocidad(int v) {velocidad_var = v;}
	//##ModelId=3FB2143F03DC
	void ModificarFrecuencia(unsigned f) {frecuencia = f;}
	//##ModelId=3FB2143F03DE
	void ModificarCantidad(unsigned c) {cantidad = c;}
	//##ModelId=3FB2143F03E5
	void ModificarVida(unsigned v) {vida = v;}
	//##ModelId=3FB2143F03E7
	void ModificarFadeOut(unsigned f) {fade_out = f;}

	//##ModelId=3FB214400007
	double ObtenerPosicionX() const {return posx;}
	//##ModelId=3FB214400009
	double ObtenerPosicionY() const {return posy;}

	//##ModelId=3FB21440000B
	void EmitirParticulas(bool e) {nuevas = e;}

private:
	//##ModelId=3FB214400011
	void NuevaParticula (double vel, int col);
	//##ModelId=3FB21440001A
	static void draw_pixel(BITMAP *dest, int x, int y, int c, float t, double trans);
	//##ModelId=3FB214400026
	static void draw_pixel_add(BITMAP *dest, int x, int y, int c, float t, double trans);
	//##ModelId=3FB214400033
	static void aaline (BITMAP *dest, int x0, int y0, int x1, int y1, int c, double trans, int add_blender=0);

	//##ModelId=3FB214400151
	struct Particula
	{
		//##ModelId=3FB21440015B
		double posx;
		//##ModelId=3FB21440015C
		double posy;
		//##ModelId=3FB21440015D
		double ant_posx[PART_ANT];
		//##ModelId=3FB214400165
		double ant_posy[PART_ANT];
		//##ModelId=3FB214400166
		double velx;
		//##ModelId=3FB214400167
		double vely;
		//##ModelId=3FB21440016F
		int col;
		//##ModelId=3FB214400170
		bool visible;
		//##ModelId=3FB21440017A
		unsigned num_botes;
		//##ModelId=3FB21440017E
		int vida;
		//##ModelId=3FB214400184
		BITMAP *brillo_color;
	};

	//##ModelId=3FB214400045
	Particula particulas[MAX_PART];

	//##ModelId=3FB214400057
	BITMAP *brillo_bmp;

	//##ModelId=3FB21440005B
	int part_qual;

	//##ModelId=3FB214400060
	double suelo;
	//##ModelId=3FB214400061
	double g;


	//##ModelId=3FB21440007F
	unsigned n;
	//##ModelId=3FB214400089
	unsigned t;

	//##ModelId=3FB214400092
	double posx;
	//##ModelId=3FB214400093
	double posy;
	//##ModelId=3FB2144000A7
	unsigned posx_var;
	//##ModelId=3FB2144000B1
	unsigned posy_var;

	//##ModelId=3FB2144000BA
	double vel;
	//##ModelId=3FB2144000C5
	unsigned velocidad_var;
	//##ModelId=3FB2144000EC
	int vida;
	//##ModelId=3FB2144000F6
	int fade_out;

	//##ModelId=3FB21440011F
	float angulo_max;
	//##ModelId=3FB214400129
	float angulo_min;
	//##ModelId=3FB2144000D9
	unsigned frecuencia;
	//##ModelId=3FB2144000E3
	unsigned cantidad;
	//##ModelId=3FB21440006B
	unsigned num_botes;


	//##ModelId=3FB21440010A
	int col;
	//##ModelId=3FB214400100
	bool nuevas;

};

#endif
