//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include "rand.h"

#define _JUEGO_H_INCLUDED_

//##ModelId=3FB214400363
struct t_mini_score
{
	//##ModelId=3FB21440036F
	BITMAP *score_bmp;
	//##ModelId=3FB214400379
	int posy;
	//##ModelId=3FB214400381
	int posx;
	//##ModelId=3FB214400382
	int score;
	//##ModelId=3FB214400383
	int live;
	//##ModelId=3FB21440038B
	bool visible;
};

//##ModelId=3FB21440039F
struct t_stats
{
	//##ModelId=3FB2144003AB
	unsigned num_piezas[12];
	//##ModelId=3FB2144003B4
	unsigned num_lineas[4];
	//##ModelId=3FB2144003C8
	unsigned puntos_lineas;
	//##ModelId=3FB2144003D3
	unsigned puntos_piezas;
	//##ModelId=3FB2144003DD
	unsigned puntos_bonus;
};

#define DERECHA	0
#define IZQUIERDA	1
//##ModelId=3FB214410008
struct t_mini_score_list
{
	//##ModelId=3FB214410013
	int pos;
	//##ModelId=3FB21441001C
	int n;
	//##ModelId=3FB21441001E
	t_mini_score list[NUM_SCORE_LIST];
};

//##ModelId=3FB21441006C
struct t_tablero
{
	//##ModelId=3FB214410077
	int estado;
	//##ModelId=3FB214410078
	int posx;
	//##ModelId=3FB214410079
	int posy;
	//##ModelId=3FB214410080
	int tamx;
	//##ModelId=3FB214410081
	int tamy;
	//##ModelId=3FB214410082
	int lineas;
	//##ModelId=3FB21441008A
	int enviadas;
	//##ModelId=3FB21441008B
	int nivel;
	//##ModelId=3FB21441008C
	int prox_nivel;
	//##ModelId=3FB21441008D
	int nivel_posx;
	//##ModelId=3FB214410094
	int nivel_posy;
	//##ModelId=3FB214410095
	bool nivel_visible;
	//##ModelId=3FB214410096
	int cuadro[MAX_TAB_X][MAX_TAB_Y];
	//##ModelId=3FB21441009E
	int jug[MAX_TAB_X][MAX_TAB_Y];
	//##ModelId=3FB2144100A0
	SistemaDeParticulas sist_particulas[4];
	//##ModelId=3FB2144100B2
	int num_lineas;
	//##ModelId=3FB2144100B3
	int eliminar_lineas[4];
	//##ModelId=3FB2144100B4
	int recibir_lineas;
	//##ModelId=3FB2144100BC
	double barra_recibir_lineas;
	//##ModelId=3FB2144100BD
	bool caer_desde_fuera;
	//##ModelId=3FB2144100C6
	bool nueva_pieza;
	//##ModelId=3FB2144100D0
	unsigned enviar_lineas[4][4];
	//##ModelId=3FB2144100DB
	unsigned contrarestar[4];
};

//##ModelId=3FB2144100F8
struct t_cuadro_puntuacion
{
	//##ModelId=3FB214410103
	int posx;
	//##ModelId=3FB214410104
	int posy;
	//##ModelId=3FB214410105
	int nivel;
	//##ModelId=3FB21441010C
	int lineas;
	//##ModelId=3FB21441010D
	int puntos;
	//##ModelId=3FB21441010E
	bool visible;
};

//##ModelId=3FB214410120
struct t_cuadro_sig_pieza
{
	//##ModelId=3FB21441012B
	int posx;
	//##ModelId=3FB21441012C
	int posy;
	//##ModelId=3FB214410134
	bool visible;
};

//##ModelId=3FB21441017A
struct t_jug
{
	//##ModelId=3FB21441018F
	t_jugador *jug;
	//##ModelId=3FB214410199
	t_cuadro_puntuacion *puntos;
	//##ModelId=3FB2144101AD
	t_set_piezas *piezas;
	//##ModelId=3FB2144101B7
	BITMAP *graf_piezas;
	//##ModelId=3FB2144101C1
	t_tablero *tab;
	//##ModelId=3FB2144101CB
	t_cuadro_sig_pieza *cuadro_sig_pieza;
	//##ModelId=3FB2144101DF
	CControles *ctrl;

	//##ModelId=3FB2144101E9
	t_mini_score_list mini_scores;
	//##ModelId=3FB2144101FD
	t_stats stats;

	//##ModelId=3FB214410210
	int jug_name_posx;
	//##ModelId=3FB21441021A
	int jug_name_posy;

	//##ModelId=3FB214410224
	int piece_score;
	//##ModelId=3FB21441022E
	int sig_pieza;
	//##ModelId=3FB214410242
	int pieza;
	//##ModelId=3FB21441024C
	int pieza_pos_x;
	//##ModelId=3FB214410256
	int pieza_pos_y;
	//##ModelId=3FB214410260
	int pieza_rot;
	//##ModelId=3FB21441026A
	int pieza_sig_paso;
	//##ModelId=3FB21441027E
	int pieza_pos_x_start;

	//##ModelId=3FB214410288
	bool mostrar_siguiente;
	//##ModelId=3FB214410292
	bool puntos_piezas;
	//##ModelId=3FB21441029D
	bool puntos_dejar_caer;
	//##ModelId=3FB2144102A7
	bool sacar_siguiente;

	//##ModelId=3FB2144102BC
	CRand *serie_piezas;
};

//##ModelId=3FB2144102E3
enum t_condicion_victoria {mas_puntos, primer_tetris, mas_lineas, mas_enviadas, superviviente};

//##ModelId=3FB214410315
struct t_juego
{
	//##ModelId=3FB214410321
	t_condicion_victoria v;
	//##ModelId=3FB214410329
	int num_tab;
	//##ModelId=3FB214410334
	t_tablero *tab[4];
	//##ModelId=3FB21441033D
	int num_jug;
	//##ModelId=3FB214410348
	t_jug *jug[4];
	//##ModelId=3FB214410351
	int num_punt;
	//##ModelId=3FB21441035C
	t_cuadro_puntuacion *puntos[4];
	//##ModelId=3FB21441036F
	int tiempo;
	//##ModelId=3FB214410370
	int tiempo_extra;
	//##ModelId=3FB214410379
	int tiempo_entre_lineas;
	//##ModelId=3FB214410383
	bool enviar_lineas_esperar_nueva_pieza;
};

//##ModelId=3FB2144103A1
enum t_modo_juego {modo_none, modo_arcade, modo_normal, modo_cooperativo, modo_competitivo, modo_survival};

void comenzar_juego(BITMAP* fondo, t_juego *juego, t_modo_juego tipo_juego);

void insertar_linea(t_tablero *tab, char num);
