//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------

#include "Video.h"

#define _CONSOLA_H_INCLUDED_

//##ModelId=3FB2144201FE
struct t_nodo_consola
{
	//##ModelId=3FB214420200
	char *line;
	//##ModelId=3FB214420208
	int color;
	//##ModelId=3FB214420212
	struct t_nodo_consola* next_line;
};

//##ModelId=3FB21442021C
typedef struct t_consola
{
	int num_lines;
	bool visible;
	FILE *fp;
	Video *v;
	struct t_nodo_consola *linea;
	struct t_nodo_consola *linea_sup;
	struct t_nodo_consola *ultima_linea;
}t_consola;

t_consola *crear_consola(Video *v, const char *log = NULL);
void destruir_consola(t_consola *con);
void con_nueva_linea(t_consola *con, int color);
void con_escribir(t_consola *con, const char *text);
void con_escribir_fn(t_consola *con, const char *text, const int color);
void con_escribir(t_consola *con, const int num);
void con_escribir_fn(t_consola *con, const int num, const int color);
void dibujar_consola(t_consola *con);

#define BLANCO		makecol(192, 192, 192)
#define ROJO		makecol(255, 0, 0)
#define VERDE		makecol(0, 255, 0)
#define AMARILLO	makecol(255, 255, 0)
#define CIAN		makecol(0, 255, 255)
