//////////////////////////////////////////////////////////
//                                                      //
//  rand.h                                              //
//                                                      //
//  Random number generation class, using the standard  //
//  C library,                                          //
//  by Oscar Giner Martnez                             //
//  o_giner@hotmail.com                                 //
//                                                      //
//  This code is free domain.                           //
//                                                      //
//////////////////////////////////////////////////////////


//##ModelId=3FB2144001A1
class CRand
{
	//##ModelId=3FB2144001AC
	unsigned seed;

	//##ModelId=3FB2144001B5
	static bool first_time;
	//##ModelId=3FB2144001C0
	static unsigned global_seed;   // Used for making different
	                               // seeds for each object

public:
	//##ModelId=3FB2144001C9
	CRand(void);
	//##ModelId=3FB2144001CB
	explicit CRand(int s);

	// With this constructor, the class will be initialized using
	// the current seed of r
	//##ModelId=3FB2144001D4
	CRand(CRand& r);
	
	//##ModelId=3FB2144001D6
	~CRand(void);

	// Initializes the CRand class. You don't need to call this
	// because the constructor do this for you.
	// If its the first time you call this function in your program
	// the seed will be initialized looking at the time, else
	// the seed will be calculated adding 1 to the previos one,
	// so you can instanciate more than one CRand classes at the
	// same time obtaining different seeds.
	//##ModelId=3FB2144001DE
	void initialize(void);

	// Gets a random number
	//##ModelId=3FB2144001E0
	int rand(void);

	// Sets the seed
	//##ModelId=3FB2144001E8
	void set_seed(int s) {seed = s;};

	// Gets the current seed
	//##ModelId=3FB2144001F1
	int get_seed(void) {return seed;};
};
