//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#define _JUGADOR_H_INCLUDED_

//##ModelId=3FB214400345
typedef struct t_jugador
{
	char nombre[11];
	char apellido[11];
	char nick[11];

	unsigned short key_rate_delay;
	unsigned short key_rate_repeat;

	unsigned r_arcade_part;
	unsigned r_arcade_pts[10];
	unsigned r_arcade_lin[10];
	unsigned r_arcade_niv[10];

	unsigned r_normal_part;
	unsigned r_normal_pts[10];
	unsigned r_normal_lin[10];
	unsigned r_normal_niv[10];
	unsigned r_normal_multi_win;
	unsigned r_normal_multi_lose;
	unsigned r_normal_multi_draw;

	unsigned r_coop_part;
	unsigned r_coop_pts[10];
	unsigned r_coop_lin[10];
	unsigned r_coop_niv[10];
	char r_coop_p_n[10][11];
	char r_coop_p_a[10][11];
	char r_coop_p_ni[10][11];
	unsigned r_coop_multi_win;
	unsigned r_coop_multi_lose;
	unsigned r_coop_multi_draw;

	unsigned r_comp_part;
	unsigned r_comp_pts[10];
	unsigned r_comp_lin[10];
	unsigned r_comp_niv[10];
	unsigned r_comp_win;
	unsigned r_comp_lose;
	unsigned r_comp_draw;

	unsigned r_surv_part;
	unsigned r_surv_pts[10];
	unsigned r_surv_lin[10];
	unsigned r_surv_niv[10];
	unsigned r_surv_num[10];
	unsigned r_surv_win;
	unsigned r_surv_lose;
	unsigned r_surv_draw;

	unsigned r_torn_part;
	unsigned r_torn_pts[10];
	unsigned r_torn_lin[10];
	unsigned r_torn_pos[10];
	unsigned r_torn_win;
}t_jugador;

void poner_record_jugador_normal (t_jugador *jug, unsigned puntos, unsigned lineas, unsigned nivel, int est);
void poner_record_jugador_cooperativo (t_jugador *jug, unsigned puntos, unsigned lineas, unsigned nivel, t_jugador* companero, int est);
void poner_record_jugador_competitivo (t_jugador *jug, unsigned puntos, unsigned lineas, unsigned nivel, int est);

int add_jugador (int jug, BITMAP *fondo, FONT *fuente);
void eliminar_jugador (BITMAP *fondo, FONT *fuente, FONT *f_list);
void cargar_jugadores (void);
void guardar_jugadores (void);
void exportar_jugador (BITMAP *fondo, FONT *fuente, FONT *f_list);
void ver_info (BITMAP *fondo, FONT *fuente, FONT *cabeza);
int importar_jugador (int jug, BITMAP *fondo, FONT *fuente, FONT *f_list);
