//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#ifndef _VIDEO_H_INCLUDED_
#define _VIDEO_H_INCLUDED_


//##ModelId=3FB2143F01C8
class Video
{
public:

	//##ModelId=3FB2143F02AE
	enum ModoActualizacion {automatico=0, doble_buffer, page_flipping, triple_buffer};
	//##ModelId=3FB2143F02C2
	enum TipoBitmap {no_hw=0, hw_blit, hw_trans_blit};

	//##ModelId=3FB2143F01C9
	Video();
	//##ModelId=3FB2143F01D1
	~Video();

	//##ModelId=3FB2143F01D2
	bool Iniciar(bool aceleracion_hw, ModoActualizacion modo);
	//##ModelId=3FB2143F01D5
	void Finalizar();

	//##ModelId=3FB2143F01DB
	void ModificarColorFondo(int color);
	//##ModelId=3FB2143F01DD
	void ModificarVista(int vista_w, int vista_h);

	//##ModelId=3FB2143F01E5
	void Rellenar(int color);
	//##ModelId=3FB2143F01E7
	void Vaciar(void);

	//##ModelId=3FB2143F01EF
	void RepintarFondo();

	//##ModelId=3FB2143F01F0
	BITMAP* ObtenerPantalla() const;
	//##ModelId=3FB2143F01F2
	BITMAP* ObtenerPaginaVisible() const;

	//##ModelId=3FB2143F01F9
	void IniciarSalida();
	//##ModelId=3FB2143F01FA
	void FinalizarSalida();
	//##ModelId=3FB2143F01FB
	void Actualizar();
	//##ModelId=3FB2143F01FC
	void CopiarABuffers();
	//##ModelId=3FB2143F0203
	void CopiarFrameAnterior();

	//##ModelId=3FB2143F0204
	BITMAP* CrearBitmap(int w, int h, TipoBitmap tipo);
	//##ModelId=3FB2143F020E
	void DestruirBitmap(BITMAP *bmp);
	//##ModelId=3FB2143F0210
	void PonerBitmap(BITMAP *bmp);
	//##ModelId=3FB2143F0217
	BITMAP* CargarPng(const string &file, TipoBitmap tipo);

private:
	//##ModelId=3FB2143F0222
	ModoActualizacion modo_actual;
	//##ModelId=3FB2143F0226
	bool hw_accel;
	//##ModelId=3FB2143F022B
	int fondo;
	//##ModelId=3FB2143F022C
	int pagina_actual;
	//##ModelId=3FB2143F0235
	int vista_x;
	//##ModelId=3FB2143F0236
	int vista_y;
	//##ModelId=3FB2143F023F
	int vista_w;
	//##ModelId=3FB2143F0240
	int vista_h;
	//##ModelId=3FB2143F024A
	int contador_iniciar_salida;

	//##ModelId=3FB2143F0255
	BITMAP *dummy;
	//##ModelId=3FB2143F025F
	BITMAP *sub_screen;
	//##ModelId=3FB2143F0269
	BITMAP *buffer;
	//##ModelId=3FB2143F0273
	BITMAP *sub_buffer;
	//##ModelId=3FB2143F027D
	BITMAP *page[3];
	//##ModelId=3FB2143F0291
	BITMAP *sub_page[3];

	//##ModelId=3FB2143F029A
	void RepintarFondo(BITMAP *bmp);
};


#endif
