//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


// MyListCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "MGrabber.h"
#include "MyListCtrl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyListCtrl

CMyListCtrl::CMyListCtrl()
{
}

CMyListCtrl::~CMyListCtrl()
{
}


BEGIN_MESSAGE_MAP(CMyListCtrl, CListCtrl)
	//{{AFX_MSG_MAP(CMyListCtrl)
	ON_WM_DROPFILES()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyListCtrl message handlers

BOOL CMyListCtrl::SubclaseEdit(UINT nID, CWnd *padre)
{
	return (SubclassDlgItem(nID, padre));
}

void CMyListCtrl::OnDropFiles(HDROP hDropInfo) 
{
	// TODO: Add your message handler code here and/or call default
	int files_count;
	char *file;
	char filename[260];
	int buf_size;
	int i;
	unsigned j;
	char cbuf[31];
	int item;
	char *token;
	char ext[4] = "";
	char *aux;
	char *type[] = {"ONDA", "MIDI", "MOD "};
	char *t = NULL;
	int next_lower = 1;

	files_count = DragQueryFile(hDropInfo, 0xFFFFFFFF, NULL, 0);

	for(i=0; i<files_count; i++)
	{
		buf_size = DragQueryFile(hDropInfo, i, NULL, 0);
		file = new char[buf_size+1];
		aux = new char[buf_size+1];
		DragQueryFile(hDropInfo, i, file, buf_size+1);
		strcpy(aux, file);
		token = strtok(aux, "\\");
		while (token)
		{
			strcpy(filename, token);
			token = strtok(NULL, "\\");
		}
		token = strtok(filename, ".");
		while (token)
		{
			strncpy(ext, token, 3);
			token = strtok(NULL, ".");
		}
		ext[0] = tolower(ext[0]);
		ext[1] = tolower(ext[1]);
		ext[2] = tolower(ext[2]);

		if (!strcmp(ext, "mp2") || !strcmp(ext, "mp3") || !strcmp(ext, "ogg") || !strcmp(ext, "wav"))
		{
			t = type[0];
		}
		else if (!strcmp(ext, "mid"))
		{
			t = type[1];
		}
		else if (!strcmp(ext, "mod") || !strcmp(ext, "xm") || !strcmp(ext, "it") || !strcmp(ext, "s3m"))
		{
			t = type[2];
		}

		if (t)
		{
			item = GetItemCount();
			strncpy (cbuf, filename, 30);
			cbuf[0] = toupper(cbuf[0]);
			next_lower = 1;
			for(j=1; j<strlen(cbuf); j++)
			{
				switch (cbuf[j])
				{
				case ' ':
				case '_':
					cbuf[j] = ' ';
					next_lower = 0;
					break;
				default:
					cbuf[j] = next_lower ? tolower(cbuf[j]) : toupper(cbuf[j]);
					next_lower = 1;
				}
			}
			InsertItem(item, cbuf);
			SetItemText(item, 1, file);
			SetItemText(item, 2, t);
		}

		t = NULL;

		delete file;
		delete aux;
	}
	
	CListCtrl::OnDropFiles(hDropInfo);
}
