//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


// MGrabberDlg.cpp : implementation file
//

#define ALLEGRO_AND_MFC

#include <allegro.h>
#include <winalleg.h>
#include "datedit.h"
#include "stdafx.h"
#include "MGrabber.h"
#include "MyListCtrl.h"
#include "MGrabberDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

void do_add_file(AL_CONST *filename, int attrib, int param);
extern DATAFILE *datafile;

/////////////////////////////////////////////////////////////////////////////
// CMGrabberDlg dialog

CMGrabberDlg::CMGrabberDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMGrabberDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMGrabberDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMGrabberDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMGrabberDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMGrabberDlg, CDialog)
	//{{AFX_MSG_MAP(CMGrabberDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(IDC_MENU_GUARDAR, OnMenuGuardar)
	ON_COMMAND(ADD_MIDI, OnMidi)
	ON_COMMAND(ADD_MP3, OnMp3)
	ON_COMMAND(IDC_MENU_GUARDARCOMO, OnMenuGuardarcomo)
	ON_COMMAND(ADD_MOD, OnMod)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDC_LIST_OBJ, OnEndlabeleditListObj)
	ON_COMMAND(IDC_MENU_NUEVO, OnMenuNuevo)
	ON_WM_SIZE()
	ON_WM_ACTIVATE()
	ON_COMMAND(ID_DELANTE, OnDelante)
	ON_WM_INITMENU()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMGrabberDlg message handlers

BOOL CMGrabberDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_menu.LoadMenu(IDR_MENU);

	SetMenu(&m_menu);

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	delante = 1;

	m_list_obj.SubclaseEdit(IDC_LIST_OBJ, this);

	m_list_obj.InsertColumn(0, "Nombre", LVCFMT_LEFT, 100);
	m_list_obj.InsertColumn(1, "Origen", LVCFMT_LEFT, 350);
	m_list_obj.InsertColumn(2, "Tipo", LVCFMT_LEFT, 45);

	m_list_obj.SetCallbackMask(LVIS_DROPHILITED);

	m_list_obj.SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_HEADERDRAGDROP);

	install_allegro(SYSTEM_NONE, &errno, atexit);

	datedit_init();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMGrabberDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMGrabberDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMGrabberDlg::OnMenuGuardar() 
{
	// TODO: Add your command handler code here

}

void CMGrabberDlg::OnMidi() 
{
	char* orig;
	CString file;

	CFileDialog fdlg(true,
		"mid",
		NULL,
		OFN_HIDEREADONLY
		| OFN_OVERWRITEPROMPT
		| OFN_ALLOWMULTISELECT
		| OFN_FILEMUSTEXIST,
		"Msica midi|*.mid||");
	
	fdlg.m_ofn.lpstrInitialDir = ".";

	if (fdlg.DoModal() == IDOK)
	{
		int i = fdlg.m_ofn.nFileOffset;

		orig = new char[fdlg.m_ofn.nFileOffset+1];

		strncpy(orig, fdlg.m_ofn.lpstrFile, fdlg.m_ofn.nFileOffset);
		orig[fdlg.m_ofn.nFileOffset-1] = 0;
		if (orig[fdlg.m_ofn.nFileOffset-2] == '\\')
		{
			orig[fdlg.m_ofn.nFileOffset-2] = '\0';
		}

		char name[5];

		while (fdlg.m_ofn.lpstrFile[i])
		{
			sprintf(name, "%d", m_list_obj.GetItemCount()+1);
			m_list_obj.InsertItem(m_list_obj.GetItemCount(), name);
			
			file.Format("%s\\%s", orig, fdlg.m_ofn.lpstrFile+i);

			m_list_obj.SetItemText(m_list_obj.GetItemCount()-1, 1, file);
			m_list_obj.SetItemText(m_list_obj.GetItemCount()-1, 2, "MIDI");
			i+=strlen(fdlg.m_ofn.lpstrFile+i)+1;
		}

		delete [] orig;
	}
}

void CMGrabberDlg::OnMp3() 
{
	char* orig;
	CString file;

	CFileDialog fdlg(true,
		"",
		NULL,
		OFN_HIDEREADONLY
		| OFN_OVERWRITEPROMPT
		| OFN_ALLOWMULTISELECT
		| OFN_FILEMUSTEXIST,
		"Archivos de onda|*.mp2;*.mp3;*.ogg;*.wav|Archivos mpeg (*.mp2, *.mp3)|*.mp2;*.mp3|Archivos ogg (*.ogg)|*.ogg|Archivos wav (*.wav)|*.wav||");
	
	fdlg.m_ofn.lpstrInitialDir = ".";

	if (fdlg.DoModal() == IDOK)
	{
		int i = fdlg.m_ofn.nFileOffset;

		orig = new char[fdlg.m_ofn.nFileOffset+1];

		strncpy(orig, fdlg.m_ofn.lpstrFile, fdlg.m_ofn.nFileOffset);
		orig[fdlg.m_ofn.nFileOffset-1] = 0;
		if (orig[fdlg.m_ofn.nFileOffset-2] == '\\')
		{
			orig[fdlg.m_ofn.nFileOffset-2] = '\0';
		}

		char name[5];

		while (fdlg.m_ofn.lpstrFile[i])
		{
			sprintf(name, "%d", m_list_obj.GetItemCount()+1);
			m_list_obj.InsertItem(m_list_obj.GetItemCount(), name);
			
			file.Format("%s\\%s", orig, fdlg.m_ofn.lpstrFile+i);

			m_list_obj.SetItemText(m_list_obj.GetItemCount()-1, 1, file);
			m_list_obj.SetItemText(m_list_obj.GetItemCount()-1, 2, "ONDA");
			i+=strlen(fdlg.m_ofn.lpstrFile+i)+1;
		}

		delete [] orig;
	}
}

void CMGrabberDlg::OnMod() 
{
	char* orig;
	CString file;

	CFileDialog fdlg(true,
		"",
		NULL,
		OFN_HIDEREADONLY
		| OFN_OVERWRITEPROMPT
		| OFN_ALLOWMULTISELECT
		| OFN_FILEMUSTEXIST,
		"Archivos MOD|*.mod;*.s3m;*.xm;*.it|Protracker/Fasttracker(*.mod)|*.mod|Screamtracker 3 (*.s3m)|*.s3m|Fasttracker 2 (*.xm)|*.xm|Impulse Tracker (*.it)|*.it||");
	
	fdlg.m_ofn.lpstrInitialDir = ".";

	if (fdlg.DoModal() == IDOK)
	{
		int i = fdlg.m_ofn.nFileOffset;

		orig = new char[fdlg.m_ofn.nFileOffset+1];

		strncpy(orig, fdlg.m_ofn.lpstrFile, fdlg.m_ofn.nFileOffset);
		orig[fdlg.m_ofn.nFileOffset-1] = 0;
		if (orig[fdlg.m_ofn.nFileOffset-2] == '\\')
		{
			orig[fdlg.m_ofn.nFileOffset-2] = '\0';
		}

		char name[5];

		while (fdlg.m_ofn.lpstrFile[i])
		{
			sprintf(name, "%d", m_list_obj.GetItemCount()+1);
			m_list_obj.InsertItem(m_list_obj.GetItemCount(), name);
			
			file.Format("%s\\%s", orig, fdlg.m_ofn.lpstrFile+i);


			m_list_obj.SetItemText(m_list_obj.GetItemCount()-1, 1, file);
			m_list_obj.SetItemText(m_list_obj.GetItemCount()-1, 2, "MOD ");
			i+=strlen(fdlg.m_ofn.lpstrFile+i)+1;
		}

		delete [] orig;
	}
}

void CMGrabberDlg::OnMenuGuardarcomo() 
{
	int i;

	CFileDialog fdlg(false,
		"dat",
		NULL,
		OFN_HIDEREADONLY
		| OFN_OVERWRITEPROMPT,
		"Archivo de musica|*.dat||");

	fdlg.m_ofn.lpstrInitialDir = ".";

	if (fdlg.DoModal() == IDOK)
	{
		if (exists(fdlg.m_ofn.lpstrFile))
		{
			delete_file(fdlg.m_ofn.lpstrFile);
		}
		datafile = datedit_load_datafile(fdlg.m_ofn.lpstrFile, FALSE, NULL);
		if (!datafile)
		{
			AfxMessageBox("Error al abrir/crear el archivo");
			exit(-1);
		}

		CString lista_obj;
		CString nombre_obj;
		DATAFILE *d;
		for(i=0; i<m_list_obj.GetItemCount(); i++)
		{
			if (i>0) lista_obj += '\n';
			nombre_obj.Format("OBJ_%4.4d\n", i);
			lista_obj += nombre_obj;
			lista_obj += m_list_obj.GetItemText(i, 0);
		}

		char *lista_obj_char = new char[lista_obj.GetLength()+1];
		strcpy(lista_obj_char, lista_obj);

		this->BeginWaitCursor();

		FILE *fp;
		fp = fopen("~mgrab", "wb");
		fwrite(lista_obj_char, sizeof(char), lista_obj.GetLength()+1, fp);
		fclose(fp);
		d = datedit_grabnew(datafile, "~mgrab", " ", "LIST", 0, 0, 0, 0, 0);
		datafile = d;
		delete_file("~mgrab");

		for(i=0; i<m_list_obj.GetItemCount(); i++)
		{
//			do_add_file(m_list_obj.GetItemText(i, 1), FA_ARCH | FA_RDONLY, 0);
//			datedit_set_property(datafile, DAT_TYPE, 
			char obj[1000];
			sprintf(obj, "Error al cargar %s", m_list_obj.GetItemText(i, 1));

			char obj_name[10];
			sprintf(obj_name, "OBJ_%4.4d", i);
			d = datedit_grabnew(datafile, m_list_obj.GetItemText(i, 1), obj_name, m_list_obj.GetItemText(i, 2), 32, 0, 0, 0, 0);
			if (!d)
			{
				AfxMessageBox(obj);
				return;
			}
		   datafile = d;
		}

		datedit_save_datafile(datafile, fdlg.m_ofn.lpstrFile, 0, 0, 0, 0, 0, NULL);
		unload_datafile(datafile);

		this->EndWaitCursor();
	}
}

void CMGrabberDlg::OnEndlabeleditListObj(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
	char *text;

	text = pDispInfo->item.pszText;
	if (text != NULL)
	{
		if (strlen(text) > 0)
			if (strlen(text) > 30)
			{
				AfxMessageBox("El nombre no puede tener ms de 30 caracteres", MB_ICONEXCLAMATION);
				*pResult = FALSE;
			}
			else
			{
				*pResult = TRUE;
			}
		else
		{
			*pResult = FALSE;
		}
	}
}

void CMGrabberDlg::OnMenuNuevo() 
{
	m_list_obj.DeleteAllItems();
}

void CMGrabberDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);

	if (::IsWindow(m_list_obj.m_hWnd))
	{
		m_list_obj.SetWindowPos(this->GetParent(), 0, 0, cx, cy, 0);
	}
}

void CMGrabberDlg::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{
	CDialog::OnActivate(nState, pWndOther, bMinimized);
	
	// TODO: Add your message handler code here
	RECT rect;

	this->GetWindowRect(&rect);

	m_list_obj.SetWindowPos(&wndTop, 0, 0, rect.right-rect.left-8, rect.bottom-rect.top-46, 0);

}

void CMGrabberDlg::OnDelante() 
{
	delante = 1-delante;
	
	if (delante) SetWindowPos(&wndTopMost, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
	else SetWindowPos(&wndNoTopMost, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
}

void CMGrabberDlg::OnInitMenu(CMenu* pMenu) 
{
	CDialog::OnInitMenu(pMenu);

	pMenu->CheckMenuItem(ID_DELANTE, delante ? MF_CHECKED : MF_UNCHECKED);
}
