//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


// AboutDlg.cpp : implementation file
//

#include "stdafx.h"
#include "config.h"
#include "AboutDlg.h"

#define INLINE inline
#include "template.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog


//##ModelId=3FB21432018D
CAboutDlg::CAboutDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAboutDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}


//##ModelId=3FB2143201F1
struct text_resource
{
	//##ModelId=3FB2143201FC
	char *text;
	//##ModelId=3FB2143201FD
	int pos;
	//##ModelId=3FB214320205
	int size;
};

DWORD CALLBACK StreamCallback(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG *pcb)
{
	text_resource *text = (text_resource *)dwCookie;

	*pcb = cb;
	if (text->pos + cb > text->size) *pcb = text->size - text->pos;
	memcpy(pbBuff, text->text+text->pos, *pcb);

	text->pos += *pcb;

	return 0;
}

//##ModelId=3FB2143201E7
BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	COLORREF m_color;
	m_color = 0xffffff;
	m_pincel.CreateSolidBrush(m_color);

	m_color = RGB(190, 210, 210);
	m_pincel_ventana.CreateSolidBrush(m_color);

	m_pincel_fondo.CreateSolidBrush(RGB(235, 255, 255));

	m_ok.SetWindowText(TEXT_config_button_close());
	SetWindowText(TEXT_config_about());

	HRSRC gpl_text_res = FindResource(NULL, MAKEINTRESOURCE(IDR_GPL), "RTF");

	if (gpl_text_res == NULL)
	{
		AfxMessageBox("Error loading gpl text", 0, 0);
	}
	else
	{
		text_resource tr;

		HGLOBAL gpl_text_handle = LoadResource(NULL, gpl_text_res);
		char *gpl_text = (char *)LockResource(gpl_text_handle);

		tr.pos = 0;
		tr.size = SizeofResource(NULL, gpl_text_res);
		tr.text = gpl_text;

		EDITSTREAM es;
		es.dwCookie = (DWORD)(&tr);
		es.dwError = 0;
		es.pfnCallback = StreamCallback;

		m_gpl.StreamIn(SF_RTF, es);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

//##ModelId=3FB2143201AB
void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_RTF_GPL, m_gpl);
	DDX_Control(pDX, IDOK, m_ok);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	ON_WM_CTLCOLOR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg message handlers

//##ModelId=3FB2143201D3
HBRUSH CAboutDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	if (nCtlColor == CTLCOLOR_DLG)// if (pWnd->GetDlgCtrlID() == IDD_CONFIG_DIALOG)
	{
		return (HBRUSH)m_pincel_ventana.GetSafeHandle();
	}
	else if (nCtlColor == CTLCOLOR_LISTBOX || nCtlColor == CTLCOLOR_EDIT)
	{
		pDC->SetBkColor(RGB(235, 255, 255));
		return (HBRUSH)m_pincel_fondo.GetSafeHandle();
	}
	else
	{
		pDC->SetBkColor(RGB(190, 210, 210));
		return (HBRUSH)m_pincel_ventana.GetSafeHandle();
	}

	return hbr;
}
