//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


// MusicaDlg.cpp : implementation file
//

#include "stdafx.h"
#include <io.h>
#include "Config.h"
#include "MusicaDlg.h"

#define INLINE inline
#include "template.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMusicaDlg dialog


//##ModelId=3FB2142D0280
CMusicaDlg::CMusicaDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMusicaDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMusicaDlg)
	m_archivo = _T("");
	m_nombre = _T("");
	//}}AFX_DATA_INIT
}


//##ModelId=3FB2142D02DA
void CMusicaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMusicaDlg)
	DDX_Control(pDX, IDC_ARCHIVO, m_list_musica);
	DDX_Control(pDX, IDOK, m_ok);
	DDX_Control(pDX, IDCANCEL, m_cancel);
	DDX_Control(pDX, IDC_STATIC_NOMBRE, m_s_nombre);
	DDX_Control(pDX, IDC_STATIC_ARCHIVO, m_s_archivo);
	DDX_Control(pDX, IDC_NOMBRE, m_edit_nombre);
	DDX_LBString(pDX, IDC_ARCHIVO, m_archivo);
	DDX_Text(pDX, IDC_NOMBRE, m_nombre);
	DDV_MaxChars(pDX, m_nombre, 50);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMusicaDlg, CDialog)
	//{{AFX_MSG_MAP(CMusicaDlg)
	ON_LBN_SELCHANGE(IDC_ARCHIVO, OnSelchangeArchivo)
	ON_EN_CHANGE(IDC_NOMBRE, OnChangeNombre)
	ON_LBN_DBLCLK(IDC_ARCHIVO, OnDblclkArchivo)
	ON_WM_CTLCOLOR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMusicaDlg message handlers

//##ModelId=3FB2142D0302
BOOL CMusicaDlg::OnInitDialog() 
{
	_finddata_t fileinfo;
	CString path;
	long fh;
	long ret;

	CDialog::OnInitDialog();
	
	SetWindowText(Titulo);
	
	path = Dir + "\\*.dat";

	ret = fh = _findfirst(path, &fileinfo);
	while (ret >= 0)
	{
		m_list_musica.AddString(fileinfo.name);
		ret = _findnext(fh, &fileinfo);
	}
	_findclose(fh);

	UpdateData(FALSE);

	if (m_list_musica.GetCurSel() >= 0 && m_edit_nombre.GetWindowTextLength() > 0)
	{
		m_ok.EnableWindow(TRUE);
	}
	else
	{
		m_ok.EnableWindow(FALSE);
	}

	m_ok.SetWindowText(TEXT_config_button_ok());
	m_cancel.SetWindowText(TEXT_config_button_cancel());
	m_s_archivo.SetWindowText(TEXT_config_music_file());
	m_s_nombre.SetWindowText(TEXT_config_music_name());

	COLORREF m_color;
	m_color = RGB(190, 210, 210);
	m_pincel_ventana.CreateSolidBrush(m_color);

	m_pincel_fondo.CreateSolidBrush(RGB(235, 255, 255));

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

//##ModelId=3FB2142D0304
void CMusicaDlg::OnSelchangeArchivo() 
{
	if (m_list_musica.GetCurSel() >= 0 && m_edit_nombre.GetWindowTextLength() > 0)
	{
		m_ok.EnableWindow(TRUE);
	}
	else
	{
		m_ok.EnableWindow(FALSE);
	}
}

//##ModelId=3FB2142D030C
void CMusicaDlg::OnChangeNombre() 
{
	if (m_list_musica.GetCurSel() >= 0 && m_edit_nombre.GetWindowTextLength() > 0)
	{
		m_ok.EnableWindow(TRUE);
	}
	else
	{
		m_ok.EnableWindow(FALSE);
	}
}

//##ModelId=3FB2142D030E
void CMusicaDlg::OnDblclkArchivo() 
{
	if (m_list_musica.GetCurSel() >= 0 && m_edit_nombre.GetWindowTextLength() > 0)
	{
		OnOK();
	}
}

//##ModelId=3FB2142D0316
HBRUSH CMusicaDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	
	if (nCtlColor == CTLCOLOR_DLG)// if (pWnd->GetDlgCtrlID() == IDD_CONFIG_DIALOG)
	{
		return (HBRUSH)m_pincel_ventana.GetSafeHandle();
	}
	else if (nCtlColor == CTLCOLOR_LISTBOX || nCtlColor == CTLCOLOR_EDIT)
	{
		pDC->SetBkColor(RGB(235, 255, 255));
		return (HBRUSH)m_pincel_fondo.GetSafeHandle();
	}
	else
	{
		pDC->SetBkColor(RGB(190, 210, 210));
		return (HBRUSH)m_pincel_ventana.GetSafeHandle();
	}

	return hbr;
}
