//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


// HotTabCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "config.h"
#include "HotTabCtrl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHotTabCtrl

//##ModelId=3FB2142D0367
CHotTabCtrl::CHotTabCtrl()
{
}

//##ModelId=3FB2142D0370
CHotTabCtrl::~CHotTabCtrl()
{
}


BEGIN_MESSAGE_MAP(CHotTabCtrl, CTabCtrl)
	//{{AFX_MSG_MAP(CHotTabCtrl)
	ON_WM_DRAWITEM()
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHotTabCtrl message handlers

//##ModelId=3FB2142D0372
void CHotTabCtrl::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	// TODO: Add your message handler code here and/or call default
	
//	CTabCtrl::OnDrawItem(nIDCtl, lpDrawItemStruct);
}

//##ModelId=3FB2142D0368
void CHotTabCtrl::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	CDC* dc = this->GetDC();

}

//##ModelId=3FB2142D037A
void CHotTabCtrl::OnPaint() 
{
	int i;
	CPaintDC pdc(this); // device context for painting
	CDC dc;
	CBitmap buffer;
	RECT rect;

	GetClientRect(&rect);
	
	dc.CreateCompatibleDC(&pdc);
	buffer.CreateCompatibleBitmap(&pdc, rect.right, rect.bottom);

	dc.SelectObject(&buffer);

//	CPaintDC dc(this);

	COLORREF brillo = RGB(225, 255, 255);
	COLORREF sombra = RGB(70, 92, 92);

	CPen pen_brillo;
	CPen pen_sombra;
	CPen *old_pen;

	pen_brillo.CreatePen(PS_SOLID, 0, brillo);
	pen_sombra.CreatePen(PS_SOLID, 0, sombra);

	old_pen = dc.SelectObject(&pen_brillo);

	CFont font_normal, font_bold;
	CFont *old_font;

	font_normal.CreateFont(14, 0, 0, 0, FW_NORMAL, true, false, false, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, 
		VARIABLE_PITCH | FF_SWISS, NULL);
	font_bold.CreateFont(14, 0, 0, 0, FW_BOLD, true, false, false, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, 
		VARIABLE_PITCH | FF_SWISS, NULL);

	old_font = dc.SelectObject(&font_normal);

	dc.SetTextColor(RGB(80, 100, 100));

	dc.FillSolidRect(&rect, RGB(190, 210, 210));

	CString text;
	RECT item_rect;
	int item_height = 0;
	for(i=0; i<GetItemCount(); i++)
	{
		char text[100];
		TCITEM item;
		item.mask = TCIF_TEXT | TCIF_STATE;
		item.dwStateMask = TCIS_HIGHLIGHTED;
		item.pszText = text;
		item.cchTextMax = 100;

		GetItem(i, &item);

		GetItemRect(i, &item_rect);
		if (item_rect.bottom > item_height) item_height = item_rect.bottom;
		if (GetCurSel() != i)
		{
			if (this->GetItemState(i, TCIS_HIGHLIGHTED) == TCIS_HIGHLIGHTED)
			{
				dc.FillSolidRect(&item_rect, RGB(200, 220, 220));
			}
			else
			{
				dc.FillSolidRect(&item_rect, RGB(170, 196, 196));
			}

			dc.MoveTo(item_rect.left, item_rect.bottom-1);
			dc.SelectObject(pen_brillo);
			dc.LineTo(item_rect.left, item_rect.top);
			dc.LineTo(item_rect.right-1, item_rect.top);
			dc.SelectObject(pen_sombra);
			dc.LineTo(item_rect.right-1, item_rect.bottom-1);
			dc.SelectObject(&font_normal);
			dc.DrawText(text, &item_rect, DT_SINGLELINE | DT_CENTER | DT_END_ELLIPSIS | DT_VCENTER);
		}
	}

	rect.top = item_height;
	dc.Draw3dRect(&rect, brillo, sombra);


	//RGB(200, 220, 220);

	i = GetCurSel();
	if (i >= 0)
	{
		char text[100];
		TCITEM item;
		item.mask = TCIF_TEXT | TCIF_STATE;
		item.pszText = text;
		item.cchTextMax = 100;

		GetItem(i, &item);

		GetItemRect(i, &item_rect);
		item_rect.top -= 2;
		item_rect.bottom += 1;
		item_rect.left -= 2;
		item_rect.right += 2;
		dc.FillSolidRect(&item_rect, RGB(190, 210, 210));

		dc.MoveTo(item_rect.left, item_rect.bottom-1);
		dc.SelectObject(pen_brillo);
		dc.LineTo(item_rect.left, item_rect.top);
		dc.LineTo(item_rect.right-1, item_rect.top);
		dc.SelectObject(pen_sombra);
		dc.LineTo(item_rect.right-1, item_rect.bottom-1);
		dc.SelectObject(&font_bold);
		dc.DrawText(text, &item_rect, DT_SINGLELINE | DT_CENTER | DT_END_ELLIPSIS | DT_VCENTER);
	}

//	pdc.BitBlt(rect.left, rect.top, rect.right-rect.left, rect.bottom-rect.top, &dc, rect.left, rect.bottom, SRCCOPY);
	pdc.BitBlt(0, 0, rect.right, rect.bottom, &dc, 0, 0, SRCCOPY);
	
	dc.SelectObject(old_pen);

	pen_brillo.DeleteObject();
	pen_sombra.DeleteObject();

	dc.SelectObject(old_font);

	font_normal.DeleteObject();
	font_bold.DeleteObject();

	dc.DeleteDC();
	buffer.DeleteObject();
}
