//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


// HotListBox.cpp : implementation file
//

#include "stdafx.h"
#include "config.h"
#include "HotListBox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHotListBox

//##ModelId=3FB2142D0398
CHotListBox::CHotListBox()
{
}

//##ModelId=3FB2142D03A4
CHotListBox::~CHotListBox()
{
}


BEGIN_MESSAGE_MAP(CHotListBox, CListBox)
	//{{AFX_MSG_MAP(CHotListBox)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHotListBox message handlers

//##ModelId=3FB2142D0399
void CHotListBox::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	int item = lpDrawItemStruct->itemID;
	int state = lpDrawItemStruct->itemState;
	CDC dc;
	RECT rect = lpDrawItemStruct->rcItem;

	dc.Attach(lpDrawItemStruct->hDC);

	CBrush select_brush;
	select_brush.CreateSolidBrush(RGB(127, 196, 255));
	CBrush normal_brush;
	normal_brush.CreateSolidBrush(RGB(235, 255, 255));

	dc.SetBkMode(TRANSPARENT);

	if (state & ODS_SELECTED)
	{
		dc.FillRect(&rect, &select_brush);
	}
	else
	{
		dc.FillRect(&rect, &normal_brush);
	}

	if (state & ODS_FOCUS)
	{
		dc.Draw3dRect(&rect, RGB(0, 0, 255), RGB(0, 0, 255));
	}

	RECT text_rect = rect;
	text_rect.left += 3;
	text_rect.right -= 3;
	if (item > -1)
	{
		CString text;

		GetText(item, text);

		dc.DrawText(text, &text_rect, DT_END_ELLIPSIS | DT_NOPREFIX | DT_SINGLELINE | DT_VCENTER);
	}

	select_brush.DeleteObject();
	normal_brush.DeleteObject();

	dc.Detach();
}

//##ModelId=3FB2142D039C
void CHotListBox::MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct) 
{
	// TODO: Add your code to determine the size of specified item
	
}
