//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


// HotButton.cpp : implementation file
//

#include "stdafx.h"
#include "config.h"
#include "HotButton.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHotButton

//##ModelId=3FB2142E0002
CHotButton::CHotButton()
{
	font.CreateFont(14, 0, 0, 0, FW_BOLD, true, false, false, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, 
		VARIABLE_PITCH | FF_SWISS, NULL);
	hot = false;
}

//##ModelId=3FB2142E000D
CHotButton::~CHotButton()
{
	font.DeleteObject();
}


BEGIN_MESSAGE_MAP(CHotButton, CButton)
	//{{AFX_MSG_MAP(CHotButton)
	ON_WM_TIMER()
	ON_WM_MOUSEMOVE()
	ON_WM_CAPTURECHANGED()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHotButton message handlers

//##ModelId=3FB2142E000A
void CHotButton::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	CDC *pdc = this->GetDC();
	CDC *dc = new CDC;
	CString text;
	CBitmap buffer;
	RECT rect;

	this->GetClientRect(&rect);

	buffer.CreateCompatibleBitmap(pdc, rect.right, rect.bottom);

	dc->CreateCompatibleDC(pdc);

	dc->SelectObject(&buffer);

	GetWindowText(text);

	RECT elevado_rect;
	elevado_rect.bottom = rect.bottom-2;
	elevado_rect.left = rect.left;
	elevado_rect.right = rect.right-2;
	elevado_rect.top = rect.top;

	RECT pushed_rect;
	pushed_rect.bottom = rect.bottom;
	pushed_rect.left = rect.left+2;
	pushed_rect.right = rect.right;
	pushed_rect.top = rect.top+2;

	RECT sombra_rect;
	sombra_rect.bottom = rect.bottom;
	sombra_rect.left = rect.left+4;
	sombra_rect.right = rect.right;
	sombra_rect.top = rect.top+4;

	COLORREF brillo = RGB(225, 255, 255);
	COLORREF sombra = RGB(150, 170, 170);

	CBrush *ant_pincel;
	CBrush pincel;

	if (lpDrawItemStruct->itemState & ODS_FOCUS)
	{
		dc->FillSolidRect(&rect, RGB(200, 225, 225));
	}
	else
	{
		if (hot)
		{
			dc->FillSolidRect(&rect, RGB(180, 216, 216));
		}
		else
		{
			dc->FillSolidRect(&rect, RGB(170, 196, 196));
		}
	}
	dc->SetBkMode(TRANSPARENT);

	ant_pincel = dc->SelectObject(&pincel);

	COLORREF col_texto;

	if (lpDrawItemStruct->itemState & ODS_DISABLED)
	{
		col_texto = RGB(100, 120, 120);
	}
	else
	{
		col_texto = RGB(80, 100, 100);
	}

	CPen p;

	CFont *old_font;

	old_font = dc->SelectObject(&font);

	POINT point;
	point.x = 10;
	point.y = 10;

	if (lpDrawItemStruct->itemState & ODS_SELECTED)
	{
		dc->Draw3dRect(&rect, sombra, brillo);
		dc->SetTextColor(col_texto);
		dc->DrawText(text, &pushed_rect, DT_CENTER | DT_SINGLELINE | DT_VCENTER);
	}
	else
	{
		if (hot)
			dc->Draw3dRect(&rect, brillo, sombra);

		if (hot)
		{
			dc->SetTextColor(RGB(140, 160, 160));
			dc->DrawText(text, &sombra_rect, DT_CENTER | DT_SINGLELINE | DT_VCENTER);
			dc->SetTextColor(col_texto);
			dc->DrawText(text, &elevado_rect, DT_CENTER | DT_SINGLELINE | DT_VCENTER);
		}
		else
		{
			if (lpDrawItemStruct->itemState & ODS_DISABLED)
			{
				dc->SetTextColor(RGB(200, 220, 220));
				dc->DrawText(text, &pushed_rect, DT_CENTER | DT_SINGLELINE | DT_VCENTER);
				dc->SetTextColor(col_texto);
				dc->DrawText(text, &rect, DT_CENTER | DT_SINGLELINE | DT_VCENTER);
			}
			else
			{
				dc->SetTextColor(col_texto);
				dc->DrawText(text, &rect, DT_CENTER | DT_SINGLELINE | DT_VCENTER);
			}
		}
	}

	dc->SelectObject(old_font);
	dc->SelectObject(ant_pincel);

	pdc->BitBlt(0, 0, rect.right, rect.bottom, dc, 0, 0, SRCCOPY);

	dc->DeleteDC();
	delete dc;

	buffer.DeleteObject();
	pincel.DeleteObject();
}

//##ModelId=3FB2142E001F
void CHotButton::OnTimer(UINT nIDEvent) 
{
	this->Invalidate(TRUE);

	CButton::OnTimer(nIDEvent);
}

//##ModelId=3FB2142E0029
void CHotButton::OnMouseMove(UINT nFlags, CPoint point) 
{
	RECT cr;
	GetClientRect(&cr);

	CRect c;

	
	if (PtInRect(&cr, (POINT)point))
	{
		if (hot == false)
		{
			hot = true;
			Invalidate(FALSE);
			SetCapture();
		}
	}
	else if (hot == true && !(nFlags & MK_LBUTTON))
	{
		ReleaseCapture();
	}
	
	CButton::OnMouseMove(nFlags, point);
}

//##ModelId=3FB2142E0033
void CHotButton::OnCaptureChanged(CWnd *pWnd) 
{
	if (!pWnd || pWnd->m_hWnd != this->m_hWnd)
	{
		if (hot == true)
		{
			hot = false;
			Invalidate(FALSE);
		}
	}
	
	CButton::OnCaptureChanged(pWnd);
}
