//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


// ConfigDlg.cpp : implementation file
//


#include "stdafx.h"
#include "Config.h"
#include "AlFunc.h"
#include "ConfigDlg.h"
#include "MusicaDlg.h"
#include "AboutDlg.h"

#include "getdxver.h"

#define INLINE inline
#include "template.h"

extern ALTEXT_Template tetris_tpl;


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// Makes the 24bpp radio button always disabled.
// TU doesn't look good in 24bpp mode
#define NO_24_BPP_SUPPORT 1

/////////////////////////////////////////////////////////////////////////////
// CConfigDlg dialog

//##ModelId=3FB2142F011A
CConfigDlg::CConfigDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConfigDlg)
	m_sonido = FALSE;
	m_musica = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	translation = NULL;
}

//##ModelId=3FB2143100B9
void CConfigDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigDlg)
	DDX_Control(pDX, IDC_LIST_IDIOMA, m_idiomas);
	DDX_Control(pDX, IDC_MUSICA_DEL, m_musica_del);
	DDX_Control(pDX, IDC_MUSICA_AB, m_musica_ab);
	DDX_Control(pDX, IDC_MUSICA_AR, m_musica_ar);
	DDX_Control(pDX, IDC_MUSICA_ADD, m_musica_add);
	DDX_Control(pDX, IDC_BUTTON_WAV_TEST, m_sonido_test);
	DDX_Control(pDX, IDC_BUTTON_MIDI_TEST, m_musica_test);
	DDX_Control(pDX, IDCANCEL, m_Cancelar);
	DDX_Control(pDX, IDOK, m_Aceptar);
	DDX_Control(pDX, IDC_TAB, m_tab);
	DDX_Control(pDX, IDC_DIRECTX_VER, m_static_directx_ver);
	DDX_Control(pDX, IDC_SOFTWARE, m_frame_software);
	DDX_Control(pDX, IDC_SO_NAME, m_static_so_name);
	DDX_Control(pDX, IDC_OPCIONES_GRAFICAS, m_opciones_graficas);
	DDX_Control(pDX, IDC_DES_HW_ACCEL, m_des_hw_accel);
	DDX_Control(pDX, IDC_COMBO_MODO_ACT, m_combo_modo_act);
	DDX_Control(pDX, IDC_MODO_ACT, m_modo_act);
	DDX_Control(pDX, IDC_STATIC_CAL_SIS_PART, m_static_cal_sist_part);
	DDX_Control(pDX, IDC_SLIDER_CAL_SIS_PART, m_slider_cal_sist_part);
	DDX_Control(pDX, IDC_INSTALL, m_frame_idiomas);
	DDX_Control(pDX, IDC_EDIT_FONDOS, m_path_backgrounds);
	DDX_Control(pDX, IDC_PFONDOS, m_p_backgrounds);
	DDX_Control(pDX, IDC_BUTTON_P_FONDOS, m_button_p_backgrounds);
	DDX_Control(pDX, IDC_BUTTON_P_TEXTS, m_button_p_texts);
	DDX_Control(pDX, IDC_BUTTON_P_PLAYERS, m_button_p_players);
	DDX_Control(pDX, IDC_BUTTON_P_PIECES, m_button_p_pieces);
	DDX_Control(pDX, IDC_BUTTON_P_DATA, m_button_p_data);
	DDX_Control(pDX, IDC_BUTTON_P_MUSIC, m_button_p_music);
	DDX_Control(pDX, IDC_SONIDO, m_frame_sonido);
	DDX_Control(pDX, IDC_RUTAS, m_frame_rutas);
	DDX_Check(pDX, IDC_CHECK_FX, m_sonido);
	DDX_Check(pDX, IDC_CHECK_MIDI, m_musica);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CConfigDlg, CDialog)
	//{{AFX_MSG_MAP(CConfigDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CTLCOLOR()
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB, OnSelchangeTab)
	ON_WM_MOUSEMOVE()
	ON_WM_NCMOUSEMOVE()
	ON_WM_NCHITTEST()
	ON_BN_CLICKED(IDC_MUSICA_ADD, OnMusicaAdd)
	ON_NOTIFY(NM_DBLCLK, IDC_LISTA_MUSICA, OnDblclkListaMusica)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDC_LISTA_MUSICA, OnEndlabeleditListaMusica)
	ON_NOTIFY(TCN_SELCHANGING, IDC_TAB, OnSelchangingTab)
	ON_BN_CLICKED(IDC_MUSICA_DEL, OnMusicaDel)
	ON_BN_CLICKED(IDC_BUTTON_MIDI_TEST, OnButtonMidiTest)
	ON_BN_CLICKED(IDC_BUTTON_WAV_TEST, OnButtonWavTest)
	ON_WM_HSCROLL()
	ON_CBN_SELCHANGE(IDC_COMBO_MIDI, OnSelchangeComboMidi)
	ON_BN_CLICKED(IDC_MUSICA_AR, OnMusicaAr)
	ON_BN_CLICKED(IDC_MUSICA_AB, OnMusicaAb)
	ON_LBN_SELCHANGE(IDC_LIST_IDIOMA, OnSelchangeListIdioma)
	ON_BN_CLICKED(IDC_BUTTON_P_MUSIC, OnButtonPMusic)
	ON_BN_CLICKED(IDC_BUTTON_P_PIECES, OnButtonPPieces)
	ON_BN_CLICKED(IDC_BUTTON_P_PLAYERS, OnButtonPPlayers)
	ON_BN_CLICKED(IDC_BUTTON_P_DATA, OnButtonPData)
	ON_BN_CLICKED(IDC_BUTTON_P_TEXTS, OnButtonPTexts)
	ON_BN_CLICKED(IDC_BUTTON_P_FONDOS, OnButtonPFondos)
	ON_CBN_SELCHANGE(IDC_COMBO_RESOLUCION, OnSelchangeComboResolucion)
	ON_EN_CHANGE(IDC_EDIT_TEXTOS, OnChangeEditTextos)
	ON_WM_SYSCOMMAND()
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigDlg message handlers

//##ModelId=3FB214310113
BOOL CConfigDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	int bpp;
	int midi_vol;
	int digi_vol;


	CMenu* system_menu;

	system_menu = GetSystemMenu(FALSE);

	system_menu->AppendMenu(MF_SEPARATOR | MF_ENABLED | MF_UNCHECKED,
		0, "");
	system_menu->AppendMenu(MF_STRING | MF_ENABLED | MF_UNCHECKED,
		10, "&Acerca de...");

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	CMyButton::ayuda = &m_ayuda;
	CMyEdit::ayuda = &m_ayuda;
	CMyStatic::ayuda = &m_ayuda;
	CMyListCtrl::ayuda = &m_ayuda;
	CMySliderCtrl::ayuda = &m_ayuda;
	CMyComboBox::ayuda = &m_ayuda;
	CMyListBox::ayuda = &m_ayuda;

	m_music_dir = "";

	m_ayuda.SubclaseStatic(IDC_AYUDA, this);
//	m_AD_Inicio.SubclaseButton( IDC_AD_INICIO, this );
//	m_AD_Escritorio.SubclaseButton( IDC_AD_ESCRITORIO, this );
//	m_Reset.SubclaseButton(IDC_RESET, this);
	m_p_data.SubclaseStatic(IDC_PDATOS, this);
	m_p_music.SubclaseStatic(IDC_PMUSICA, this);
	m_p_pieces.SubclaseStatic(IDC_PPIEZAS, this);
	m_p_players.SubclaseStatic(IDC_PJUGADORES, this);
	m_p_text.SubclaseStatic(IDC_PTEXTOS, this);
	m_path_data.SubclaseEdit(IDC_EDIT_DATOS, this);
	m_path_music.SubclaseEdit(IDC_EDIT_MUSICA, this);
	m_path_pieces.SubclaseEdit(IDC_EDIT_PIEZAS, this);
	m_path_players.SubclaseEdit(IDC_EDIT_JUGADORES, this);
	m_path_text.SubclaseEdit(IDC_EDIT_TEXTOS, this);

	m_radio15.SubclaseButton(IDC_C15, this);
	m_radio16.SubclaseButton(IDC_C16, this);
	m_radio24.SubclaseButton(IDC_C24, this);
	m_radio32.SubclaseButton(IDC_C32, this);
	m_full_scr.SubclaseButton(IDC_FULL_SCR, this);
	m_resolucion_label.SubclaseStatic(IDC_STATIC_RESOLUCION, this);
	m_resolucion.SubclaseCombo(IDC_COMBO_RESOLUCION, this);

	m_musica_driver.SubclaseCombo(IDC_COMBO_MIDI, this);
	m_sonido_driver.SubclaseCombo(IDC_COMBO_FX, this);
	m_musica_check.SubclaseButton(IDC_CHECK_MIDI, this);
	m_sonido_check.SubclaseButton(IDC_CHECK_FX, this);
	m_musica_vol_label.SubclaseStatic(IDC_STATIC_VOL_MIDI, this);
	m_sonido_vol_label.SubclaseStatic(IDC_STATIC_VOL_FX, this);
	m_musica_vol.SubclaseSlider(IDC_VOL_MIDI, this);
	m_sonido_vol.SubclaseSlider(IDC_VOL_FX, this);
	m_lista_musica.SubclaseListCtrl(IDC_LISTA_MUSICA, this);

	m_lista_musica.InsertColumn(0, "", LVCFMT_LEFT, 144);
	m_lista_musica.InsertColumn(1, "", LVCFMT_LEFT, 100);

	m_musica_vol.SetRange(0, 51);
	m_sonido_vol.SetRange(0, 51);

	m_lista_musica.SetExtendedStyle(0
//		| LVS_EX_FULLROWSELECT
//		| LVS_EX_TWOCLICKACTIVATE
//		| LVS_EX_GRIDLINES
//		| LVS_EX_ONECLICKACTIVATE
		| LVS_EX_TRACKSELECT
//		| LVS_EX_UNDERLINEHOT
	);

	m_lista_musica.GetHeaderCtrl()->ModifyStyle(0, HDS_HOTTRACK);
	m_lista_musica.GetHeaderCtrl()->EnableWindow(FALSE);

	m_slider_cal_sist_part.SetRange(1, 5);
	
	init_all(m_hWnd);
	ALTEXT_Init();

	directx_version = GetDXVersion();

//	UpdateLanguages();

	find_sound_drivers(&m_musica_driver, &m_sonido_driver);

	m_musica_driver.SetCurSel(get_midi_driver_index(get_id("sound", "midi_card", -1)));
	m_sonido_driver.SetCurSel(get_digi_driver_index(get_id("sound", "digi_card", -1)));

	al_fpu = get_cpu_fpu();
	al_cmov = get_cpu_cmov();
	al_mmx = get_cpu_mmx();
	al_mmxplus = get_cpu_mmxplus();
	al_sse = get_cpu_sse();
	al_sse2 = get_cpu_sse2();
	al_3dnow = get_cpu_3dnow();
	al_enh3dnow = get_cpu_enh3dnow();

	strcpy (path_music,       get_string("paths", "music", "./musica"));
	strcpy (path_pieces,      get_string("paths", "pieces", "./piezas"));
	strcpy (path_players,     get_string("paths", "players", "./jugadores"));
	strcpy (path_data,        get_string("paths", "data", "./data"));
	strcpy (path_backgrounds, get_string("paths", "backgrounds", "./fondos"));
	strcpy (path_text,        get_string("paths", "text", "./text"));

	m_musica = get_int("sound", "music", 1);
	m_sonido = get_int("sound", "soundfx", 1);
	midi_vol = get_int("sound", "midi_volume", 127);
	digi_vol = get_int("sound", "digi_volume", 127);
	bpp = get_int("graphics", "bpp", -1);
	int resolution_x = get_int("graphics", "width", 640);
	int resolution_y = get_int("graphics", "height", 480);
	fullscreen = get_int("graphics", "fullscreen", 1);
	modo_actualizacion = get_int("graphics", "refresh_mode", 0);
	desactivar_aceleracion = get_int("graphics", "disable_hw_acceleration", 0);
	calidad_particulas = get_int("graphics", "particle_quality", 3);

	char lan[3];
	
	UpdateLanguages();

	strncpy(lan, get_string("system", "language", "es"), 2);
	lan[2] = '\0';

	long i;

/*	i=0;
	while (i<8 && (res_x[i] != resolution_x || res_y[i] != resolution_y)) i++;

	if (i<8)
	{
		m_resolucion.SetCurSel(i);
	}
	else
	{
		m_resolucion.SetCurSel(0);
	}
*/
	set_vol(digi_vol, midi_vol);

	m_musica_vol.SetPos(midi_vol/5);
	m_sonido_vol.SetPos(digi_vol/5);

	resoluciones = get_lista_resoluciones(num_resoluciones);

	if (resoluciones == NULL)
	{
		resoluciones = new al_resolucion[1];
		resoluciones[0].width = 640;
		resoluciones[1].height = 480;
		num_resoluciones = 1;
	}

	get_valid_bpp (resoluciones[0], c15, c16, c24, c32);
	
	char str_res[14];

	for(i=0; i<num_resoluciones; i++)
	{
		sprintf(str_res, "%d x %d", resoluciones[i].width, resoluciones[i].height);
		m_resolucion.AddString(str_res);
		if (resoluciones[i].width == resolution_x &&
			resoluciones[i].height == resolution_y)
		{
			m_resolucion.SetCurSel(i);
			get_valid_bpp (resoluciones[i], c15, c16, c24, c32);
		}
	}

	m_path_music.SetWindowText(path_music);
	m_path_pieces.SetWindowText(path_pieces);
	m_path_players.SetWindowText(path_players);
	m_path_data.SetWindowText(path_data);
	m_path_backgrounds.SetWindowText(path_backgrounds);
	m_path_text.SetWindowText(path_text);

	bool check = true;

//	radio15 = (CButton *)GetDlgItem(IDC_C15);
//	radio16 = (CButton *)GetDlgItem(IDC_C16);
//	radio24 = (CButton *)GetDlgItem(IDC_C24);
//	radio32 = (CButton *)GetDlgItem(IDC_C32);

	if (!c15) m_radio15.EnableWindow(false);
	if (!c16) m_radio16.EnableWindow(false);
	if (!c24) m_radio24.EnableWindow(false);
	if (!c32) m_radio32.EnableWindow(false);

#ifdef NO_24_BPP_SUPPORT
	m_radio24.EnableWindow(false);
#endif

	switch (bpp)
	{
	case 15:
		if (c15) m_radio15.SetCheck(1);
		else bpp = -1;
		break;
	case 16:
		if (c16) m_radio16.SetCheck(1);
		else bpp = -1;
		break;
	case 24:
		if (c24) m_radio24.SetCheck(1);
		else bpp = -1;
		break;
	case 32:
		if (c32) m_radio32.SetCheck(1);
		else bpp = -1;
		break;
	default: bpp = -1;
	}

	if (bpp == -1)
	{
		if (c15) m_radio15.SetCheck(1);
		else if (c16) m_radio16.SetCheck(1);
		else if (c24) m_radio24.SetCheck(1);
		else if (c32) m_radio32.SetCheck(1);
	}

	if (fullscreen >= 1)
	{
		m_full_scr.SetCheck(1);
	}
	else
	{
		m_full_scr.SetCheck(0);
	}

	m_combo_modo_act.SetCurSel(modo_actualizacion);
	m_slider_cal_sist_part.SetPos(calidad_particulas);
	m_des_hw_accel.SetCheck(desactivar_aceleracion);

	UpdateData(false);

	CSize size;

	size.cx = 140;
	size.cy = 18;

	m_tab.SetItemSize(size);

	TC_ITEM pagina;
	char *pestanas[] = {"General", "Graficos", "Sonido", "Informacin", NULL};
	for (i=0; pestanas[i]; i++)
	{
		pagina.mask = TCIF_TEXT;
		pagina.pszText = pestanas[i];
		pagina.cchTextMax = strlen(pestanas[i]);
		m_tab.InsertItem(i, &pagina);
	}

	i=0;
	while (i<languages.GetCount())
	{
		CString f;
		CString l = lan;
		languages.Lookup(i, f);
		f = f.Left(2);
		f.MakeUpper();
		l.MakeUpper();
		if (f == l)
		{
			break;
		}
		i++;
	}
	if (i<languages.GetCount())
	{
		int j=0;
		while (j<m_idiomas.GetCount() && m_idiomas.GetItemData(j) != i)
		{
			j++;
		}
		if (j < m_idiomas.GetCount())
		{
			m_idiomas.SetCurSel(j);
		}
		else
		{
			m_idiomas.SetCurSel(0);
		}
	}
	else
	{
		m_idiomas.SetCurSel(0);
	}
	LoadSelectedTranslation();

	CString so_name;

	GetWindowsVersion(so_name);

	m_static_so_name.SetWindowText(LPCSTR(so_name));

	MostrarControles();

	COLORREF m_color;
	m_color = RGB(190, 210, 210);
	m_pincel_ventana.CreateSolidBrush(m_color);

	m_color = 0xe1ffff;
	m_pincel.CreateSolidBrush(m_color);

	m_pincel_fondo.CreateSolidBrush(RGB(235, 255, 255));

	((CConfigApp*)AfxGetApp())->loading_dlg->DestroyWindow();
	delete ((CConfigApp*)AfxGetApp())->loading_dlg;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

//##ModelId=3FB21431011D
void CConfigDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
//##ModelId=3FB21431011F
HCURSOR CConfigDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

//##ModelId=3FB2142F0127
CString& CConfigDlg::AppendPathSeparator(CString &str)
{
	if (str[str.GetLength()-1] != '\\' &&
		str[str.GetLength()-1] != '/')
	{
		str += '/';
	}

	return str;
}

//##ModelId=3FB214310128
HBRUSH CConfigDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	
	if (pWnd->GetDlgCtrlID() == IDC_FPU)
	{
		if (al_fpu)
		{
			pDC->SetTextColor( RGB(0,127,0) );
		}
		else
		{
			pDC->SetTextColor( RGB(255,0,0) );
		}
	}
	else if (pWnd->GetDlgCtrlID() == IDC_CMOV)
	{
		if (al_cmov)
		{
			pDC->SetTextColor( RGB(0,127,0) );
		}
		else
		{
			pDC->SetTextColor( RGB(255,0,0) );
		}
	}
	else if (pWnd->GetDlgCtrlID() == IDC_MMX)
	{
		if (al_mmx)
		{
			pDC->SetTextColor( RGB(0,127,0) );
		}
		else
		{
			pDC->SetTextColor( RGB(255,0,0) );
		}
	}
	else if (pWnd->GetDlgCtrlID() == IDC_MMXPLUS)
	{
		if (al_mmxplus)
		{
			pDC->SetTextColor( RGB(0,127,0) );
		}
		else
		{
			pDC->SetTextColor( RGB(255,0,0) );
		}
	}
	else if (pWnd->GetDlgCtrlID() == IDC_SSE)
	{
		if (al_sse)
		{
			pDC->SetTextColor( RGB(0,127,0) );
		}
		else
		{
			pDC->SetTextColor( RGB(255,0,0) );
		}
	}
	if (pWnd->GetDlgCtrlID() == IDC_SSE2)
	{
		if (al_sse2)
		{
			pDC->SetTextColor( RGB(0,127,0) );
		}
		else
		{
			pDC->SetTextColor( RGB(255,0,0) );
		}
	}
	else if (pWnd->GetDlgCtrlID() == IDC_3DNOW)
	{
		if (al_3dnow)
		{
			pDC->SetTextColor( RGB(0,127,0) );
		}
		else
		{
			pDC->SetTextColor( RGB(255,0,0) );
		}
	}
	else if (pWnd->GetDlgCtrlID() == IDC_ENH3DNOW)
	{
		if (al_enh3dnow)
		{
			pDC->SetTextColor( RGB(0,127,0) );
		}
		else
		{
			pDC->SetTextColor( RGB(255,0,0) );
		}
	}
	if (pWnd->GetDlgCtrlID() == IDC_AYUDA)
	{
		//pDC->SetTextColor( RGB(0, 0, 0) );
		pDC->SetBkColor( RGB(255, 255, 225) );

		return (HBRUSH)m_pincel.GetSafeHandle();
	}
	else if (nCtlColor == CTLCOLOR_DLG)// if (pWnd->GetDlgCtrlID() == IDD_CONFIG_DIALOG)
	{
		return (HBRUSH)m_pincel_ventana.GetSafeHandle();
	}
	else if (nCtlColor == CTLCOLOR_LISTBOX || nCtlColor == CTLCOLOR_EDIT)
	{
		pDC->SetBkColor(RGB(235, 255, 255));
		return (HBRUSH)m_pincel_fondo.GetSafeHandle();
	}
	else
	{
		pDC->SetBkColor(RGB(190, 210, 210));
		return (HBRUSH)m_pincel_ventana.GetSafeHandle();
	}
	
	return hbr;
}

//##ModelId=3FB21431018B
void CConfigDlg::OnOK() 
{
	int bpp;
	char path[200];

	m_path_music.GetWindowText(path, 200);

	if (m_music_dir != path)
	{
		if (m_music_dir != "")
		{
			if (AfxMessageBox (TEXT_config_msg_cambio_ruta_musica(), MB_YESNO | MB_ICONEXCLAMATION) == IDNO)
			{
				return;
			}
		}
	}

//	AfxMessageBox("Hola1");

	CargarMusicaIni();
//	AfxMessageBox("Hola2");
	GuardarMusicaIni();
//	AfxMessageBox("Hola3");

	UpdateData();
//	AfxMessageBox("Hola4");

	if (m_radio15.GetCheck()) bpp = 15;
	else if (m_radio16.GetCheck()) bpp = 16;
	else if (m_radio24.GetCheck()) bpp = 24;
	else if (m_radio32.GetCheck()) bpp = 32;
	else bpp = -1;

	modo_actualizacion = m_combo_modo_act.GetCurSel();
	desactivar_aceleracion = m_des_hw_accel.GetCheck();
	calidad_particulas = m_slider_cal_sist_part.GetPos();

	if (m_full_scr.GetCheck()) fullscreen = 1;
	else fullscreen = 0;

	m_path_music.GetWindowText(path_music, 99);
	m_path_pieces.GetWindowText(path_pieces, 99);
	m_path_players.GetWindowText(path_players, 99);
	m_path_data.GetWindowText(path_data, 99);
	m_path_backgrounds.GetWindowText(path_backgrounds, 99);
	m_path_text.GetWindowText(path_text, 99);

	long t = m_idiomas.GetCurSel();

	if (t>=0)
	{
		CString lan_name;
		t = m_idiomas.GetItemData(t);
		languages.Lookup(t, lan_name);
		lan_name = lan_name.Left(2);
		lan_name.MakeLower();
		set_string ("system", "language", LPCSTR(lan_name));
	}


	set_string ("paths", "music",   path_music);
	set_string ("paths", "pieces",  path_pieces);
	set_string ("paths", "players", path_players);
	set_string ("paths", "data",    path_data);
	set_string ("paths", "text",    path_text);
	set_string ("paths", "backgrounds",    path_backgrounds);
	set_int	("sound", "music",		m_musica ? 1 : 0);
	set_int ("sound", "soundfx",	m_sonido ? 1 : 0);
	set_id ("sound", "midi_card",	get_midi_driver_id(m_musica_driver.GetCurSel()));
	set_id ("sound", "digi_card",	get_digi_driver_id(m_sonido_driver.GetCurSel()));
	set_int ("sound", "digi_volume", get_digi_vol());
	set_int ("sound", "midi_volume", get_midi_vol());
	set_int ("graphics", "bpp",		bpp);
	set_int ("graphics", "fullscreen", fullscreen);
	set_int ("graphics", "width", resoluciones[m_resolucion.GetCurSel()].width);
	set_int ("graphics", "height", resoluciones[m_resolucion.GetCurSel()].height);
	set_int("graphics", "refresh_mode", modo_actualizacion);	
	set_int("graphics", "disable_hw_acceleration", desactivar_aceleracion);
	set_int("graphics", "particle_quality", calidad_particulas);

	close_all();

	CDialog::OnOK();
}

//##ModelId=3FB2142F0160
void CConfigDlg::MostrarControles()
{
	int controles[] = { 
		IDC_RUTAS,
		IDC_PMUSICA,
		IDC_PPIEZAS,
		IDC_PJUGADORES,
		IDC_PDATOS,
		IDC_PFONDOS,
		IDC_PTEXTOS,
		IDC_EDIT_MUSICA,
		IDC_BUTTON_P_MUSIC,
		IDC_EDIT_PIEZAS,
		IDC_BUTTON_P_PIECES,
		IDC_EDIT_JUGADORES,
		IDC_BUTTON_P_PLAYERS,
		IDC_EDIT_DATOS,
		IDC_BUTTON_P_DATA,
		IDC_EDIT_FONDOS,
		IDC_BUTTON_P_FONDOS,
		IDC_EDIT_TEXTOS,
		IDC_BUTTON_P_TEXTS,
		IDC_INSTALL,
		IDC_LIST_IDIOMA,
		0,
		IDC_VIDEO,
		IDC_FULL_SCR,
		IDC_STATIC_RESOLUCION,
		IDC_COMBO_RESOLUCION,
		IDC_MODO_ACT,
		IDC_COMBO_MODO_ACT,
		IDC_C15,
		IDC_C16,
		IDC_C24,
		IDC_C32,
		IDC_DES_HW_ACCEL,
		IDC_OPCIONES_GRAFICAS,
		IDC_STATIC_CAL_SIS_PART,
		IDC_SLIDER_CAL_SIS_PART,
		0,
		IDC_SONIDO,
		IDC_CHECK_MIDI,
		IDC_COMBO_MIDI,
		IDC_STATIC_VOL_MIDI,
		IDC_VOL_MIDI,
		IDC_BUTTON_MIDI_TEST,
		IDC_CHECK_FX,
		IDC_COMBO_FX,
		IDC_STATIC_VOL_FX,
		IDC_BUTTON_WAV_TEST,
		IDC_VOL_FX,
		IDC_LISTA_MUSICA,
		IDC_MUSICA_ADD,
		IDC_MUSICA_AR,
		IDC_MUSICA_AB,
		IDC_MUSICA_DEL,
		0,
		IDC_CPU,
		IDC_FPU,
		IDC_CMOV,
		IDC_MMX,
		IDC_MMXPLUS,
		IDC_SSE,
		IDC_SSE2,
		IDC_3DNOW,
		IDC_ENH3DNOW,
		IDC_SOFTWARE,
		IDC_SO_NAME,
		IDC_DIRECTX_VER,
		0,
		0
	};

	int i=0, pag=0, pag_mostrar=m_tab.GetCurSel();

	while (controles[i])
	{
		int mostrar_ocultar = (pag == pag_mostrar ? SW_SHOW : SW_HIDE);
		do
		{
			GetDlgItem(controles[i])->ShowWindow(mostrar_ocultar);
		} while (controles[++i]);

		i++;
		pag++;
	}

	if (pag_mostrar != 2)
	{
		if (midi_playing())
		{
			m_musica_test.SetWindowText(TEXT_config_test());
			BeginWaitCursor();
			midi_test(m_musica_driver.GetCurSel());
			EndWaitCursor();
		}
	}
}

//##ModelId=3FB2142F017E
char *CConfigDlg::leer_linea(char *buf, int n, FILE *fp)
{
	int i;
	int c;

	i = 0;
	do
	{
		c = fgetc(fp);
		buf[i] = c;
		i++;
	} while (c != EOF && c != '\n' && c != '\r' && i<n);

	switch (c)
	{
	case '\r':
		if (fgetc(fp) != '\n')
		{
			fseek(fp, -1, SEEK_CUR);
		}
		break;
	case '\n':
		break;
	}

	buf[i-1] = '\0';

	if (i==1 && c==EOF) return NULL;
	else return buf;
}

//##ModelId=3FB214310195
void CConfigDlg::OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	MostrarControles();
	
	CargarMusicaIni();

	*pResult = 0;
}

//##ModelId=3FB2142F0161
HRESULT CConfigDlg::CreateLink(LPCSTR lpszPathObj, LPCSTR lpszWorkDir,
    LPSTR lpszPathLink, LPSTR lpszDesc) 
{ 
    HRESULT hres; 
    IShellLink* psl; 
 
    hres = CoCreateInstance(CLSID_ShellLink, NULL, 
        CLSCTX_INPROC_SERVER, IID_IShellLink, (void**)&psl); 
    if (SUCCEEDED(hres)) { 
        IPersistFile* ppf; 
 
        psl->SetPath(lpszPathObj); 
        psl->SetDescription(lpszDesc);
		psl->SetWorkingDirectory(lpszWorkDir);
 
        hres = psl->QueryInterface(IID_IPersistFile, 
            (void**)&ppf); 
 
        if (SUCCEEDED(hres)) { 
            WORD wsz[MAX_PATH]; 
 
            MultiByteToWideChar(CP_ACP, 0, lpszPathLink, -1, 
                wsz, MAX_PATH); 
 
            hres = ppf->Save(wsz, TRUE); 
            ppf->Release(); 
        } 
        psl->Release(); 
    } 
    return hres; 
}

//##ModelId=3FB2142F0174
int CConfigDlg::create_key(HKEY key, char *name, PHKEY key_dest)
{
	DWORD m_id, disp;
	char msg[100];

	if ((m_id = RegCreateKeyEx(key, name, 0, "string", REG_OPTION_NON_VOLATILE, KEY_READ, NULL, key_dest, &disp)) != ERROR_SUCCESS)
	{
		FormatMessage( 
			FORMAT_MESSAGE_FROM_SYSTEM | 
			FORMAT_MESSAGE_IGNORE_INSERTS,
			NULL,
			m_id,
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
			msg,
			99,
			NULL 
		);
		AfxMessageBox(msg, MB_ICONEXCLAMATION);
		return -1;
	}

	return 0;
}
/*
void CConfigDlg::OnAdEscritorio() 
{
	HKEY key;
	DWORD tipo;
	DWORD tam;
	LPBYTE data;
	char* link;

	if (!create_key(HKEY_CURRENT_USER, "Software", &key))
	if (!create_key(key, "Microsoft", &key))
	if (!create_key(key, "Windows", &key))
	if (!create_key(key, "CurrentVersion", &key))
	if (!create_key(key, "Explorer", &key))
	if (!create_key(key, "Shell Folders", &key))
	{
		RegQueryValueEx(key, "Desktop", NULL, &tipo, NULL, &tam);
		data = new BYTE[tam];
		RegQueryValueEx(key, "Desktop", NULL, &tipo, data, &tam);

		link = new char[tam+20];
		sprintf (link, "%s\\Tetris.lnk", data);

		CoUninitialize();
		CoInitialize(NULL);
		CreateLink("e:\\juegos\\tetris\\tetris.exe", "e:\\juegos\\tetris", link, "Tetris");
		CoUninitialize();

		delete [] data;
		delete [] link;

		AfxMessageBox("Acceso directo creado", MB_ICONINFORMATION, -1);
	}
}

void CConfigDlg::OnAdInicio() 
{
	HKEY key;
	DWORD tipo;
	DWORD tam;
	LPBYTE data;
	char* link;
	char path[] = "Tetris";

	if (!create_key(HKEY_CURRENT_USER, "Software", &key))
	if (!create_key(key, "Microsoft", &key))
	if (!create_key(key, "Windows", &key))
	if (!create_key(key, "CurrentVersion", &key))
	if (!create_key(key, "Explorer", &key))
	if (!create_key(key, "Shell Folders", &key))
	{
		RegQueryValueEx(key, "Programs", NULL, &tipo, NULL, &tam);
		data = new BYTE[tam];
		RegQueryValueEx(key, "Programs", NULL, &tipo, data, &tam);

		link = new char[tam+20+strlen(path)];
		sprintf (link, "%s\\%s", data, path);
		_mkdir(link);

		CoUninitialize();
		CoInitialize(NULL);
		sprintf (link, "%s\\%s\\Tetris.lnk", data, path);
		CreateLink("e:\\juegos\\tetris\\tetris.exe", "e:\\juegos\\tetris", link, "Tetris");
		sprintf (link, "%s\\%s\\Configuracin.lnk", data, path);
		CreateLink("e:\\juegos\\tetris\\config.exe", "e:\\juegos\\tetris", link, "Configuracin");
		CoUninitialize();

		delete [] data;
		delete [] link;

		AfxMessageBox("Acceso directo creado", MB_ICONINFORMATION, -1);
	}
}
*/
//##ModelId=3FB2143101DB
void CConfigDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
	
	CDialog::OnMouseMove(nFlags, point);
}

//##ModelId=3FB214310221
void CConfigDlg::OnNcMouseMove(UINT nHitTest, CPoint point) 
{

	CDialog::OnNcMouseMove(nHitTest, point);
}

//##ModelId=3FB214310267
UINT CConfigDlg::OnNcHitTest(CPoint point) 
{
	UINT ret;
	ret = CDialog::OnNcHitTest(point);

/*	char text[200];
	m_ayuda.GetWindowText(text, 200);
	if (strcmp(text, ""))
	{
		sprintf (text, "%d", ret);
		m_ayuda.SetWindowText(text);
	}
*/
	return ret;
}

//##ModelId=3FB21431028F
void CConfigDlg::OnMusicaAdd() 
{
	CMusicaDlg dlg;
	char path[200];

	if (midi_playing())
	{
		m_musica_test.SetWindowText(TEXT_config_test());
		BeginWaitCursor();
		midi_test(m_musica_driver.GetCurSel());
		EndWaitCursor();
	}
	
	dlg.Titulo = TEXT_config_music_add_window();
	dlg.m_archivo = "";
	dlg.m_nombre = "";
	m_path_music.GetWindowText(path, 200);
	dlg.Dir = path;

	dlg.DoModal();
	if (dlg.m_archivo != "" && dlg.m_nombre != "")
	{
		m_lista_musica.InsertItem(m_lista_musica.GetItemCount(), dlg.m_nombre);
		m_lista_musica.SetItemText(m_lista_musica.GetItemCount()-1, 1, dlg.m_archivo);
		m_lista_musica.SetItemState(m_lista_musica.GetItemCount()-1, LVIS_SELECTED, LVIS_SELECTED);
		m_lista_musica.EnsureVisible(m_lista_musica.GetItemCount()-1, false);
	}
}

//##ModelId=3FB21431029A
void CConfigDlg::OnDblclkListaMusica(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CMusicaDlg dlg;
	char path[200];
	POSITION item;
	int pos;
	
	char nombre[51];
	char arc[261];

	if (midi_playing())
	{
		m_musica_test.SetWindowText(TEXT_config_test());
		BeginWaitCursor();
		midi_test(m_musica_driver.GetCurSel());
		EndWaitCursor();
	}

	item = m_lista_musica.GetFirstSelectedItemPosition();
	if (item != NULL)
	{
		pos = m_lista_musica.GetNextSelectedItem(item);

		m_lista_musica.GetItemText(pos, 0, nombre, 50);
		m_lista_musica.GetItemText(pos, 1, arc, 260);

		dlg.Titulo = TEXT_config_music_modify_window();
		dlg.m_nombre = nombre;
		dlg.m_archivo = arc;
		m_path_music.GetWindowText(path, 200);
		dlg.Dir = path;

		dlg.DoModal();
		if (dlg.m_archivo != "" && dlg.m_nombre != "")
		{
			m_lista_musica.SetItemText(pos, 0, dlg.m_nombre);
			m_lista_musica.SetItemText(pos, 1, dlg.m_archivo);
		}
	}
	
	*pResult = 0;
}

//##ModelId=3FB2143102E0
void CConfigDlg::OnEndlabeleditListaMusica(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
	char *text;

	text = pDispInfo->item.pszText;
	if (text != NULL)
	{
		if (strlen(text) > 0)
			if (strlen(text) > 50)
			{
				AfxMessageBox(TEXT_config_error_limite_caracteres(50), MB_ICONEXCLAMATION);
				*pResult = FALSE;
			}
			else
			{
				*pResult = TRUE;
			}
		else
		{
			*pResult = FALSE;
		}
	}
}

//##ModelId=3FB214310326
void CConfigDlg::OnSelchangingTab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	char path[200];

	m_path_music.GetWindowText(path, 200);

	if (m_music_dir != path)
	{
		if (m_music_dir != "")
		{
			if (AfxMessageBox (TEXT_config_msg_cambio_ruta_musica(), MB_YESNO | MB_ICONEXCLAMATION) == IDNO)
			{
				*pResult = TRUE;
				return;
			}
		}
	}

	*pResult = 0;
}

//##ModelId=3FB2142F0158
void CConfigDlg::CargarMusicaIni()
{
	FILE *fp;
	CString file;
	char path[200];
	char name[60];
	char arc[300];
	bool fin = false;
	m_path_music.GetWindowText(path, 200);

	if (strcmp(m_music_dir, path))
	{
		m_music_dir = path;
		m_lista_musica.DeleteAllItems();
		file = CString(path) + CString("\\musica.ini");
		if ((fp = fopen(file, "r")) != NULL)
		{
			while (!fin)
			{
				if (leer_linea(name, 50, fp) != NULL)
				{
					if (leer_linea(arc, 260, fp) != NULL)
					{
						m_lista_musica.InsertItem(m_lista_musica.GetItemCount(), name);
						m_lista_musica.SetItemText(m_lista_musica.GetItemCount()-1, 1, arc);
					}
					else fin = true;
				}
				else fin = true;
			}
			fclose(fp);
		}
	}
}

//##ModelId=3FB2142F0157
bool CConfigDlg::GuardarMusicaIni()
{
	FILE *fp;
	CString file;
	char path[200];
	char name[60];
	char arc[300];
	bool fin = false;

	m_path_music.GetWindowText(path, 200);

	file = CString(path) + CString("\\musica.ini");
	if ((fp = fopen(file, "w")) != NULL)
	{
		for (int i=0; i<m_lista_musica.GetItemCount(); i++)
		{
			m_lista_musica.GetItemText(i, 0, name, 50);
			m_lista_musica.GetItemText(i, 1, arc, 260);
			fprintf(fp, "%s\n", name);
			fprintf(fp, "%s\n", arc);
		}
		fclose(fp);
	}
	else return false;

	return true;
}

//##ModelId=3FB21431036C
void CConfigDlg::OnMusicaDel() 
{
	POSITION item;
	int pos;

	item = m_lista_musica.GetFirstSelectedItemPosition();
	if (item)
	{
		pos = m_lista_musica.GetNextSelectedItem(item);

		m_lista_musica.DeleteItem(pos);
	}
}

//##ModelId=3FB214310376
void CConfigDlg::OnButtonMidiTest() 
{
	BeginWaitCursor();
	if (midi_test(m_musica_driver.GetCurSel()))
	{
		m_musica_test.SetWindowText(TEXT_config_stop());
	}
	else
	{
		m_musica_test.SetWindowText(TEXT_config_test());
	}
	EndWaitCursor();
}

//##ModelId=3FB214310378
void CConfigDlg::OnButtonWavTest() 
{
	if (midi_playing())
	{
		m_musica_test.SetWindowText(TEXT_config_test());
		BeginWaitCursor();
		midi_test(m_musica_driver.GetCurSel());
		EndWaitCursor();
	}
	BeginWaitCursor();
	digi_test(m_sonido_driver.GetCurSel());
	EndWaitCursor();
}

//##ModelId=3FB214310381
void CConfigDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CSliderCtrl* slider = (CSliderCtrl*)pScrollBar;

	if (*slider == m_musica_vol)
	{
		set_vol(-1, slider->GetPos()*5);
	}
	if (*slider == m_sonido_vol)
	{
		set_vol(slider->GetPos()*5, -1);
	}
	
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

//##ModelId=3FB2143103E4
void CConfigDlg::OnSelchangeComboMidi() 
{
	if (midi_playing())
	{
		m_musica_test.SetWindowText(TEXT_config_test());
		BeginWaitCursor();
		midi_test(m_musica_driver.GetCurSel());
		EndWaitCursor();
	}
}

//##ModelId=3FB214320007
void CConfigDlg::OnMusicaAr() 
{
	POSITION item;
	char nombre[101];
	char arch[101];
	char nombre2[101];
	char arch2[101];
	int sel;

	item = m_lista_musica.GetFirstSelectedItemPosition();

	if (item)
	{
		sel = m_lista_musica.GetNextSelectedItem(item);
		if (sel>0)
		{

			m_lista_musica.GetItemText(sel, 0, nombre, 100);
			m_lista_musica.GetItemText(sel, 1, arch, 100);
			m_lista_musica.GetItemText(sel-1, 0, nombre2, 100);
			m_lista_musica.GetItemText(sel-1, 1, arch2, 100);

			m_lista_musica.SetItemText(sel, 0, nombre2);
			m_lista_musica.SetItemText(sel, 1, arch2);
			m_lista_musica.SetItemText(sel-1, 0, nombre);
			m_lista_musica.SetItemText(sel-1, 1, arch);

			m_lista_musica.SetItemState(sel-1, LVIS_SELECTED, LVIS_SELECTED);
			m_lista_musica.EnsureVisible(sel-1, false);
		}
	}
}

//##ModelId=3FB214320010
void CConfigDlg::OnMusicaAb() 
{
	POSITION item;
	char nombre[101];
	char arch[101];
	char nombre2[101];
	char arch2[101];
	int sel;

	item = m_lista_musica.GetFirstSelectedItemPosition();

	if (item)
	{
		sel = m_lista_musica.GetNextSelectedItem(item);
		if (sel<m_lista_musica.GetItemCount()-1)
		{

			m_lista_musica.GetItemText(sel, 0, nombre, 100);
			m_lista_musica.GetItemText(sel, 1, arch, 100);
			m_lista_musica.GetItemText(sel+1, 0, nombre2, 100);
			m_lista_musica.GetItemText(sel+1, 1, arch2, 100);

			m_lista_musica.SetItemText(sel, 0, nombre2);
			m_lista_musica.SetItemText(sel, 1, arch2);
			m_lista_musica.SetItemText(sel+1, 0, nombre);
			m_lista_musica.SetItemText(sel+1, 1, arch);

			m_lista_musica.SetItemState(sel+1, LVIS_SELECTED, LVIS_SELECTED);
			m_lista_musica.EnsureVisible(sel+1, false);
		}
	}	
}

//##ModelId=3FB2142F014C
void CConfigDlg::UpdateLanguages(bool warn_no_translation)
{
	_finddata_t fd;
	long h;
	long c;
	char file[300];
	ALTEXT_Translation *aux_trans;
	long i;

	while (m_idiomas.GetCount())
	{
		m_idiomas.DeleteString(0);
	}
	languages.RemoveAll();

	CString path = path_text;
	AppendPathSeparator(path);

	c = h = _findfirst(LPCSTR(path + CString("*.tra")), &fd);

	if (c<0 && warn_no_translation)
	{
		MessageBox("No hay ninguna traduccin", "Error", MB_ICONSTOP);
	}

	i=0;
	while (c>=0)
	{
		CString path = path_text;
		AppendPathSeparator(path);
		sprintf(file, LPCSTR(path + CString("%s")), fd.name);
		aux_trans = ALTEXT_LoadTranslation(&tetris_tpl, file, 0);
		if (aux_trans)
		{
			ALTEXT_SetTranslation(aux_trans);
			m_idiomas.SetItemData(m_idiomas.AddString(TEXT_language_name()), i);
			ALTEXT_DestroyTranslation(aux_trans);
			languages.SetAt(i, CString(fd.name));
			i++;
		}
		c = _findnext(h, &fd);
	}
}

//##ModelId=3FB2142F012F
void CConfigDlg::LoadSelectedTranslation()
{
	long t;
	CString file;

	t = m_idiomas.GetCurSel();

	if (t<0) t=0;

	t = m_idiomas.GetItemData(t);

	languages.Lookup(t, file);

	CString path = path_text;
	AppendPathSeparator(path);

	file = path + file;

	if (translation)
	{
		ALTEXT_DestroyTranslation(translation);
	}

	translation = ALTEXT_LoadTranslation(&tetris_tpl, LPCSTR(file), 0);

	if (!translation)
	{
		if (m_idiomas.GetCount() > 0)
		{
			MessageBox("Error al abrir la traduccin", "Error", MB_ICONSTOP);
		}
		translation = ALTEXT_CreateTranslation(&tetris_tpl);
		ALTEXT_SetTranslation(translation);
//		this->DestroyWindow();
	}
//	else
	{
		bool first_selected;
		ALTEXT_SetTranslation(translation);

		this->SetWindowText(TEXT_config_title());

		CMenu* system_menu;

		system_menu = GetSystemMenu(FALSE);
		system_menu->ModifyMenu(10, 0, 10, TEXT_config_menu_about());

		m_Aceptar.SetWindowText(TEXT_config_button_ok());
		m_Cancelar.SetWindowText(TEXT_config_button_cancel());

		m_ayuda.mensaje = TEXT_config_help_help();

		m_idiomas.mensaje = TEXT_config_help_languages();
		m_Aceptar.mensaje = TEXT_config_help_accept();
		m_Cancelar.mensaje = TEXT_config_help_cancel();
		m_p_data.mensaje = m_path_data.mensaje = TEXT_config_help_data_dir();
		m_p_music.mensaje = m_path_music.mensaje = TEXT_config_help_music_dir();
		m_p_pieces.mensaje = m_path_pieces.mensaje = TEXT_config_help_pieces_dir();
		m_p_players.mensaje = m_path_players.mensaje = TEXT_config_help_players_dir();
		m_p_backgrounds.mensaje = m_path_backgrounds.mensaje = TEXT_config_help_background_dir();
		m_p_text.mensaje = m_path_text.mensaje = TEXT_config_help_text_dir();
		m_button_p_music.mensaje = TEXT_config_help_button_music_dir();
		m_button_p_pieces.mensaje = TEXT_config_help_button_pieces_dir();
		m_button_p_players.mensaje = TEXT_config_help_button_players_dir();
		m_button_p_data.mensaje = TEXT_config_help_button_data_dir();
		m_button_p_backgrounds.mensaje = TEXT_config_help_button_background_dir();
		m_button_p_texts.mensaje = TEXT_config_help_button_text_dir();

		m_radio15.mensaje = TEXT_config_help_bpp(15);
		m_radio16.mensaje = TEXT_config_help_bpp(16);
		m_radio24.mensaje = TEXT_config_help_bpp(24);
		m_radio32.mensaje = TEXT_config_help_bpp(32);
		m_full_scr.mensaje = TEXT_config_help_fullscreen();
		m_resolucion_label.mensaje = m_resolucion.mensaje = TEXT_config_help_resolution();
		m_static_cal_sist_part.mensaje = m_slider_cal_sist_part.mensaje = TEXT_config_help_particle_system_quality();
		m_combo_modo_act.mensaje = m_modo_act.mensaje = TEXT_config_help_refresh_mode();
		m_des_hw_accel.mensaje = TEXT_config_help_disable_hw_acceleration();

		m_musica_check.mensaje = TEXT_config_help_music_check();
		m_sonido_check.mensaje = TEXT_config_help_sound_check();
		m_musica_driver.mensaje = TEXT_config_help_music_driver();
		m_sonido_driver.mensaje = TEXT_config_help_sound_driver();
		m_musica_vol_label.mensaje = m_musica_vol.mensaje = TEXT_config_help_music_vol();
		m_sonido_vol_label.mensaje = m_sonido_vol.mensaje = TEXT_config_help_sound_vol();
		m_musica_test.mensaje = TEXT_config_help_music_test();
		m_sonido_test.mensaje = TEXT_config_help_sound_test();
		m_lista_musica.mensaje = TEXT_config_help_music_list();
		m_musica_add.mensaje = TEXT_config_help_music_add();
		m_musica_del.mensaje = TEXT_config_help_music_del();
		m_musica_ar.mensaje = TEXT_config_help_music_up();
		m_musica_ab.mensaje = TEXT_config_help_music_down();

		LV_COLUMN c;

		c.mask = LVCF_TEXT;

		c.pszText = TEXT_config_music_name();
		m_lista_musica.SetColumn(0, &c);
		c.pszText = TEXT_config_music_file();
		m_lista_musica.SetColumn(1, &c);

		TCITEM tab_item;

		tab_item.mask = TCIF_TEXT;

		tab_item.pszText = TEXT_config_general();
		m_tab.SetItem(0, &tab_item);
		tab_item.pszText = TEXT_config_graphics();
		m_tab.SetItem(1, &tab_item);
		tab_item.pszText = TEXT_config_sound();
		m_tab.SetItem(2, &tab_item);
		tab_item.pszText = TEXT_config_info();
		m_tab.SetItem(3, &tab_item);

		m_frame_rutas.SetWindowText(TEXT_config_paths());
		m_p_music.SetWindowText(TEXT_config_music_dir());
		m_p_pieces.SetWindowText(TEXT_config_pieces_dir());
		m_p_players.SetWindowText(TEXT_config_players_dir());
		m_p_data.SetWindowText(TEXT_config_data_dir());
		m_p_backgrounds.SetWindowText(TEXT_config_background_dir());
		m_p_text.SetWindowText(TEXT_config_text_dir());

		m_frame_idiomas.SetWindowText(TEXT_config_language());

		m_resolucion_label.SetWindowText(TEXT_config_resolution());
		m_full_scr.SetWindowText(TEXT_config_fullscreen());
		m_modo_act.SetWindowText(TEXT_config_refresh_mode());
		m_des_hw_accel.SetWindowText(TEXT_config_disable_hw_acceleration());
		m_opciones_graficas.SetWindowText(TEXT_config_graphic_options());
		m_static_cal_sist_part.SetWindowText(TEXT_config_particle_quality());

		first_selected = (m_combo_modo_act.GetCurSel() == 0);
		m_combo_modo_act.DeleteString(0);
		m_combo_modo_act.InsertString(0, TEXT_config_refresh_automatic());
		if (first_selected)
		{
			m_combo_modo_act.SetCurSel(0);
		}

		m_frame_sonido.SetWindowText(TEXT_config_sound());
		m_musica_check.SetWindowText(TEXT_config_midi_music());
		m_sonido_check.SetWindowText(TEXT_config_digital_sound());
		m_musica_test.SetWindowText(TEXT_config_test());
		m_sonido_test.SetWindowText(TEXT_config_test());
		m_musica_vol_label.SetWindowText(TEXT_config_vol());
		m_sonido_vol_label.SetWindowText(TEXT_config_vol());
		m_musica_add.SetWindowText(TEXT_config_music_add());
		m_musica_ar.SetWindowText(TEXT_config_music_up());
		m_musica_ab.SetWindowText(TEXT_config_music_down());
		m_musica_del.SetWindowText(TEXT_config_music_del());

		first_selected = (m_musica_driver.GetCurSel() == 0);
		m_musica_driver.DeleteString(0);
		m_musica_driver.InsertString(0, TEXT_config_autodetect());
		if (first_selected)
		{
			m_musica_driver.SetCurSel(0);
		}

		switch(directx_version)
		{
		case 0x000:
			m_static_directx_ver.SetWindowText(TEXT_config_directx_not_installed());
			break;
		case 0x100:
			m_static_directx_ver.SetWindowText(TEXT_config_directx_installed("1"));
			break;
		case 0x200:
			m_static_directx_ver.SetWindowText(TEXT_config_directx_installed("2"));
			break;
		case 0x300:
			m_static_directx_ver.SetWindowText(TEXT_config_directx_installed("3"));
			break;
		case 0x500:
			m_static_directx_ver.SetWindowText(TEXT_config_directx_installed("5"));
			break;
		case 0x600:
			m_static_directx_ver.SetWindowText(TEXT_config_directx_installed("6"));
			break;
		case 0x601:
			m_static_directx_ver.SetWindowText(TEXT_config_directx_installed("6.1"));
			break;
		case 0x700:
			m_static_directx_ver.SetWindowText(TEXT_config_directx_installed("7"));
			break;
		case 0x800:
			m_static_directx_ver.SetWindowText(TEXT_config_directx_or_better_installed("8"));
			break;
		default:
			m_static_directx_ver.SetWindowText(TEXT_config_directx_unknown_installed());
			break;
		}
	}
}

//##ModelId=3FB214320012
void CConfigDlg::OnSelchangeListIdioma()
{
	LoadSelectedTranslation();
}

int __stdcall CConfigDlg_BrowseCallback(HWND hwnd, UINT uMsg, LPARAM lParam, LPARAM lpData)
{
	if (uMsg == BFFM_INITIALIZED)
	{
		::SendMessage(hwnd, BFFM_SETSELECTION, TRUE, lpData);
	}

	return 0;
}

//##ModelId=3FB2142F0124
CString CConfigDlg::ShowDirSelect(CString &path, char *caption)
{
	CString p;
	char abs_path[MAX_PATH];

	_fullpath(abs_path, LPCSTR(path), MAX_PATH);

	LPMALLOC pMalloc;
	/* Gets the Shell's default allocator */
	if (::SHGetMalloc(&pMalloc) == NOERROR)
	{
		BROWSEINFO bi;
		char pszBuffer[MAX_PATH];
		strcpy(pszBuffer, LPCSTR(path));
		LPITEMIDLIST pidl;
		// Get help on BROWSEINFO struct - it's got all the bit settings.
		bi.hwndOwner = GetSafeHwnd();
		bi.pidlRoot = NULL;
		bi.pszDisplayName = pszBuffer;
		bi.lpszTitle = _T(caption);
		bi.ulFlags = BIF_DONTGOBELOWDOMAIN | BIF_RETURNFSANCESTORS | BIF_RETURNONLYFSDIRS;
		bi.lpfn = CConfigDlg_BrowseCallback;
		bi.lParam = long(abs_path);
		// This next call issues the dialog box.
		if ((pidl = ::SHBrowseForFolder(&bi)) != NULL)
		{
			if (::SHGetPathFromIDList(pidl, pszBuffer))
			{
				p = pszBuffer;
			}
			// Free the PIDL allocated by SHBrowseForFolder.
			pMalloc->Free(pidl);
		}
		// Release the shell's allocator.
		pMalloc->Release();
	}

	return p;
}

//##ModelId=3FB2142F011C
void CConfigDlg::RelativePath(CString &path)
{
	int n;

	n = GetCurrentDirectory(0, NULL);
	char *cur_dir = new char[n];
	GetCurrentDirectory(n, cur_dir);

	n = strlen(cur_dir);
	if (path.GetLength() >= n && !strncmp(LPCSTR(path), cur_dir, n))
	{
		path.Delete(0, n);
		path.Insert(0, ".");
	}

	path.Replace('\\', '/');
	path.MakeLower();

	delete[] cur_dir;
}

//##ModelId=3FB21432001B
void CConfigDlg::OnButtonPMusic() 
{
	CString p;

	m_path_music.GetWindowText(p);
	p = ShowDirSelect(p, TEXT_config_browse_music_dir());
	if (p != "")
	{
		RelativePath(p);
		m_path_music.SetWindowText(LPCSTR(p));
	}
}

//##ModelId=3FB214320024
void CConfigDlg::OnButtonPPieces() 
{
	CString p;

	m_path_pieces.GetWindowText(p);
	p = ShowDirSelect(p, TEXT_config_browse_pieces_dir());
	if (p != "")
	{
		RelativePath(p);
		m_path_pieces.SetWindowText(LPCSTR(p));
	}
}

//##ModelId=3FB214320026
void CConfigDlg::OnButtonPPlayers() 
{
	CString p;

	m_path_players.GetWindowText(p);
	p = ShowDirSelect(p, TEXT_config_browse_players_dir());
	if (p != "")
	{
		RelativePath(p);
		m_path_players.SetWindowText(LPCSTR(p));
	}
}

//##ModelId=3FB21432002F
void CConfigDlg::OnButtonPData() 
{
	CString p;

	m_path_data.GetWindowText(p);
	p = ShowDirSelect(p, TEXT_config_browse_data_dir());
	if (p != "")
	{
		RelativePath(p);
		m_path_data.SetWindowText(LPCSTR(p));
	}
}

//##ModelId=3FB214320038
void CConfigDlg::OnButtonPTexts() 
{
	CString p;

	m_path_text.GetWindowText(p);
	p = ShowDirSelect(p, TEXT_config_browse_text_dir());
	if (p != "")
	{
		RelativePath(p);
		m_path_text.SetWindowText(LPCSTR(p));
	}
}

//##ModelId=3FB214320044
void CConfigDlg::OnChangeEditTextos() 
{
	while (m_idiomas.GetCount() > 0)
	{
		m_idiomas.DeleteString(0);
	}

	m_path_text.GetWindowText(path_text, 100);

	UpdateLanguages(false);
}

//##ModelId=3FB21432003A
void CConfigDlg::OnButtonPFondos() 
{
	CString p;

	m_path_backgrounds.GetWindowText(p);
	p = ShowDirSelect(p, TEXT_config_browse_background_dir());
	if (p != "")
	{
		RelativePath(p);
		m_path_backgrounds.SetWindowText(LPCSTR(p));
	}
}

//##ModelId=3FB214320042
void CConfigDlg::OnSelchangeComboResolucion() 
{
	int i = m_resolucion.GetCurSel();
	
	get_valid_bpp (resoluciones[i], c15, c16, c24, c32);
	
	m_radio15.EnableWindow(c15);	
	m_radio16.EnableWindow(c16);
	m_radio24.EnableWindow(c24);
	m_radio32.EnableWindow(c32);

#ifdef NO_24_BPP_SUPPORT
	m_radio24.EnableWindow(false);
#endif

	if (!c15 && m_radio15.GetCheck() ||
		!c16 && m_radio16.GetCheck() ||
		!c24 && m_radio24.GetCheck() ||
		!c32 && m_radio32.GetCheck())
	{
		m_radio15.SetCheck(0);
		m_radio16.SetCheck(0);
		m_radio24.SetCheck(0);
		m_radio32.SetCheck(0);

		if (c15) m_radio15.SetCheck(1);
		else if (c16) m_radio16.SetCheck(1);
		else if (c24) m_radio24.SetCheck(1);
		else if (c32) m_radio32.SetCheck(1);
	}
}

//##ModelId=3FB2142F0189
CConfigDlg::WindowsVersion CConfigDlg::GetWindowsVersion(CString &ver_name)
{
	WindowsVersion wv = wvUnknown;

	OSVERSIONINFO ver_info;

	ver_info.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);

	ver_name = "Unknown Windows version";

	if (!GetVersionEx(&ver_info))
	{
		return wv;
	}

	if (ver_info.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
	{
		wv = wvUnknownWin9x;
		ver_name = "Unknown Windows 9x";
		if (ver_info.dwMajorVersion == 4)
		{
			switch (ver_info.dwMinorVersion)
			{
			case 0:
				if (ver_info.szCSDVersion[1] == 'B')
				{
					wv = wvWin95OSR2;
					ver_name = "Windows 95 OSR2";
				}
				else
				{
					wv = wvWin95;
					ver_name = "Windows 95";
				}
				break;
			case 10:
				if (ver_info.szCSDVersion[0] == 'A')
				{
					wv = wvWin98SE;
					ver_name = "Windows 98SE";
				}
				else
				{
					wv = wvWin98;
					ver_name = "Windows 98";
				}
				break;
			case 90:
				wv = wvWinME;
				ver_name = "Windows ME";
				break;
			}
		}
	}
	else if (ver_info.dwPlatformId == VER_PLATFORM_WIN32_NT)
	{
		wv = wvUnknownWinNT;
		ver_name = "Unknown Windows NT";
		switch (ver_info.dwMajorVersion)
		{
		case 3:
			wv = wvWinNT3;
			ver_name = "Windows NT 3";
			break;
		case 4:
			wv = wvWinNT4;
			ver_name = "Windows NT 4";
			break;
		case 5:
			if (ver_info.dwMinorVersion == 0)
			{
				wv = wvWin2000;
				ver_name = "Windows 2000";
			}
			else
			{
				wv = wvWinXP;
				ver_name = "Windows XP";
			}
			break;
		}
	}

	return wv;
}

//##ModelId=3FB21432004D
void CConfigDlg::OnSysCommand(UINT nID, LPARAM lParam) 
{
	if (nID == 10)
	{
		CAboutDlg dlg;
		int r = dlg.DoModal();
		if (r == -1 || r == IDABORT)
		{
			AfxMessageBox("Error showing about dialog", 0, 0);
		}
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

//##ModelId=3FB214320092
BOOL CConfigDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	CAboutDlg dlg;
	dlg.DoModal();
	
	return CDialog::OnHelpInfo(pHelpInfo);
}
