//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include <string.h>

#define ALLEGRO_AND_MFC
#define ALLEGRO_NO_MAGIC_MAIN

#include <allegro.h>
#include <allegro/internal/aintern.h>
#include <winalleg.h>
#include <fmod.h>

#include <string>
using namespace std;

#include "MyComboBox.h"

#include "AlFunc.h"

#include <set>

DATAFILE *midi;
DATAFILE *smp;

int midi_volume;
int digi_volume;

bool playing = false;

//##ModelId=3FB21432020F
typedef struct SOUNDCARD
{
   int id;
   string name;
   int present;
} SOUNDCARD;

SOUNDCARD digi_cards[64], midi_cards[64];
int num_digi_cards;
int num_midi_cards;

void init_all(HWND wnd)
{

	win_set_window(wnd);
	set_uformat(U_ASCII);
	allegro_init();
	set_display_switch_mode(SWITCH_BACKAMNESIA);
	install_timer();
	set_config_file("tetris.cfg");
/*
	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL))
	{
		AfxMessageBox("Error al iniciar el sonido", 0, 0);
	}
*/
	midi = load_datafile_object("config.dat", "MIDI_TEST");
	if (!midi)
	{
		AfxMessageBox("No se ha podido leer el archivo", 0, 0);
	}

	smp = load_datafile_object("config.dat", "WAV_TEST");
	if (!smp)
	{
		AfxMessageBox("No se ha podido leer el archivo", 0, 0);
	}

	FSOUND_SetOutput(FSOUND_OUTPUT_DSOUND);
}

void close_all()
{
	unload_datafile_object(midi);
	unload_datafile_object(smp);
	allegro_exit();
}

void set_vol(int digi, int midi)
{
	set_volume(digi, midi);
	if (digi>=0) digi_volume = digi;
	if (midi>=0) midi_volume = midi;
}

int get_digi_vol()
{
	return digi_volume;
}

int get_midi_vol()
{
	return midi_volume;
}

int get_digi_driver_id(int driver)
{
	int i, c;

	i=c=0;
	while (!digi_cards[i].present) i++;
	while (c<driver)
	{
		i++;
		while (!digi_cards[i].present) i++;
		c++;
	}

	return digi_cards[i].id;
}

int get_midi_driver_id(int driver)
{
	int i, c;

	i=c=0;
	while (!midi_cards[i].present) i++;
	while (c<driver)
	{
		i++;
		while (!midi_cards[i].present) i++;
		c++;
	}

	return midi_cards[i].id;
}

int get_digi_driver_index(int id)
{
	int c = 0;
	int i = 0;
	int j = 0;
	bool found = false;

	while (i<num_digi_cards && !found)
	{
		if (digi_cards[i].id == id)
		{
			c=j;
			found = true;
		}
		if (digi_cards[i].present) j++;
		i++;
	}

	return c;
}

int get_midi_driver_index(int id)
{
	int c = 0;
	int i = 0;
	int j = 0;
	bool found = false;

	while (i<num_midi_cards && !found)
	{
		if (midi_cards[i].id == id)
		{
			c=j;
			found = true;
		}
		if (midi_cards[i].present) j++;
		i++;
	}

	return c;
}

bool midi_test(int driver)
{
	int id;
	string error;

	id = get_midi_driver_id(driver);

	if (install_sound(DIGI_NONE, id, NULL))
	{
		error = string("Error al inicializar el driver: ") + string(allegro_error);
		AfxMessageBox(error.c_str());
		return false;
	}

	set_volume(digi_volume, midi_volume);
	if (!playing)
	{
		play_midi((MIDI*)midi->dat, 1);
		playing = true;
	}
	else
	{
		stop_midi();
		remove_sound();
		playing = false;
	}

	return playing;
}

bool midi_playing()
{
	return playing;
}

volatile bool stream_end;

signed char F_API stream_end_call(FSOUND_STREAM *stream, void *buff, int len, int param)
{
	stream_end = true;

	return 0;
}

void digi_test(int driver)
{
//	int voice;
	FSOUND_STREAM *voice;

	int id;
	string error;

	id = get_digi_driver_id(driver);

	stream_end = false;

	FSOUND_SetDriver(id);
	FSOUND_Init(44100, 32, 0);
	FSOUND_SetSFXMasterVolume(digi_volume);

	voice = FSOUND_Stream_Open((const char*)smp->dat, FSOUND_LOADMEMORY, 0, smp->size);

	FSOUND_Stream_SetEndCallback(voice, stream_end_call, 0);

	FSOUND_Stream_Play(FSOUND_FREE, voice);

	while (!stream_end);

	FSOUND_Stream_Close(voice);
	FSOUND_Close();

/*  ALLEGRO SOUND OUTPUT
	if (install_sound(id, MIDI_NONE, NULL))
	{
		error = string("Error al inicializar el driver: ") + string(allegro_error);
		AfxMessageBox(error.c_str());
		return;
	}

	set_volume(digi_volume, midi_volume);

	voice = allocate_voice((SAMPLE*)smp->dat);

	voice_set_pan(voice, 0);
	voice_start(voice);
	while (voice_get_position(voice) >= 0);

	voice_set_pan(voice, 255);
	voice_start(voice);
	while (voice_get_position(voice) >= 0);

	voice_set_pan(voice, 127);
	voice_start(voice);
	while (voice_get_position(voice) >= 0);

	deallocate_voice(voice);
	
	remove_sound();
*/
}

int get_cpu_cmov()
{
	return cpu_capabilities & CPU_CMOV;
}

int get_cpu_fpu()
{
	return cpu_capabilities & CPU_FPU;
}

int get_cpu_mmx()
{
	return cpu_capabilities & CPU_MMX;
}

int get_cpu_mmxplus()
{
	return cpu_capabilities & CPU_MMXPLUS;
}

int get_cpu_sse()
{
	return cpu_capabilities & CPU_SSE;
}

int get_cpu_sse2()
{
	return cpu_capabilities & CPU_SSE2;
}

int get_cpu_3dnow()
{
	return cpu_capabilities & CPU_3DNOW;
}

int get_cpu_enh3dnow()
{
	return cpu_capabilities & CPU_ENH3DNOW;
}

const char *get_string(char *section, char *key, char *def)
{
	return get_config_string(section, key, def);
}

void set_string(char *section, char *key, const char *val)
{
	set_config_string (section, key, val);
}

int get_int(char *section, char *key, int def)
{
	return get_config_int(section, key, def);
}

void set_int(char *section, char *key, int val)
{
	set_config_int (section, key, val);
}

int get_id(char *section, char *key, int def)
{
	return get_config_id (section, key, def);
}

void set_id(char *section, char *key, int val)
{
	set_config_id (section, key, val);
}

int al_id_safe(char *s)
{
	int l = strlen(s);
	return AL_ID((l > 0) ? s[0] : ' ',
		(l > 1) ? s[1] : ' ',
		(l > 2) ? s[2] : ' ',
		(l > 3) ? s[3] : ' ');
}

al_resolucion* get_lista_resoluciones(int& size)
{
	_DRIVER_INFO *driver_info;
	GFX_DRIVER **gfx_driver;
	GFX_MODE_LIST *gfx_mode_list;
	int driver_count, i, id, n;
	set<al_resolucion> resoluciones;
	al_resolucion *res = NULL;
	
	if (system_driver->gfx_drivers)
		driver_info = system_driver->gfx_drivers();
	else
		driver_info = _gfx_driver_list;
	
	driver_count = 0;
	while (driver_info[driver_count].driver)
		driver_count++;
	
	gfx_driver = (struct GFX_DRIVER**)malloc(sizeof(GFX_DRIVER *) * driver_count);
	if (!gfx_driver)
		return NULL;
	for (i = 0; i < driver_count; i++)
		gfx_driver[i] = (GFX_DRIVER *)driver_info[i].driver;
	
	id = al_id_safe("DXAC");
	for (i = 0; i < driver_count; i++) {
		if ((strcmp(gfx_driver[i]->ascii_name, "DXAC") == 0) || (gfx_driver[i]->id == id)) {
			break;
		}
	}
	
	if (i != driver_count && !gfx_driver[i]->windowed) {
		
		n=i;
		gfx_mode_list = get_gfx_mode_list(gfx_driver[i]->id);
		if (gfx_mode_list)
		{
			for (i = 0; i < gfx_mode_list->num_modes; i++) {
				if (gfx_mode_list->mode[i].bpp > 8)
				{
					al_resolucion r;
					r.width = gfx_mode_list->mode[i].width;
					r.height = gfx_mode_list->mode[i].height;

					if (r.width >= 640 && r.height >= 480)
					{
						resoluciones.insert(r);
					}
				}
			}
			
			destroy_gfx_mode_list(gfx_mode_list);

			size = resoluciones.size();

			if (size > 0)
			{
				res = new al_resolucion[size];

				set<al_resolucion>::iterator it;

				i=0;
				for(it=resoluciones.begin(); it!=resoluciones.end(); it++)
				{
					res[i] = *it;
					i++;
				}
			}
		}
	}
	
	free(gfx_driver);
	
	return res;
}

void get_valid_bpp (const al_resolucion& res, int& c15, int& c16, int& c24, int& c32)
{
	_DRIVER_INFO *driver_info;
	GFX_DRIVER **gfx_driver;
	GFX_MODE_LIST *gfx_mode_list;
	int driver_count, i, id, n;
	
	c15 = c16 = c24 = c32 = 0;
	
	if (system_driver->gfx_drivers)
		driver_info = system_driver->gfx_drivers();
	else
		driver_info = _gfx_driver_list;
	
	driver_count = 0;
	while (driver_info[driver_count].driver)
		driver_count++;
	
	gfx_driver = (struct GFX_DRIVER**)malloc(sizeof(GFX_DRIVER *) * driver_count);
	if (!gfx_driver)
		return;
	for (i = 0; i < driver_count; i++)
		gfx_driver[i] = (GFX_DRIVER *)driver_info[i].driver;
	
	id = al_id_safe("DXAC");
	for (i = 0; i < driver_count; i++) {
		if ((strcmp(gfx_driver[i]->ascii_name, "DXAC") == 0) || (gfx_driver[i]->id == id)) {
			break;
		}
	}
	
	if (i == driver_count) {
		goto end;
	}
	
	if (gfx_driver[i]->windowed) {
		goto end;
	}
	
	n=i;
	gfx_mode_list = get_gfx_mode_list(gfx_driver[i]->id);
	if (!gfx_mode_list) {
		goto end;
	}
	
	for (i = 0; i < gfx_mode_list->num_modes; i++) {
		if (gfx_mode_list->mode[i].width == res.width && gfx_mode_list->mode[i].height == res.height)
		{
			switch (gfx_mode_list->mode[i].bpp)
			{
			case 15: c15 = 1; break;
			case 16: c16 = 1; break;
			case 24: c24 = 1; break;
			case 32: c32 = 1; break;
			}
		}
	}
	
	destroy_gfx_mode_list(gfx_mode_list);
	
end:
	
	free(gfx_driver);
}

static void detect_sound(void);

void find_sound_drivers(CComboBox *CMidiBox, CComboBox *CFXBox)
{
   _DRIVER_INFO *info;
   int c;

   digi_cards[0].id = DIGI_AUTODETECT;
   digi_cards[0].name = "Autodetectar";
   digi_cards[0].present = TRUE;

// ALLEGRO SOUND OUTPUT
/*
   if (system_driver->digi_drivers)
      info = system_driver->digi_drivers();
   else
      info = _digi_driver_list;

   c = 1;

   while ((info->driver) && (info->id != DIGI_NONE)) {
      digi_cards[c].id = info->id;
      digi_cards[c].name = ((DIGI_DRIVER *)info->driver)->ascii_name;
		digi_cards[c].present = TRUE;

      info++;
      c++;
   }

   num_digi_cards = c;
*/

// FMOD SOUND OUTPUT
   for(c=0; c<FSOUND_GetNumDrivers(); c++)
   {
	   digi_cards[c].present = TRUE;
	   digi_cards[c].id = c;
	   digi_cards[c].name = (char*)FSOUND_GetDriverName(c);
   }

   num_digi_cards = c;

   midi_cards[0].id = MIDI_AUTODETECT;
   midi_cards[0].name = "";
   midi_cards[0].present = TRUE;

   if (system_driver->midi_drivers)
      info = system_driver->midi_drivers();
   else
      info = _midi_driver_list;


   c = 1;

   while ((info->driver) && (info->id != MIDI_NONE)) {
      midi_cards[c].id = info->id;
      midi_cards[c].name = ((MIDI_DRIVER *)info->driver)->ascii_name;
		midi_cards[c].present = TRUE;

      info++;
      c++;
   }

   num_midi_cards = c;

   detect_sound();

	for (c=0; c<num_digi_cards; c++)
	{
		if (digi_cards[c].present == TRUE)
			CFXBox->AddString(digi_cards[c].name.c_str());
	}   

	for (c=0; c<num_midi_cards; c++)
	{
		if (midi_cards[c].present == TRUE)
			CMidiBox->AddString(midi_cards[c].name.c_str());
	}
}

static void detect_sound(void)
{
   int i;
/*
   for (i=0; i<num_digi_cards; i++) {
      if (detect_digi_driver(digi_cards[i].id) == 0)
	 digi_cards[i].present = FALSE;
      else
	 digi_cards[i].present = TRUE;
   }
*/
//   digi_cards[i].present = TRUE;

   for (i=0; i<num_midi_cards; i++) {
      if (detect_midi_driver(midi_cards[i].id) == 0)
	 midi_cards[i].present = FALSE;
      else
	 midi_cards[i].present = TRUE;
   }
//   midi_cards[i].present = TRUE;
}
