//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


// ConfigDlg.h : header file
//

#if !defined(AFX_CONFIGDLG_H__5EE82404_1E48_4477_9B19_8DF529C18A3D__INCLUDED_)
#define AFX_CONFIGDLG_H__5EE82404_1E48_4477_9B19_8DF529C18A3D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CConfigDlg dialog

#include "MyButton.h"
#include "MyEdit.h"
#include "MyStatic.h"
#include "MyListCtrl.h"
#include "MySliderCtrl.h"
#include "MyComboBox.h"
#include "MyListBox.h"
#include "HotTabCtrl.h"

#include <afxtempl.h>

//##ModelId=3FB2142F0110
class CConfigDlg : public CDialog
{
// Construction
public:
	//##ModelId=3FB2142F011A
	CConfigDlg(CWnd* pParent = NULL);	// standard constructor

private:
	//##ModelId=3FB2142F011C
	void RelativePath(CString &path);
	//##ModelId=3FB2142F0124
	CString ShowDirSelect(CString &path, char *caption);
	//##ModelId=3FB2142F0127
	CString& AppendPathSeparator(CString &str);
	//##ModelId=3FB2142F012F
	void LoadSelectedTranslation(void);
	//##ModelId=3FB2142F0144
	CMap<long, long&, CString, CString&> languages;
	//##ModelId=3FB2142F014C
	void UpdateLanguages(bool warn_no_translation = true);
	//##ModelId=3FB2142F0157
	bool GuardarMusicaIni();
	//##ModelId=3FB2142F0158
	void CargarMusicaIni();
	//##ModelId=3FB2142F0160
	void MostrarControles();
	//##ModelId=3FB2142F0161
	HRESULT CreateLink(LPCSTR lpszPathObj, LPCSTR lpszWorkDir, LPSTR lpszPathLink, LPSTR lpszDesc);
	//##ModelId=3FB2142F0174
	int create_key(HKEY key, char *name, PHKEY key_dest);
	//##ModelId=3FB2142F017E
	static char *leer_linea(char *buf, int n, FILE *fp);


	//##ModelId=3FB2143200D8
	enum WindowsVersion {
		wvUnknown, wvUnknownWin9x, wvUnknownWinNT, 
						  wvWin95, wvWin95OSR2, wvWin98, wvWin98SE, wvWinME, wvWinNT3, wvWinNT4, wvWin2000, wvWinXP};
	//=================================================================================================================
	// Win32Platform        1           1           1        1         1        2         2          2           2
	// Win32MajorVersion    4           4           4        4         4        3         4          5           5
	// Win32MinorVersion    0           0           10       10        90       ?         0          0           1
	// Win32BuildNumber     ?        67109975    67766222  67766446  73010104   ?        1381       2195         ?
	// Win32CSDVersion      ?          'B'          ''       A         SP       SP        SP         ?           ?


	//##ModelId=3FB2142F0189
	WindowsVersion GetWindowsVersion(CString &ver_name);

	//##ModelId=3FB2142F0193
	ALTEXT_Translation *translation;

	//##ModelId=3FB2142F019C
	CString m_music_dir;

	CBrush m_pincel, m_pincel_ventana, m_pincel_fondo;

	//##ModelId=3FB2142F019D
	DWORD directx_version;
	//##ModelId=3FB2142F01A6
	int al_cmov;
	//##ModelId=3FB2142F01A7
	int al_fpu;
	//##ModelId=3FB2142F01B0
	int al_mmx;
	//##ModelId=3FB2142F01BA
	int al_mmxplus;
	//##ModelId=3FB2142F01BB
	int al_sse;
	//##ModelId=3FB2142F01C4
	int al_sse2;
	//##ModelId=3FB2142F01C5
	int al_3dnow;
	//##ModelId=3FB2142F01CE
	int al_enh3dnow;
	//##ModelId=3FB2142F01CF
	char path_music[100];
	//##ModelId=3FB2142F01D8
	char path_pieces[100];
	//##ModelId=3FB2142F01E2
	char path_players[100];
	//##ModelId=3FB2142F01E3
	char path_data[100];
	//##ModelId=3FB2142F01EC
	char path_text[100];
	//##ModelId=3FB2142F01ED
	char path_backgrounds[100];

	//##ModelId=3FB2142F01F6
	int c15;
	//##ModelId=3FB2142F01F7
	int c16;
	//##ModelId=3FB2142F0200
	int c24;
	//##ModelId=3FB2142F020A
	int c32;
	//##ModelId=3FB2142F020B
	int fullscreen;
	//##ModelId=3FB2142F0215
	al_resolucion* resoluciones;
	//##ModelId=3FB2142F021E
	int num_resoluciones;
	//##ModelId=3FB2142F0228
	int modo_actualizacion;
	//##ModelId=3FB2142F0229
	int desactivar_aceleracion;
	//##ModelId=3FB2142F0232
	int calidad_particulas;

	//##ModelId=3FB2142F023D
	CMyButton m_radio15;
	//##ModelId=3FB2142F0252
	CMyButton m_radio16;
	//##ModelId=3FB2142F025C
	CMyButton m_radio24;
	//##ModelId=3FB2142F0270
	CMyButton m_radio32;
	//##ModelId=3FB2142F0284
	CMyButton m_full_scr;
	//##ModelId=3FB2142F0298
	CMyStatic m_resolucion_label;
	//##ModelId=3FB2142F02AC
	CMyComboBox m_resolucion;

	//##ModelId=3FB2142F02C0
	CMyStatic m_ayuda;

//	CMyButton m_AD_Inicio;
//	CMyButton m_AD_Escritorio;
//	CMyButton m_Reset;
	//##ModelId=3FB2142F02D3
	CMyStatic m_p_data;
	//##ModelId=3FB2142F02E8
	CMyStatic m_p_music;
	//##ModelId=3FB2142F02FC
	CMyStatic m_p_pieces;
	//##ModelId=3FB2142F0310
	CMyStatic m_p_players;
	//##ModelId=3FB2142F0324
	CMyStatic m_p_text;
	//##ModelId=3FB2142F0338
	CMyEdit m_path_data;
	//##ModelId=3FB2142F034C
	CMyEdit m_path_music;
	//##ModelId=3FB2142F0360
	CMyEdit m_path_pieces;
	//##ModelId=3FB2142F0374
	CMyEdit m_path_players;
	//##ModelId=3FB2142F0392
	CMyEdit m_path_text;

	//##ModelId=3FB2142F03A6
	CMyComboBox m_musica_driver;
	//##ModelId=3FB2142F03BA
	CMyComboBox m_sonido_driver;
	//##ModelId=3FB2142F03D8
	CMyButton m_musica_check;
	//##ModelId=3FB214300004
	CMyButton m_sonido_check;
	//##ModelId=3FB214300018
	CMyStatic m_musica_vol_label;
	//##ModelId=3FB214300036
	CMyStatic m_sonido_vol_label;
	//##ModelId=3FB21430004A
	CMySliderCtrl m_musica_vol;
	//##ModelId=3FB214300068
	CMySliderCtrl m_sonido_vol;
	//##ModelId=3FB214300085
	CMyListCtrl m_lista_musica;


// Dialog Data
	//{{AFX_DATA(CConfigDlg)
	enum { IDD = IDD_CONFIG_DIALOG };
	//##ModelId=3FB21430009A
	CMyListBox	m_idiomas;
	//##ModelId=3FB2143000B8
	CMyButton	m_musica_del;
	//##ModelId=3FB2143000D6
	CMyButton	m_musica_ab;
	//##ModelId=3FB2143000EA
	CMyButton	m_musica_ar;
	//##ModelId=3FB214300108
	CMyButton	m_musica_add;
	//##ModelId=3FB214300127
	CMyButton	m_sonido_test;
	//##ModelId=3FB214300145
	CMyButton	m_musica_test;
	//##ModelId=3FB214300163
	CMyButton	m_Cancelar;
	//##ModelId=3FB214300181
	CMyButton	m_Aceptar;
	//##ModelId=3FB21430019F
	CHotTabCtrl	m_tab;
	//##ModelId=3FB2143001BD
	CMyStatic	m_static_directx_ver;
	//##ModelId=3FB2143001DB
	CButton	m_frame_software;
	//##ModelId=3FB2143001F9
	CMyStatic	m_static_so_name;
	//##ModelId=3FB214300217
	CButton	m_opciones_graficas;
	//##ModelId=3FB214300235
	CMyButton	m_des_hw_accel;
	//##ModelId=3FB214300253
	CMyComboBox	m_combo_modo_act;
	//##ModelId=3FB214300271
	CMyStatic	m_modo_act;
	//##ModelId=3FB21430028F
	CMyStatic	m_static_cal_sist_part;
	//##ModelId=3FB2143002B7
	CMySliderCtrl	m_slider_cal_sist_part;
	//##ModelId=3FB2143002D5
	CButton	m_frame_idiomas;
	//##ModelId=3FB2143002F3
	CMyEdit	m_path_backgrounds;
	//##ModelId=3FB214300311
	CMyStatic	m_p_backgrounds;
	//##ModelId=3FB214300339
	CMyButton	m_button_p_backgrounds;
	//##ModelId=3FB214300357
	CMyButton	m_button_p_texts;
	//##ModelId=3FB21430037F
	CMyButton	m_button_p_players;
	//##ModelId=3FB21430039D
	CMyButton	m_button_p_pieces;
	//##ModelId=3FB2143003C5
	CMyButton	m_button_p_data;
	//##ModelId=3FB2143003E4
	CMyButton	m_button_p_music;
	//##ModelId=3FB214310024
	CButton	m_frame_sonido;
	//##ModelId=3FB214310042
	CButton	m_frame_rutas;
	//##ModelId=3FB21431005F
	BOOL	m_sonido;
	//##ModelId=3FB214310091
	BOOL	m_musica;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CConfigDlg)
	protected:
	//##ModelId=3FB2143100B9
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//##ModelId=3FB2143100E1
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CConfigDlg)
	//##ModelId=3FB214310113
	virtual BOOL OnInitDialog();
	//##ModelId=3FB21431011D
	afx_msg void OnPaint();
	//##ModelId=3FB21431011F
	afx_msg HCURSOR OnQueryDragIcon();
	//##ModelId=3FB214310128
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	//##ModelId=3FB21431018B
	virtual void OnOK();
	//##ModelId=3FB214310195
	afx_msg void OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult);
	//##ModelId=3FB2143101DB
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//##ModelId=3FB214310221
	afx_msg void OnNcMouseMove(UINT nHitTest, CPoint point);
	//##ModelId=3FB214310267
	afx_msg UINT OnNcHitTest(CPoint point);
	//##ModelId=3FB21431028F
	afx_msg void OnMusicaAdd();
	//##ModelId=3FB21431029A
	afx_msg void OnDblclkListaMusica(NMHDR* pNMHDR, LRESULT* pResult);
	//##ModelId=3FB2143102E0
	afx_msg void OnEndlabeleditListaMusica(NMHDR* pNMHDR, LRESULT* pResult);
	//##ModelId=3FB214310326
	afx_msg void OnSelchangingTab(NMHDR* pNMHDR, LRESULT* pResult);
	//##ModelId=3FB21431036C
	afx_msg void OnMusicaDel();
	//##ModelId=3FB214310376
	afx_msg void OnButtonMidiTest();
	//##ModelId=3FB214310378
	afx_msg void OnButtonWavTest();
	//##ModelId=3FB214310381
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	//##ModelId=3FB2143103E4
	afx_msg void OnSelchangeComboMidi();
	//##ModelId=3FB214320007
	afx_msg void OnMusicaAr();
	//##ModelId=3FB214320010
	afx_msg void OnMusicaAb();
	//##ModelId=3FB214320012
	afx_msg void OnSelchangeListIdioma();
	//##ModelId=3FB21432001B
	afx_msg void OnButtonPMusic();
	//##ModelId=3FB214320024
	afx_msg void OnButtonPPieces();
	//##ModelId=3FB214320026
	afx_msg void OnButtonPPlayers();
	//##ModelId=3FB21432002F
	afx_msg void OnButtonPData();
	//##ModelId=3FB214320038
	afx_msg void OnButtonPTexts();
	//##ModelId=3FB21432003A
	afx_msg void OnButtonPFondos();
	//##ModelId=3FB214320042
	afx_msg void OnSelchangeComboResolucion();
	//##ModelId=3FB214320044
	afx_msg void OnChangeEditTextos();
	//##ModelId=3FB21432004D
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	//##ModelId=3FB214320092
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CONFIGDLG_H__5EE82404_1E48_4477_9B19_8DF529C18A3D__INCLUDED_)
