//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


int get_cpu_cmov();
int get_cpu_fpu();
int get_cpu_mmx();
int get_cpu_mmxplus();
int get_cpu_sse();
int get_cpu_sse2();
int get_cpu_3dnow();
int get_cpu_enh3dnow();

bool midi_test(int driver);
bool midi_playing();
void digi_test(int driver);
void find_sound_drivers(CComboBox *CMidiBox, CComboBox *CFXBox);

int get_midi_driver_id(int driver);
int get_digi_driver_id(int driver);
int get_digi_driver_index(int id);
int get_midi_driver_index(int id);

void set_vol(int digi, int midi);
int get_digi_vol();
int get_midi_vol();

const char *get_string(char *section, char *key, char *def);
void set_string(char *section, char *key, const char *val);
int get_int(char *section, char *key, int def);
void set_int(char *section, char *key, int val);
int get_id(char *section, char *key, int def);
void set_id(char *section, char *key, int val);

//##ModelId=3FB21432013C
struct al_resolucion
{
	//##ModelId=3FB214320147
	unsigned int width;
	//##ModelId=3FB214320148
	unsigned int height;

	//##ModelId=3FB214320149
	bool operator==(const al_resolucion& r2) const
	{
		return width == r2.width && height == r2.height;
	}

	//##ModelId=3FB214320152
	bool operator<(const al_resolucion& r2) const
	{
		return width<r2.width || (width==r2.width && height<r2.height);
	}

	//##ModelId=3FB21432015A
	bool operator>(const al_resolucion& r2) const
	{
		return width>r2.width || (width==r2.width && height>r2.height);
	}

	//##ModelId=3FB21432015D
	bool operator<=(const al_resolucion& r2) const
	{
		return width<r2.width || (width==r2.width && height<=r2.height);
	}

	//##ModelId=3FB214320164
	bool operator>=(const al_resolucion& r2) const
	{
		return width>r2.width || (width==r2.width && height>=r2.height);
	}
};

void get_valid_bpp (const al_resolucion& res, int& c15, int& c16, int& c24, int& c32);
al_resolucion* get_lista_resoluciones(int& size);

void init_all(HWND wnd);
void close_all();
