#include "palimedes.h"

class tableau_class
{
   private:
      int block[ 6 ];

      void clear_blocks();

   public:
      tableau_class();
      void draw( DATAFILE *block_gfx, BITMAP *bmp );
      void add_block( int colour );
      int cash_in( particle_system *p, matrix_of_blocks_class *m );

};

tableau_class::tableau_class()
{
   int i;
   for ( i = 0; i <= 6; i++)
      block[i] = 0;
}

void tableau_class::clear_blocks()
{
   int i;
   for ( i = 0; i <= 6; i++)
      block[i] = 0;
}

//Draws blocks from right to left
void tableau_class::draw( DATAFILE *block_gfx, BITMAP *bmp)
{
   int i;
   for ( i = 0; i <= 5; i++ )
      if (block[i] != 0)
         draw_rle_sprite( bmp, (RLE_SPRITE *)(block_gfx[ block[i] - 1 ].dat), (5 - i) * TILE_SIZE, 0);
}

void tableau_class::add_block( int colour )
{
   int i;
   //shift all blocks in tableau forward
   for ( i = 5; i >= 0; i-- )
      block[i + 1] = block[i];

   //add new block
      block[0] = colour;
}

//Returns how many lines you destroyed
int tableau_class::cash_in( particle_system *p, matrix_of_blocks_class *b )
{
   int lines;

   int i, c, x;
   int blocks_of[6];
   int of_a_kind[6];


   //Reset everything
   for ( i = 0; i <= 6; i++)
   {
      blocks_of[ i ] = 0;
      of_a_kind[ i ] = 0;
   }


   //How many of each kind of block
   for ( i = 0; i <= 5; i++)
      blocks_of[block[i]]++;

   lines = 0;
   //how many singles, pairs, triples, quads, quints, or hexs you got
   for ( i = 1; i <= 6; i++ )
      of_a_kind[ blocks_of[i] ]++;


   //Six Of A Kind
   if ( of_a_kind[6] == 1 )
   {
      lines = 3;
   }

   //Four of a kind
   if ( of_a_kind[4] == 1 )
   {
      lines += 2;
   }

   //Full House
   if (  (of_a_kind[2] >= 1 ) && (of_a_kind[3] >= 1) )
   {
      lines += 3;
   }

   //Two Pairs
   if (of_a_kind[2] == 2)
   {
      lines += 2;
   }

   //Three Pairs
   if ( of_a_kind[2] == 3)
   {
      lines += 4;
   }

   if ( lines > 0 )
   {
      printf( "%i lines!\n", lines );
      for ( i = 1; i <= lines; i++ )
         b->destroy_last_row( p );
   }

   clear_blocks();
   return lines;
}
