#define MAX_PARTICLES      500
#include <allegro.h>


typedef struct particle
{
   double x, y, vx, vy;
   int life;
} particle;

class particle_system
{
   private:

   double minspeed, maxspeed, rnd, grav;
   particle p[ MAX_PARTICLES ];


   public:

   particle_system( double min_speed, double max_speed, double randomness, double gravity );
   void move();
   void add_a_particle( double x, double y, int life );
   void add( int numtoadd, double x, double y, int life );
   void draw( BITMAP *bmp, int colour );
};

void particle_system::add_a_particle( double x, double y, int life )
{
   int i;
   float rang;
   double rspeed;

   for ( i = 0;  ( p[ i ].life > 0 ) && ( i < MAX_PARTICLES); i++ );

   p[ i ].x = x + ( (rnd*2 ) * rand()/(RAND_MAX+1.0)) - rnd;
   p[ i ].y = y + ( (rnd*2 ) * rand()/(RAND_MAX+1.0)) - rnd;

   rang = ( 256 * rand()/(RAND_MAX+1.0) );
   rspeed = ( (maxspeed - minspeed) * rand()/(RAND_MAX+1.0)) + minspeed;

   p[ i ].vx = cos( ftofix(rang) ) * rspeed;
   p[ i ].vy = sin( ftofix(rang) ) * rspeed;
   p[ i ].life = life;

}

particle_system::particle_system( double min_speed, double max_speed, double randomness, double gravity )
{
   int i;
   //Initialization
   minspeed = min_speed;
   maxspeed = max_speed;
   rnd = randomness;
   grav = gravity;

   for ( i = 0; i <= MAX_PARTICLES; i++ )
      p[ i ].life = 0;
}

void particle_system::move()
{
   int i;
   for ( i = 0; i <= MAX_PARTICLES; i++ )
      if ( p[ i ].life > 0 )
      {
         p[ i ].x += p[ i ].vx;       //Move position vector according to velocity vector
         p[ i ].y += p[ i ].vy;

         p[ i ].vy += grav;     //Gravity
         p[ i ].life -= 1;
      }
}

void particle_system::add( int numtoadd, double x, double y, int life )
{
   int i;
   for (i = 1; i <= numtoadd; i++ )
      add_a_particle( x, y, life );
}


void particle_system::draw( BITMAP *bmp, int colour )
{
   int i;

   for ( i = 0; i <= MAX_PARTICLES; i++ )
      if ( p[ i ].life > 0 )
      {
         rectfill( bmp, (int)p[ i ].x - 2, (int)p[ i ].y - 2, (int)p[ i ].x + 2, (int)p[ i ].y + 2, colour );
      }
}


