#include "palimedes.h"

/*A moving object is to be inherited by other objects.  It is a simple object that when itterated will move
  closer to it's destination at it's speed.  Additionally it will refuse to go out of it's boundries.
*/
class moving_object
{
   protected:
      int pos_x, dest_x, vel_x;      //Destination pixel,    velocity: pixels/itteration
      int pos_y, dest_y, vel_y;

      int speed;
      int min_x, min_y, max_x, max_y;

      int in_bounds();

   public:
      moving_object( int xp, int yp, int sp, int minx, int miny, int maxx, int maxy );

      virtual void itterate();
      virtual void draw( DATAFILE *block_gfx, BITMAP *bmp );

      void move_to( int dx, int dy );
      void place_at( int dx, int dy );
      int get_x();
      int get_y();

};

//Constructor sets (x,y) position, unit speed, and the boundries in which it must follow
moving_object::moving_object(int xp, int yp, int sp, int minx, int miny, int maxx, int maxy)
{
   //Position
   pos_x = xp;
   dest_x = xp;
   pos_y = yp;
   dest_y = yp;

   //Speed
   speed = sp;

   //Set boundries
   min_x = minx;
   min_y = miny;
   max_x = maxx;
   max_y = maxy;


   vel_x = 0;
   vel_y = 0;

}

//Checks to see if the destination is inside bounds
int moving_object::in_bounds()
{
   int retval;

   retval = 1;

   //Don't choose to go out of bounds
   if ( tile_pos(dest_x) > max_x )
      retval = 0;
   else
      if ( tile_pos(dest_x) < min_x )
         retval = 0;

   if ( tile_pos(dest_y) > max_y )
      retval = 0;
   else
      if ( tile_pos(dest_y) < min_y )
         retval = 0;

   return retval;

}


//Calculate and apply movements for movign object
void moving_object::itterate()
{
   //Where is the charecter desiring to go on the x_axis
   if (dest_x > pos_x)
      vel_x = speed;             //If it's destination is to the right then accelerate it right
   else
      if (dest_x < pos_x)
         vel_x = speed * -1;    //Dito: left
      else
         vel_x = 0;              //If on the destination, then don't move it

   //Where is the destination
   if (dest_y > pos_y)
      vel_y = speed;             //If the
   else
      if (dest_y < pos_y)
         vel_y = speed * -1;    //Dito: left
      else
         vel_y = 0;              //If destination is right ontop of the object, then don't move anywhere else

   //Move charecter
   pos_x += vel_x;
   pos_y += vel_y;

   //Catch position if within 3 units of it's destination
   if ( abs( pos_x - dest_x ) <= 3 )
   {
      pos_x = dest_x;
      vel_x = 0;
   }
   if ( abs( pos_y - dest_y ) <= 3 )
   {
      pos_y = dest_y;
      vel_y = 0;
   }


}

//Overload this,  it's virtual
void moving_object::draw( DATAFILE *block_gfx, BITMAP *bmp )
{
}


//Change the destination of the object
void moving_object::move_to( int dx, int dy)
{
   //Change the destination
   dest_x = dx;
   dest_y = dy;

   //If the destination is out of bounds, then make the destination the farthest point possibly in bounds
   if (dest_x > max_x)
      dest_x = max_x;
   else
      if (dest_x < min_x)
         dest_x = min_x;

   if (dest_y > max_y)
      dest_y = max_y;
   else
      if (dest_y < min_y)
         dest_y = min_y;
}

//Move the object directly to a location without changing it's destination
void moving_object::place_at( int dx, int dy)
{
   //Move the object
   pos_x = dx;
   pos_y = dy;

   //If it is out of bounds then move it to the closest position in boundries
   if (pos_x > max_x)
      pos_x = max_x;
   else
      if (pos_x < min_x)
         pos_x = min_x;

   if (pos_y > max_y)
      pos_y = max_y;
   else
      if (pos_y < min_y)
         pos_y = min_y;
}


//Returns the x position of a moving object
int moving_object::get_x()
{
   return pos_x;
}


//Returns the y position of a moving object
int moving_object::get_y()
{
   return pos_y;
}
