#define GAME_MODE_PLAY        1
#define GAME_MODE_OVER        2

#include "palimedes.h"

class game_class
{
   private:
      dude_class *dude;
      shooterblock_class *shootblock;
      matrix_of_blocks_class *block_matrix;
      tableau_class *tableau;

      particle_system *particle;

      int blocks_killed;

      int game_mode;
      float game_speed;

      int blue;

      void do_input();
      void retrieve_block();

      int key_down;

   public:
      game_class();
      void itterate();
      void draw( DATAFILE *block_gfx, BITMAP *bmp, BITMAP *tbl );

};

game_class::game_class()
{
   srand( time(0) );
   dude = new dude_class();
   shootblock = new shooterblock_class();
   block_matrix = new matrix_of_blocks_class();
   tableau = new tableau_class();
   particle = new particle_system( 0.2, 3.0, 16, 0.09);


   dude->catchblock( shootblock );
   block_matrix->make_new_line();

   game_speed = BLOCK_MATRIX_START_SPEED;
   key_down = 0;
   blue = makecol( 90, 120, 255 );
   game_mode = GAME_MODE_PLAY;
}

void game_class::draw( DATAFILE *block_gfx, BITMAP *bmp, BITMAP *tbl )
{
   shootblock->draw( block_gfx, bmp );
   block_matrix->draw( block_gfx, bmp );
   dude->draw( block_gfx, bmp );
   tableau->draw( block_gfx, tbl );

   particle->draw( bmp, blue );

}

void game_class::do_input()
{
   if ( key[ KEY_LEFT ] )
      dude->go_left();

   if ( key[ KEY_RIGHT ] )
      dude->go_right();

   if ( key[ KEY_SPACE ] )
      dude->go_shoot();

   if ( key[ KEY_DOWN ] )
      blocks_killed += tableau->cash_in( particle, block_matrix );

   if ( key[ KEY_Z ] )
   {
      if ( !key_down )
      {
         shootblock->change_number( -1 );
         key_down = 1;
      }
   }
   else
   {
      if ( key[ KEY_C ] )
      {
         if ( !key_down )
         {
            shootblock->change_number( 1 );
            key_down = 1;
         }
      }
      else
      {
         key_down = 0;
      }
   }
}

void game_class::retrieve_block()
{
   shootblock->place_at(0, DUDE_Y_POS );
   dude->catchblock( shootblock );
   //Speed the game up
   game_speed += BLOCK_MATRIX_SPEED;
}

void game_class::itterate()
{
   int xp, yp;

   do_input();

   dude->itterate();
   shootblock->itterate();
   particle->move();

    block_matrix->move_down( game_speed );

   //If the shootblock exits screen then replace it
   if (shootblock->get_y() == -TILE_SIZE)
      retrieve_block();

   //Where is the shootblock on the tilemap
   xp = tile_pos(shootblock->get_x());
   yp = tile_pos(shootblock->get_y());

   //If the shootblocks hits the barage then check if it is the same colour as the block it hit.
   if ( block_matrix->block_at( xp, yp ) > 0)
   {
      if (block_matrix->block_at( xp, yp ) == shootblock->get_number())
      {
         block_matrix->destroy( particle, xp, yp );
         tableau->add_block( shootblock->get_number() );
         //TODO: add to tableau
      }

      retrieve_block();
   }

}
