#include "palimedes.h"

class dude_class : public moving_object
{
   private:
      shooterblock_class *block_in_hand;

   public:
      dude_class();

      void itterate();
      void draw( DATAFILE *block_gfx, BITMAP *bmp );
      void catchblock( shooterblock_class *m );

      void go_left();
      void go_right();
      void go_shoot();
};

dude_class::dude_class() : moving_object( TILE_SIZE * 3, DUDE_Y_POS, DUDE_SPEED, 0, 0, TILE_SIZE * BLOCK_MATRIX_WIDTH, TILE_SIZE * BLOCK_MATRIX_HEIGHT )
{

   block_in_hand = NULL;

}

void dude_class::itterate()
{
   moving_object::itterate();

   //If a shooterblock is caught then move it to dudes position
   if ( block_in_hand != NULL )
      block_in_hand->move_to( pos_x, pos_y );
}
//*/

//Draws the dude on bitmap *bmp
void dude_class::draw( DATAFILE *block_gfx, BITMAP *bmp )
{
   int xp;

   //Draw dude
   rectfill( bmp, pos_x, pos_y, pos_x + TILE_SIZE - 1, pos_y + 10, makecol(0,100,200) );



   #ifdef SHOW_DUDE_DEBUG
      //Draw his "Tile Location"
      xp = tile_pos(pos_x) * TILE_SIZE;
      rect( bmp, xp, pos_y, xp + TILE_SIZE - 1, pos_y + TILE_SIZE - 1, makecol(200, 0, 0 ) );

      //Draw his "Destination Tile"
      xp =  tile_pos(dest_x) * TILE_SIZE;
      rect( bmp, xp, pos_y, xp + TILE_SIZE - 1, pos_y + TILE_SIZE - 1, makecol( 0, 0, 200 ) );
   #endif
}

void dude_class::catchblock( shooterblock_class *m )
{
   block_in_hand = m;
}

void dude_class::go_left()
{
   move_to(  (tile_pos( pos_x ) * TILE_SIZE) - TILE_SIZE, pos_y );
}

void dude_class::go_right()
{
   move_to(  (tile_pos( pos_x ) * TILE_SIZE) + TILE_SIZE, pos_y );
}

void dude_class::go_shoot()
{
   if (block_in_hand != NULL)
      if ( tile_pos(block_in_hand->get_x()) == tile_pos( pos_x ) )
      {
         block_in_hand->shoot();
         block_in_hand = NULL;

      }

}
