 /*

   PALIMEDES       2001
   By Daniel McKinnon


   TODO:
      Change Game Interface (seperate from game itself)


      Maybe: Change Graphics System to Dirty Rectangles
      Add Sound
      Add Music
*/

//#define SHOW_DUDE_DEBUG

#include <allegro.h>
#include <time.h>
#include <stdio.h>


#include "palimedes.h"
#include "particle_system.cpp"
#include "moving_object.cpp"
#include "shooter_block.cpp"
#include "dude_class.cpp"
#include "matrix_of_blocks_class.cpp"
#include "tableau_class.cpp"
#include "game_class.cpp"

volatile int game_timer = 0;
void inc_game_timer()
{
	game_timer++;
}END_OF_FUNCTION( inc_game_timer );

void start_speed_counter()
{
   LOCK_VARIABLE( game_timer );
   LOCK_FUNCTION( (void *)inc_game_timer );

   install_int_ex( inc_game_timer, BPS_TO_TIMER(60) );
}

void stop_speed_counter()
{

}

int tile_pos( int i )
{
   return (int)( i / TILE_SIZE );
}




//////////////////////////////////////////////////////////////////////////////////



int main(void)
{
   BITMAP *game_screen;
   BITMAP *tableau_screen;

   BITMAP *background;
   DATAFILE *mygfx;

   game_class *game;

   allegro_init();
   install_keyboard();
   install_mouse();
   install_timer();

   set_color_depth( 16 );
   if ( set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0 ) < 0 )
      exit( 1 );              //Graphics Error

   tableau_screen = create_bitmap( (6 * TILE_SIZE), TILE_SIZE + 2 );
   game_screen = create_bitmap( (BLOCK_MATRIX_WIDTH + 1) * TILE_SIZE, (BLOCK_MATRIX_HEIGHT + 1) * TILE_SIZE );
   if (game_screen == NULL)
      exit( 2 );              //Memory error

   mygfx = load_datafile( "pal.dat" );
   background = load_bitmap( "bg02.bmp",0 );

   game = new game_class();

   start_speed_counter();

   //Clear the screen with the background colour
   blit( background, screen, 0, 0, 0, 0, 640, 480 );
   //Darken Background for drawing onto game screen and tableau
   set_trans_blender( 0, 0, 0, 128 );
   drawing_mode( DRAW_MODE_TRANS, NULL, 0, 0 );
   rectfill( background, 0, 0, 640, 480, makecol(0,0,0) );
   drawing_mode( DRAW_MODE_SOLID, NULL, 0, 0 );


   //MAIN GAME LOOP HERE
   while (!key[ KEY_ESC] )
   {
      while ( game_timer > 0 )
      {
         game->itterate();
         game_timer--;
      }

      blit( background, game_screen, 0, 0, 0, 0, game_screen->w, game_screen->h );
      blit( background, tableau_screen, 48,445, 0,0, tableau_screen->w, tableau_screen->h );
      game->draw( mygfx, game_screen, tableau_screen );

      blit( game_screen, screen, 0, 0, 0, 0, game_screen->w, game_screen->h );
      blit( tableau_screen, screen, 0, 0, 48,445,tableau_screen->w, tableau_screen->h );
   }



   destroy_bitmap( game_screen );
   destroy_bitmap( tableau_screen );
   unload_datafile( mygfx );
   allegro_exit();

   return 0;
} END_OF_MAIN();

