#include "palimedes.h"

class matrix_of_blocks_class
{
   private:
      int lines;
      int block[ BLOCK_MATRIX_WIDTH + 2][ BLOCK_MATRIX_HEIGHT + 2];

      float count;

   public:
      matrix_of_blocks_class();

      void make_new_line();
      void move_down( float howfar );

      void draw( DATAFILE *block_gfx, BITMAP *bmp );

      int block_at( int xp, int yp );
      void destroy( particle_system *p, int xp, int yp);

      void destroy_last_row( particle_system *p);
};

matrix_of_blocks_class::matrix_of_blocks_class()
{
   int xx, yy;

   count = 0;

   for ( xx = 0; xx <= BLOCK_MATRIX_WIDTH; xx++ )
      for ( yy = 0; yy <= BLOCK_MATRIX_HEIGHT; yy++ )
         block[ xx ][ yy ] = 0;
}

void matrix_of_blocks_class::make_new_line()
{
   int xx, yy;
   //Move everything down
   for ( yy = BLOCK_MATRIX_HEIGHT - 1; yy >= 0; yy--)
      for (xx = 0; xx <= BLOCK_MATRIX_WIDTH; xx++)
         block[xx][yy + 1] = block[xx][yy];

   for ( xx = 0; xx <= BLOCK_MATRIX_WIDTH; xx++ )
   {
      block[ xx ][ 0 ] = (int)(rand()%6) + 1;
   }
}

void matrix_of_blocks_class::move_down( float howfar )
{
   count += howfar;
   if ( count >= TILE_SIZE )
   {
      count -= TILE_SIZE;
      make_new_line();
   }

}

void matrix_of_blocks_class::draw( DATAFILE *block_gfx, BITMAP *bmp )
{
   int xx, yy;
   for ( xx = 0; xx <= BLOCK_MATRIX_WIDTH; xx++ )
      for ( yy = 0; yy <= BLOCK_MATRIX_HEIGHT; yy++)
         if ( block[ xx ][ yy ] > 0 )
            draw_rle_sprite( bmp, (RLE_SPRITE *)( block_gfx[ block[xx][yy] - 1 ].dat ), xx * TILE_SIZE, (yy * TILE_SIZE) + (int)count - TILE_SIZE);
}

int matrix_of_blocks_class::block_at( int xp, int yp )
{
   int retval = 0;
   if (  (xp >= 0) && (yp >= 0) && (xp <= BLOCK_MATRIX_WIDTH) && (yp <= BLOCK_MATRIX_HEIGHT) )
      retval = block[xp][yp];

   return retval;
}

void matrix_of_blocks_class::destroy( particle_system *p, int xp, int yp )
{
   if (  (xp >= 0) && (yp >= 0) && (xp <= BLOCK_MATRIX_WIDTH) && (yp <= BLOCK_MATRIX_HEIGHT) )
      block[xp][yp] = 0;

   //Todo: Add particle explosions
   p->add( 10, xp * TILE_SIZE, yp * TILE_SIZE, 100 );
}


void matrix_of_blocks_class::destroy_last_row( particle_system *p )
{
   int xx, yy;
   int is_blank = 0;

   //Find Last Row
   for (yy = 0; (!is_blank)&&(yy <= BLOCK_MATRIX_HEIGHT); yy++)
   {
      for (xx = 0; (block[xx][yy] == 0)&&(xx <= BLOCK_MATRIX_WIDTH); xx++);
      if (xx >= BLOCK_MATRIX_WIDTH)
         is_blank = 1;
   }

   //The last row is the row before the one with no blocks
   yy -= 2;

   printf( "Destroy Last Row %i\n", yy );

   //Destroy All Blocks In The last row
   for (xx = 0; xx <= BLOCK_MATRIX_WIDTH; xx++ )
      destroy( p, xx, yy );

}
