#include "palimedes.h"

//A shooterblock is-a moving_object.  It is the block that you shoot at the block_matrix
class shooterblock_class: public moving_object
{
   private:
      int number;

   public:

      shooterblock_class();
      void draw( DATAFILE *block_gfx, BITMAP *bmp );
      void shoot();
      int shooterblock_class::get_number();
      void shooterblock_class::change_number( int newnum );

};

shooterblock_class::shooterblock_class() : moving_object( 0, DUDE_Y_POS, SHOOTERBLOCK_SPEED, 0, -TILE_SIZE, BLOCK_MATRIX_WIDTH * TILE_SIZE, BLOCK_MATRIX_HEIGHT * TILE_SIZE)
{
   number = 1;
}

void shooterblock_class::draw( DATAFILE *block_gfx, BITMAP *bmp )
{
   RLE_SPRITE *useme = (RLE_SPRITE *)(block_gfx[ number - 1 ].dat);
   draw_rle_sprite(bmp, useme, pos_x, pos_y );
//        rectfill( bmp, pos_x, pos_y, pos_x + TILE_SIZE, pos_y + TILE_SIZE, makecol( 0, 250, 0 ) );
}


void shooterblock_class::shoot()
{
   //Shoot at the top
   move_to( tile_pos(pos_x) * TILE_SIZE, -100 );
}

int shooterblock_class::get_number()
{
   return number;
}

void shooterblock_class::change_number( int displace )
{
   int newnum = number;
   newnum += displace;

   if ( (newnum > 0) && (newnum < 7) )
      number = newnum;

}
