#include <string.h>
#include <allegro.h>
#include "soundbox.h"
#include "main.h"
#include "../data/data_sfx.h"


int music_vol;
int sound_vol;
int initOK = 0;

DATAFILE *data;

// returns non-zero on error
int init_soundbox(char *datafile) {
    initOK = 0;
    music_vol = 200;
    sound_vol = 200;
    set_volume(sound_vol, music_vol);
    // load datafile
	data = load_datafile(datafile);
	if (data == NULL) return -1;

    initOK = 1;
	return 0;
}




void uninit_soundbox() {
    if (!initOK) return;
    // unload datafile
    unload_datafile(data);
    initOK = 0;
}



void play_music(int id) {
    play_midi((MIDI *)data[id].dat, 1);
    if (id == TITLE) midi_seek(4);
    if (id == MIDI1) midi_seek(62);
    if (id == MIDI2) midi_seek(21);
    if (id == MIDI3) midi_seek(37);
    if (id == MIDI4) midi_seek(3);
    if (id == MIDI5) midi_seek(56);
}

void stop_music() {
    stop_midi();
}

void poll_music() {
    // not needed
}

void play_sound(int id) {
    play_sample((SAMPLE*)data[id].dat, sound_vol, 128, 1000, 0);
}



