#ifndef _CPLAYER_H_
#define _CPLAYER_H_


#include "CEntity.h"

class CPlayer : public CEntity {
	public:
        CPlayer(EType p_type, DATAFILE *p_gfx, int x, int y);
        ~CPlayer();
        void update(int handleInput);
		void render(BITMAP *p_bmp, int p_offsetX, int p_offsetY, double p_zoom);
		void crash(EType e);
		void jump();
		void pickup();
		int canCrash() { return m_zPos < 10; }
		int canJump() { return m_zPos < 1; }
		int isJumping() { return m_state == 1; }
		int isCrashed() { return m_state == 2; }
		double getSpeed() { return m_speed; }
		double getMaxSpeed() { return m_maxSpeed; }
		double getDX() { return m_dx; }
		double getDY() { return m_dy; }

    protected:
        double m_dz;
        double m_angle;
        int m_state;
        double m_speed;
        double m_maxSpeed;
        BITMAP *m_hat, *m_hatend;
        BITMAP *m_crashDude, *m_crashToboggan;
        double m_dudeOffset;
        int m_jumpCount;
        double m_dx, m_dy;
};

#endif

