#include "CEntity.h"
#include "../data/data_gfx.h"


CEntity :: CEntity(EType p_type, DATAFILE *p_gfx, int x, int y) {
    m_xPos = x;
    m_yPos = y;
    m_zPos = 0;
    m_type = p_type;
    m_bbx = m_bby = m_bbh = m_bbw = 0;

    switch(m_type) {
        case ePlayer: {
            m_bmp = (BITMAP *)p_gfx[TOBOGGAN].dat;
            m_bbx = - m_bmp->w / 2;
            m_bby = 0;
            m_bbw = m_bmp->w;
            m_bbh = 10;
            break;
        }
        case eGift: {
            m_bmp = (BITMAP *)p_gfx[GIFT].dat;
            int w = m_bmp->w - 8;
            m_bbx = - w / 2;
            m_bby = 0;
            m_bbw = w;
            m_bbh = 10;
            break;
        }
        case eTree: {
            m_bmp = (BITMAP *)p_gfx[TREE].dat;
            int w = m_bmp->w - 22;
            m_bbx = - w / 2;
            m_bby = 0;
            m_bbw = w;
            m_bbh = 10;
            break;
        }
        case eStone: {
            m_bmp = (BITMAP *)p_gfx[STONE].dat;
            int w = m_bmp->w - 14;
            m_bbx = - w / 2;
            m_bby = 0;
            m_bbw = w;
            m_bbh = 10;
            break;
        }
        case eStub: {
            m_bmp = (BITMAP *)p_gfx[STUB].dat;
            int w = m_bmp->w - 14;
            m_bbx = - w / 2;
            m_bby = 0;
            m_bbw = w;
            m_bbh = 10;
            break;
        }
        case eJump: {
            m_bmp = (BITMAP *)p_gfx[JUMP].dat;
            int w = m_bmp->w - 6;
            m_bbx = - w / 2;
            m_bby = 0;
            m_bbw = w;
            m_bbh = 20;
            break;
        }
        case eLogo: {
            m_bmp = (BITMAP *)p_gfx[LOGO].dat;
            break;
        }
        case eTrack: {
            m_bmp = (BITMAP *)p_gfx[TRACK].dat;
            break;
        }
        case eShadow: {
            m_bmp = (BITMAP *)p_gfx[SHADOW].dat;
            break;
        }
    }

    m_cx = m_bmp->w / 2;
    m_cy = m_bmp->h / 2;
}


CEntity :: ~CEntity() {
}

void CEntity :: move(double p_dx, double p_dy) {
    m_xPos += p_dx;
    m_yPos += p_dy;
}

void CEntity ::changeHeight(double p_dz) {
    m_zPos += p_dz;
}

void CEntity :: setPosition(double p_x, double p_y) {
    m_xPos = p_x;
    m_yPos = p_y;
}

void CEntity :: render(BITMAP *p_bmp, int p_offsetX, int p_offsetY, double p_zoome) {
    int x = (int)(m_xPos - p_offsetX);
    int y = (int)(m_yPos - p_offsetY);

    if (m_type == ePlayer) {
        stretch_sprite(p_bmp, m_bmp, x - m_cx * 2, y - m_bmp->h * 2 - m_zPos, m_bmp->w * 2, m_bmp->h * 2);
    }
    else {
        draw_sprite(p_bmp, m_bmp, x - m_cx, y - m_bmp->h - m_zPos);
    }
}

void CEntity :: update() {
}

int CEntity :: collide(CEntity *e) {
    if (m_xPos + m_bbx + m_bbw < e->x() + e->bbx()) return 0;
    if (m_xPos + m_bbx > e->x() + e->bbx() + e->bbw()) return 0;
    if (m_yPos + m_bby + m_bbh < e->y() + e->bby()) return 0;
    if (m_yPos + m_bby > e->y() + e->bby() + e->bbh()) return 0;
    return 1;
}


