/**
 *
 *  HOLIDAY HILLS
 *
 **/



#include <time.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <allegro.h>
#include <list>
#include <vector>

#include "main.h"
#include "CEntity.h"
#include "CPlayer.h"
#include "soundbox.h"

#include "../data/data_gfx.h"
#include "../data/data_sfx.h"


#define LOG_FILE_NAME	"log.txt"
#define GAME_NAME		"Holiday Hills"
#define GAME_VERSION	"0.9"


#define GS_INIT     0
#define GS_TITLE    1
#define GS_PLAY     2
#define GS_END      3
#define GS_QUIT     4

using namespace std;

// mm.... globals!
BITMAP *swap_screen = NULL;
BITMAP *stretch_screen = NULL;
DATAFILE *gfx = NULL;
int game_state = GS_INIT;
int window = 1;
int hiscore;
int init_ok = 0;
int game_is_paused = 0;
list<CEntity *> entities;
list<CEntity *> jumps;
list<CEntity *> gifts;
list<CEntity *> tracks;
CPlayer *player;
CEntity *shadow;
double camera_target_x;
double camera_target_y;
double camera_x;
double camera_y;
double camera_zoom;

// more stuff
int score;
int presents;

// generation stuff
double yDiff;
double yPos;

// timer stuff
volatile int frame_count;
volatile int fps;
volatile int logic_count;
volatile int lps;
volatile int cycle_count;
volatile int game_count;


// hints
char *hints[] = {
    "Try avoiding the obstacles!",
    "The faster you go, the more points you get!",
    "Pick up presents to increase you maximum woosh!",
    "Ouch! That gotta hurt!",
    "Jump to get points for all your presents!",
    "This game was written for XMAS-hack 2006!",
    "Visit www.freelunchdesign.com for more games!",
    "Turning makes you go slower.",
    "Landing at an angle will slow you down.",
    "You can do better! One more time!",
    "Try not to jump unless you have some presents!",
    "XMAS-greeting to all at allegro.cc!",
    "Hardware is nothing. Gameplay is everything.",
    "Press ALT + ENTER to toggle full screen."
};

int numHints = 14;
int showHint = 0;


// keeps track of frames each second
void fps_counter(void) {
	fps = frame_count;
	frame_count = 0;
	lps = logic_count;
	logic_count = 0;
}
END_OF_FUNCTION(fps_counter)


// keeps track of internal game speed
void cycle_counter(void) {
	cycle_count++;
	game_count++;
}
END_OF_FUNCTION(game_counter)


// writes a string of formated text to the log file
void log(char *format, ...) {
	va_list ptr;
 	FILE *fp;

	fp = fopen(LOG_FILE_NAME, "at");
	if (fp) {
		va_start(ptr, format);
		vfprintf(fp, format, ptr);
		fprintf(fp, "\n");
		va_end(ptr);

		fclose(fp);
	}
}


// saves a screenshot
void take_screenshot(BITMAP *bmp) {
	static int number = 0;
	PALETTE p;
	BITMAP *b;
	char buf[256];
	int ok = 0;

	do {
		sprintf(buf, "holidayhills_%03d.bmp", number ++);
		if (!exists(buf)) ok = 1;
		if (number > 999) return;
	} while(!ok);

	get_palette(p);

	b = create_sub_bitmap(bmp, 0, 0, bmp->w, bmp->h);

	save_bitmap(buf, b, p);

	destroy_bitmap(b);
}


void main_play_sound(int id) {
    play_sound(id);
}


//
int toggle_gfx() {
	window = !window;
    if (set_gfx_mode((window ? GFX_AUTODETECT_WINDOWED : GFX_AUTODETECT_FULLSCREEN), 640, 480, 0, 0)) {
		log("  *** failed");
		allegro_message("%s:\nFailed to enter gfx mode.", GAME_NAME);
		set_palette((RGB *)gfx[0].dat);
		return FALSE;
	}
	set_display_switch_mode(SWITCH_BACKGROUND);
	set_palette((RGB *)gfx[0].dat);
	return TRUE;
}


// load
int load_game_data() {
	int ok = 1;
	PACKFILE *fp = pack_fopen("data/hh.dat", "rb");
	if (fp) {
		pack_fread(&window, sizeof(window), fp);
		pack_fread(&sound_vol, sizeof(sound_vol), fp);
		pack_fread(&music_vol, sizeof(music_vol), fp);
		pack_fread(&hiscore, sizeof(hiscore), fp);

		pack_fclose(fp);
	}
	else {
		ok = 0;
		log("    something wrong with game data");
	}

	return ok;
}

// save
void save_game_data() {
	PACKFILE *fp = pack_fopen("data/hh.dat", "wb");
	if (fp) {
		pack_fwrite(&window, sizeof(window), fp);
		pack_fwrite(&sound_vol, sizeof(sound_vol), fp);
		pack_fwrite(&music_vol, sizeof(music_vol), fp);
		pack_fwrite(&hiscore, sizeof(hiscore), fp);

		pack_fclose(fp);
	}
}


// init the game
int init_game() {
	// start new logfile
	FILE *fp = fopen(LOG_FILE_NAME, "wt");
	fclose(fp);
	log("%s v%s log file\n---------------------------------------------\n", GAME_NAME, GAME_VERSION);

	log("\nInit game:");

	// start allegro
	log(" initializing allegro");
	allegro_init();


	// install timers
	log(" setting up timers");
	install_timer();
	LOCK_VARIABLE(cycle_count);
	LOCK_VARIABLE(logic_count);
	LOCK_VARIABLE(lps);
	LOCK_VARIABLE(fps);
	LOCK_VARIABLE(frame_count);
	srand(time(NULL));

	LOCK_FUNCTION(fps_counter);
	install_int(fps_counter, 1000);
	fps = 0;
	frame_count = 0;
	cycle_count = 0;

	LOCK_FUNCTION(cycle_counter);
	install_int(cycle_counter, 10);
	game_count = 0;


	log(" setting color depth (8)");
	set_color_depth(8);

	// init music and sound
	// install sound
	log(" installing sound");
	reserve_voices(64, 0);
	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL)) {
		log("  *** failed");
	}

	// allocating memory
	log(" allocating memory buffers");
	swap_screen = create_bitmap(640, 480);
	stretch_screen = create_bitmap(640, 480);
	if (swap_screen == NULL || stretch_screen == NULL) {
		log("  *** failed");
		allegro_message("%s:\nFailed to allocate memory for buffers.", GAME_NAME);
		return FALSE;
	}

//	set_window_close_button(FALSE);
	set_window_title(GAME_NAME);

	// load game data
	log(" loading game config");
	if (!load_game_data()) {
		log("  *** failed, resetting to defaults");
		sound_vol = 200;
		music_vol = 100;
		window = 1;
		hiscore = 1000;
	}

	log(" entering gfx mode");

    if (set_gfx_mode((window ? GFX_AUTODETECT_WINDOWED : GFX_AUTODETECT_FULLSCREEN), 640, 480, 0, 0)) {
		log("  *** failed");
		allegro_message("%s:\nFailed to enter gfx mode.", GAME_NAME);
		return FALSE;
	}
	set_display_switch_mode(SWITCH_BACKGROUND);

	// load data
	log(" loading data");
	packfile_password("piracy_is_theft");
	gfx = load_datafile("data/gfx.dat");
	packfile_password(NULL);
	if (gfx == NULL) {
    	log("  *** failed");
		allegro_message("%s:\nFailed to load gfx data.", GAME_NAME);
		return FALSE;
	}

    // start sounds
	log(" setting up sounds");
	packfile_password("piracy_is_theft");
	if (init_soundbox("data/sfx.dat") != 0) {
    	log("  *** failed");
		allegro_message("%s:\nFailed to load sfx data.", GAME_NAME);
		return FALSE;
	}
	packfile_password(NULL);

	// install some parts of allegro
	log(" installing keyboard");
	install_keyboard();

	// start game
	clear_to_color(screen, 1);
	set_palette((RGB *)gfx[AAAPAL].dat);

	log(" init OK!");
	init_ok = 1;
	game_state = GS_TITLE;

	return TRUE;
}


// uninits the game
void uninit_game() {
	log("\nExit game:");

	log(" destroying bitmaps");
	if (swap_screen != NULL) destroy_bitmap(swap_screen);
	if (stretch_screen != NULL) destroy_bitmap(stretch_screen);

	log(" unloading graphics");
	if (gfx != NULL) unload_datafile(gfx);

    // unload sound

	if (init_ok) {
		log(" saving game data");
		save_game_data();
	}

	log(" exiting allegro");
	allegro_exit();
}

void addSomething(int x, int y) {
    // add an obstacle
    int r = rand()%99;
    CEntity ::EType e = CEntity :: eStone;
    if (r >= 33) e = CEntity :: eStub;
    if (r >= 50) e = CEntity :: eTree;

    entities.push_back(new CEntity(e, gfx, x, y));
}


void start_game() {
	log("\nStarting new game.");
	game_is_paused = 0;
	game_state = GS_TITLE;

	play_music(TITLE);

    /*
    for(int i = 0; i < 320; i ++) {
        entities.push_back(new CEntity(CEntity :: eStone, gfx, rand()%640, rand()%44800));
    }
    for(int i = 0; i < 1000; i ++) {
        entities.push_back(new CEntity(CEntity :: eTree, gfx, rand()%640, rand()%44800));
    }
    for(int i = 0; i < 160; i ++) {
        entities.push_back(new CEntity(CEntity :: eStub, gfx, rand()%640, rand()%44800));
    }
    for(int i = 0; i < 160; i ++) {
        jumps.push_back(new CEntity(CEntity :: eJump, gfx, rand()%640, 1000 + rand()%48480));
    }
    for(int i = 0; i < 600; i ++) {
        gifts.push_back(new CEntity(CEntity :: eGift, gfx, rand()%640, 1000 + rand()%48480));
    }
    */



	// logo
    entities.push_back(new CEntity(CEntity :: eLogo, gfx, 320, 160));

	// create player
	player = new CPlayer(CEntity :: ePlayer, gfx, 460, 50);
	shadow = new CEntity(CEntity :: eShadow, gfx, player->x(), player->y());
	entities.push_back(shadow);
	entities.push_back(player);

	// add initial objects
	for(int y = -300; y < 480; y += 10) {
	    int x = player->x() - 640 + rand()%1280;
	    if (ABS(x - player->x()) > 30) addSomething(x, y);
    }


	// init stuff
	score = 0;
	presents = 0;
	yPos = yDiff = 0;
	showHint = rand()%numHints;
}


int update_game() {
    static int tick = 0;
    tick ++;

    if (key[KEY_ALT] && key[KEY_ENTER]) {
        toggle_gfx();
    }

    if (key[KEY_ESC]) game_state = GS_QUIT;

    if (game_state == GS_TITLE) {
        if (key[KEY_SPACE] || key[KEY_DOWN]) {
            game_state = GS_PLAY;
            play_music(MIDI1 + rand()%5);
        }
    }

    // update player
    player->update((game_state == GS_TITLE ? 0 : 1));

    if (player->isCrashed()) {
        shadow->setPosition(0, -100);
        if (key[KEY_SPACE]) {
            while(key[KEY_SPACE]);
            return -1;
        }
    }
    else {
        shadow->setPosition(player->x(), player->y());
    }

    if (!player->isJumping() && !player->isCrashed() && game_state != GS_TITLE && game_state == GS_PLAY && player->getSpeed() > 0) {
        tracks.push_back(new CEntity(CEntity :: eTrack, gfx, player->x(), player->y() - 6));
    }

    // add obstacles
    yDiff += player->getDY();
    yPos += player->getDY();
    if (yDiff > 9) {
        yDiff -= 9;
        addSomething(player->x() - 640 + rand()%1280, player->y() + 480);

        int r = rand()%99;
        if (yPos > 800 && r > 65) {
            // add presents
            gifts.push_back(new CEntity(CEntity :: eGift, gfx, player->x() - 640 + rand()%1280, player->y() + 480));
        }
        r = rand()%99;
        if (yPos > 1200 && r > 90) {
            // add jumps
            jumps.push_back(new CEntity(CEntity :: eJump, gfx, player->x() - 640 + rand()%1280, player->y() + 480));
        }
    }

    if (game_state == GS_PLAY) {
        // update score
        if (!(tick % 10)) {
            score += MAX(0, player->getSpeed());
        }
    }

    if (score > hiscore) {
        hiscore = score;
    }

    // check collisions
    // obstacles
    if (player->canCrash() && !player->isCrashed()) {
        for(list<CEntity *>::iterator i = entities.begin(); i != entities.end(); ++ i) {
            CEntity *e = (CEntity *)(*i);
            if (e != player && e != shadow) {
                if (e->collide(player)) {
                    player->crash(e->getType());
                }
            }
        }

        // gifts
        for(list<CEntity *>::iterator i = gifts.begin(); i != gifts.end(); ) {
            CEntity *e = (CEntity *)(*i);
            if (e->collide(player)) {
                // remove gift from list
                delete (*i);
                // update iterator
                i = gifts.erase(i);

	            // ka-ching!
	            presents ++;
	            player->pickup();
	            play_sound(LAUGH);

            }
            else {
                // update iterator
                ++ i;
            }
        }
    }

    // jumps
    if (player->canJump()) {
        for(list<CEntity *>::iterator i = jumps.begin(); i != jumps.end(); ++ i) {
            CEntity *e = (CEntity *)(*i);
            if (e->collide(player)) {
                player->jump();
                play_sound(GASP);
                score += presents * presents * 10 * MAX(1,player->getSpeed());
                presents = 0;
            }
        }
    }

    // remove old objects
    for(list<CEntity *>::iterator i = entities.begin(); i != entities.end(); ) {
        CEntity *e = (CEntity *)(*i);
        if (e->y() < player->y() - 200) {
            // remove entity from list
            delete (*i);
            // update iterator
            i = entities.erase(i);
        }
        else {
            // update iterator
            ++ i;
        }
    }
    for(list<CEntity *>::iterator i = tracks.begin(); i != tracks.end(); ) {
        CEntity *e = (CEntity *)(*i);
        if (e->y() < player->y() - 200) {
            // remove entity from list
            delete (*i);
            // update iterator
            i = tracks.erase(i);
        }
        else {
            // update iterator
            ++ i;
        }
    }
    for(list<CEntity *>::iterator i = gifts.begin(); i != gifts.end(); ) {
        CEntity *e = (CEntity *)(*i);
        if (e->y() < player->y() - 200) {
            // remove entity from list
            delete (*i);
            // update iterator
            i = gifts.erase(i);
        }
        else {
            // update iterator
            ++ i;
        }
    }
    for(list<CEntity *>::iterator i = jumps.begin(); i != jumps.end(); ) {
        CEntity *e = (CEntity *)(*i);
        if (e->y() < player->y() - 200) {
            // remove entity from list
            delete (*i);
            // update iterator
            i = jumps.erase(i);
        }
        else {
            // update iterator
            ++ i;
        }
    }


    // calculate camera
    if (game_state == GS_TITLE) {
        camera_target_x = 60;
        camera_target_y = -140;
        camera_zoom = 1;
        camera_x = camera_target_x;
        camera_y = camera_target_y;
    }
    else {
        camera_zoom = (MAX(1, 160 - player->z())) / 160.0;

        camera_target_x = player->x() - 320;
        camera_target_y = player->y() - 180;
    }

    double cdx = ABS(camera_x - camera_target_x);
    double cdy = ABS(camera_y - camera_target_y);
    if (camera_x < camera_target_x) camera_x += cdx/16.0;
    if (camera_x > camera_target_x) camera_x -= cdx/16.0;
    if (camera_y < camera_target_y) camera_y += cdy/2.0;
    if (camera_y > camera_target_y) camera_y -= cdy/2.0;
    // camera_x = camera_target_x;
    //camera_y = camera_target_y;

    return 0;
}


void textoutline_center(BITMAP *p_bmp, FONT *p_font, char *p_txt, int x, int y, int color, int outcolor) {
    int len = text_length(p_font, p_txt);
	textout_ex(p_bmp, p_font, p_txt, x-1 - len/2, y, outcolor, -1);
	textout_ex(p_bmp, p_font, p_txt, x - len/2, y+1, outcolor, -1);
	textout_ex(p_bmp, p_font, p_txt, x+1 - len/2, y, outcolor, -1);
	textout_ex(p_bmp, p_font, p_txt, x - len/2, y-1, outcolor, -1);
	textout_ex(p_bmp, p_font, p_txt, x - len/2, y, color, -1);
}



void draw_game() {
    int ox = camera_x;
    int oy = camera_y;

    clear_to_color(stretch_screen, 1);

    // draw all jumps
	for(list<CEntity *>::iterator i = jumps.begin(); i != jumps.end(); ++ i) {
	    CEntity *e = (CEntity *)(*i);
		e->render(stretch_screen, ox, oy, camera_zoom);
	}

    // draw all tracks
	for(list<CEntity *>::iterator i = tracks.begin(); i != tracks.end(); ++ i) {
	    CEntity *e = (CEntity *)(*i);
		e->render(stretch_screen, ox, oy, camera_zoom);
	}

    // draw all gifts
	for(list<CEntity *>::iterator i = gifts.begin(); i != gifts.end(); ++ i) {
	    CEntity *e = (CEntity *)(*i);
		e->render(stretch_screen, ox, oy, camera_zoom);
	}

    // sort entities in order
    entities.sort(ByYPos());

    // draw player?
    int drawPlayerInLoop = 1;
    if (player->z() > 20) drawPlayerInLoop = 0;

    // draw all entities
	for(list<CEntity *>::iterator i = entities.begin(); i != entities.end(); ++ i) {
	    CEntity *e = (CEntity *)(*i);
		if (e != player || drawPlayerInLoop) e->render(stretch_screen, ox, oy, camera_zoom);
	}
	if (!drawPlayerInLoop) player->render(stretch_screen, ox, oy, camera_zoom);

    // dead?
    if (player->isCrashed()) {
        textoutline_center(stretch_screen, (FONT *)gfx[TINYFONT].dat, hints[showHint], 320, 320, 11, 1);
        if (game_count & 16) textoutline_center(stretch_screen, (FONT *)gfx[TINYFONT].dat, "SPACE TO CONTINUE, ESC TO QUIT", 320, 340, 12, 9);
    }


    // stretch_screen to swap_screen
    stretch_blit(stretch_screen, swap_screen, 160 * camera_zoom, 120 * camera_zoom, 640 - 320 * camera_zoom, 480 - 240 * camera_zoom, 0, 0, 640, 480);

    // draw hud
    // woosh meter
    int meterLen = player->getMaxSpeed() * 10 - 10;
    int stickLen = player->getSpeed() * 10;
    BITMAP *tmpBMP = create_bitmap(128, meterLen + 128);
    clear_to_color(tmpBMP, 0);
    // woosh stick
    if (stickLen) {
        stickLen += rand()%2;
        stretch_sprite(tmpBMP, (BITMAP *)gfx[WOOSH].dat, 27, meterLen + 17 - stickLen, 7, stickLen);
    }
    // woosh meter
    draw_sprite(tmpBMP, (BITMAP *)gfx[METER3].dat, 25, 0);
    stretch_sprite(tmpBMP, (BITMAP *)gfx[METER2].dat, 25, 6, 11, meterLen);
    draw_sprite(tmpBMP, (BITMAP *)gfx[METER1].dat, 0, meterLen + 6);

    stretch_sprite(swap_screen, tmpBMP, 550, 680 - tmpBMP->h * 2, tmpBMP->w * 2, tmpBMP->h * 2);
    destroy_bitmap(tmpBMP);

    // scores etc
    tmpBMP = create_bitmap(320, 20);
    clear_to_color(tmpBMP, 0);
    draw_sprite(tmpBMP, (BITMAP *)gfx[HUD_GIFT].dat, 4, 4);
	textprintf_ex(tmpBMP, (FONT *)gfx[TINYFONT].dat, 22, 5, 9, -1, "x%d", presents);
	textprintf_right_ex(tmpBMP, (FONT *)gfx[TINYFONT].dat, 170, 5, 9, -1, "HI:%6d", hiscore);
	textprintf_right_ex(tmpBMP, (FONT *)gfx[TINYFONT].dat, 315, 5, 9, -1, "SCORE:%6d", score);

    stretch_sprite(swap_screen, tmpBMP, 0, 0, 640, 40);
    destroy_bitmap(tmpBMP);


    /*
    // debug stuff
	textprintf_ex(swap_screen, font, 1, 101, 20, 1, "%3d %3d", lps, fps);
	textprintf_ex(swap_screen, font, 1, 110, 20, 1, "%3.3f (%3.3f)", player->z(), camera_zoom);
	textprintf_ex(swap_screen, font, 1, 120, 20, 1, "%d %d %d %d", entities.size(), jumps.size(), gifts.size(), tracks.size());
	textprintf_ex(swap_screen, font, 1, 150, 20, 1, "%d %d", presents, score);

	textprintf_ex(swap_screen, font, 1, 180, 20, 1, "%5.1f", yPos);
	*/

    // blit to screen
	acquire_screen();
	blit(swap_screen, screen, 0, 0, 0, 0, 640, 480);
	release_screen();

}





void end_game() {
	log("\nEnding new game.");

	// remove all objects
	for(list<CEntity *>::iterator i = entities.begin(); i != entities.end(); ++ i) {
	    CEntity *e = (CEntity *)(*i);
		delete e;
	}
	entities.clear();
	for(list<CEntity *>::iterator i = jumps.begin(); i != jumps.end(); ++ i) {
	    CEntity *e = (CEntity *)(*i);
		delete e;
	}
	jumps.clear();
	for(list<CEntity *>::iterator i = gifts.begin(); i != gifts.end(); ++ i) {
	    CEntity *e = (CEntity *)(*i);
		delete e;
	}
	gifts.clear();
	for(list<CEntity *>::iterator i = tracks.begin(); i != tracks.end(); ++ i) {
	    CEntity *e = (CEntity *)(*i);
		delete e;
	}
	tracks.clear();

}






void show_credits() {
}



void run() {
	int game_is_on = 1;
	int draw = 1;
	int fade = 0;

	game_count = 0;
	while(game_is_on) {
		// do logic
		while(cycle_count > 0) {
			logic_count ++;

			if (update_game() < 0) {
			    game_is_on = 0;
            }


			if (key[KEY_F1]) {
				int lc = logic_count;
				int cc = cycle_count;
				int gc = game_count;
				take_screenshot(swap_screen);
				while(key[KEY_F1]);
				logic_count = lc;
				game_count = gc;
				cycle_count = cc;
			}

			if (key[KEY_TAB]) {
			    game_is_on = 0;
			}

			if (game_state == GS_QUIT) {
                game_is_on = 0;
			}

			draw = 1;
			cycle_count --;
		}
		// draw
		if (draw) {
			frame_count ++;
			draw_game();
			draw = 0;
			if (fade) {
				fade_in((RGB *)gfx[0].dat, 16);
				fade = 0;
			}
		}
	}
}



int main() {
	if (!init_game()) {
		allegro_message("%s:\nFailed to init game.", GAME_NAME);
		uninit_game();
		return -1;
	}

	clear_keybuf();

    while(game_state != GS_QUIT) {
        start_game();
        run();
        end_game();
    }
	show_credits();

	uninit_game();
	return 0;
}
END_OF_MAIN()

