
#include <math.h>
#include "CPlayer.h"
#include "main.h"
#include "../data/data_gfx.h"
#include "../data/data_sfx.h"


CPlayer :: CPlayer(EType p_type, DATAFILE *p_gfx, int x, int y) :  CEntity(p_type, p_gfx, x, y){

    m_dz = 0;
    m_dx = m_dy = 0;
    m_speed = 0;
    m_maxSpeed = 1.5;
    m_state = 0;
    m_angle = 0;
    m_dudeOffset = 0;
    m_jumpCount = 0;

    m_hat = (BITMAP *)p_gfx[HAT].dat;
    m_hatend = (BITMAP *)p_gfx[HATEND].dat;
    m_crashDude = (BITMAP *)p_gfx[CRASH_DUDE].dat;
    m_crashToboggan = (BITMAP *)p_gfx[CRASH_TOBOGGAN].dat;
}


CPlayer:: ~CPlayer() {
}


void CPlayer :: update(int handleInput) {
    m_dx = m_dy = 0;
    if (!handleInput) return;

    if (m_state == 2) {
        m_dudeOffset += m_speed;
        m_speed *= 0.95;

        m_dz -= 0.02;
        m_zPos += m_dz;
        if (m_zPos < 0) {
            m_dz = 0;
            m_zPos = 0;
        }
    }
    else {
        // turning
        if (key[KEY_LEFT]) m_angle += (m_state == 0 ? 0.05 : 0.005);
        if (key[KEY_RIGHT]) m_angle -= (m_state == 0 ? 0.05 : 0.005);
        m_angle *= (m_state == 0 ? 0.95 : 0.995);

        if (m_state == 0) {
            double speedIncrease = m_maxSpeed / 400; // 0.005 at the start
            m_speed = MIN(m_speed + speedIncrease, m_maxSpeed);
            if ((key[KEY_LEFT] || key[KEY_RIGHT]) && m_state == 0) m_speed *= 0.997;
        }

        m_dx = m_speed * cos(m_angle + M_PI/2);
        m_dy = m_speed * sin(m_angle + M_PI/2);

        m_xPos += m_dx;
        m_yPos += m_dy;


        if (m_state == 1) {
            m_zPos += m_dz;
            m_dz -= 0.02;
            if (m_zPos < 0) {
                m_zPos = 0;
                m_state = 0;
                if (ABS(m_dz) < 0.5) {
                    m_dz = 0;
                }
                else  {
                    m_maxSpeed = MIN(1 + m_jumpCount * 0.5, 8);
                    m_dz = -m_dz * 0.5;
                    m_speed = MIN(MAX(0, m_speed - ABS(m_angle)), m_maxSpeed);
                    m_state = 1;

                }
            }
        }
    }
}


void CPlayer :: pickup() {
    m_maxSpeed = MIN(m_maxSpeed + 0.3, 8);
}

void CPlayer :: crash(EType e) {
    m_state = 2;
    m_zPos = 0;
    m_dz = 0;
    if (e == eTree) main_play_sound(CRASH_TREE);
    if (e == eStone) main_play_sound(CRASH_STONE);
    if (e == eStub) main_play_sound(CRASH_STUB);
}

void CPlayer :: jump() {
    m_dz = m_speed / 2;
    m_state = 1;
    m_jumpCount ++;
}

void CPlayer :: render(BITMAP *p_bmp, int p_offsetX, int p_offsetY, double p_zoom) {
    int x = (int)(m_xPos - p_offsetX);
    int y = (int)(m_yPos - p_offsetY);

    if (m_state == 2) {
        draw_sprite(p_bmp, m_crashToboggan, x - m_cx - 6, y - m_bmp->h);
        draw_sprite(p_bmp, m_crashDude, x - m_cx - 4, y - m_bmp->h - m_zPos + m_dudeOffset + 8 - m_zPos);
    }
    else {
        rotate_sprite(p_bmp, m_bmp, x - m_cx, y - m_bmp->h - m_zPos, ftofix(m_angle * 32));

        int hatlength = 4 + 4 * m_speed;
        if (m_speed > 2) hatlength += rand()%3 - 1;
        int xshift = 5 * m_angle;
        int yshift = 2 * ABS(m_angle);
        stretch_sprite(p_bmp, m_hat, x + xshift + 5 - m_cx, y + yshift - hatlength + 6 - m_bmp->h - m_zPos, m_hat->w, hatlength);
        draw_sprite(p_bmp, m_hatend, x + xshift + 6 - m_cx, y + yshift - hatlength  + 3 - m_bmp->h - m_zPos);

        //rotate_scaled_sprite(p_bmp, m_bmp, x - m_cx, y - m_bmp->h - m_zPos, ftofix(m_angle * 32), itofix(2));

        //textprintf_ex(p_bmp, font, x, y, 20, -1, "%3.3f", m_speed);
    }
}


