
#ifndef _CENTITY_H_
#define _CENTITY_H_

#include <allegro.h>


class CEntity {
	public:
		enum EType {
			ePlayer,
			eShadow,
			eGift,
			eTree,
			eStone,
			eStub,
			eJump,
			eTrack,
			eLogo
		};

		CEntity(EType p_type, DATAFILE *p_gfx, int x, int y);
		virtual ~CEntity();

		EType getType() { return m_type; }

		void setPosition(double p_x, double p_y);
		void move(double p_dx, double p_dy);
		void changeHeight(double p_dz);

		int x() { return (int)m_xPos; }
		int y() { return (int)m_yPos; }
		double z() { return m_zPos; }
		int bbx() { return m_bbx; }
		int bby() { return m_bby; }
		int bbw() { return m_bbw; }
		int bbh() { return m_bbh; }

		virtual void render(BITMAP *p_bmp, int p_offsetX, int p_offsetY, double p_zoom);
		virtual void update();
		int collide(CEntity *e);

	protected:
		EType m_type;

		// position
		double m_xPos, m_yPos, m_zPos;
		int m_cx, m_cy;
		int m_bbx, m_bby, m_bbw, m_bbh;

        BITMAP *m_bmp;



};



class ByYPos {
   public:
      bool operator()(CEntity *a, CEntity *b) {
		  return a->y() < b->y();
		}
};


#endif

