/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#ifndef _VEHICLE_H_
#define _VEHICLE_H_


#include "allegro.h"
#include "main.h"
#include "unit.h"
#include "projectile.h"

#define MAX_PASSENGERS	64



class vehicle : public unit {

public:
	int		max_passengers;
	int		num_passengers;
	int		passenger[MAX_PASSENGERS];
	bool	armed;
	int		turret_turn_speed;
	int		turret_image;
	fixed	turret_angle;
	fixed	turret_target_angle;
	int		tx, ty, tw, th;
	bool	downed;

	// heli stuff
	int		heli_altitude;		// 0 - 100;


	vehicle(int type);
	~vehicle();
	bool add_object(object *o);
	void empty(mission *m);
	void destroy(mission *m);
	void empty(mission *m, int p);
	void props_dialog(DATAFILE *df);
	void to_string(char *str);
	void set_turret_stats(DATAFILE *df);
	class projectile *fire(int type);
	void save(PACKFILE *fp);
	void load(PACKFILE *fp);
	void draw(BITMAP *bmp, DATAFILE *gfx, fixed ca, bool shadow);
	void set_from_file(char* fname);
	bool is_passenger(int id);
};


#endif

