/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#ifndef _UNIT_H_
#define _UNIT_H_


#include "allegro.h"
#include "main.h"
#include "object.h"

#define AI_IDLE			1
#define AI_HUNT			2
#define AI_ATTACK		3
#define AI_TRAVEL		4

#define MAX_WAYPOINTS	128
#define WP_RESTART		1
#define WP_GOAL			2
#define WP_REVERSE		3
#define WP_UNLOAD		4

typedef struct {
	int x;
	int y;
	int type;
	bool active;
} waypoint;


class unit : public object {

public:
	fixed	normal_speed;
	fixed	panic_speed;
	byte	max_turn_angle;
	int		mag_size;
	int		ammo_count;
	int		frame_count;
	int		AI_mode;
	int		fire_rate;
	int		reload_rate;
	int		fire_sound;
	int		reload_sound;

	int		sight_range;
	int		sight_angle;
	int		fire_range;
	bool	may_fire;
	int		angle_counter;
	bool	jumping;		// soldier only
	int     burning;		// soldier only

	int		event;


	object	*current_target;
	
	waypoint wp[MAX_WAYPOINTS];
	int		 wp_dir;
	int		 wp_pos;

	unit();
	~unit();

	void evaluate_AI();
	void act_on_object(object *o);
	void update_movement();
	void reset_wp();
	virtual class projectile *fire(int type) = 0;
	virtual void set_from_file(char* fname) = 0;

	virtual void save(PACKFILE *fp) = 0;
	virtual void load(PACKFILE *fp) = 0;
	virtual void draw(BITMAP *bmp, DATAFILE *gfx, fixed ca, bool shadow) = 0;
};


#endif