/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#ifndef _SUB_MISSION_H_
#define _SUB_MISSION_H_

#include "allegro.h"
#include "main.h"
#include "sub_mission.h"

#define SM_DESTROY		1
#define SM_DEFEND		2
#define SM_ESCORT		3
#define SM_TRANSPORT	4
#define SM_STRAFE		5
#define SM_GOTO		6

#define E_RESTART	1001
#define E_ADVANCE	1000

#define MISSION_SUCCESS	1
#define MISSION_FAIL	2

class sub_mission {

public:
	char name[64];				//name of sub mission
	char text[1024];			//more detail

	int event_id;				//trigger on this event id
	bool triggered;				//true when triggered
	bool completed;				//true when the mission is completed
	bool failed;

	bool primary;				//true if mission is primary
	int type;					//type of mission (escort, defend, destroy, rescue)
	int param[4];				//param to use for anything (mostly end zones)
	int target[MAX_TARGETS];	//array of target ids
	int num_targets;
	int start_time;
	int end_time;

	int success_event;			//event to trigger on mission success
	int fail_event;				//event to trigger on mission failure

	char success_text[1024];	// text to show on success
	char fail_text[1024];		// text to show on failure

	sub_mission();
	~sub_mission();
	void to_string(char *str);
	void props_dialog();
	void save(PACKFILE *fp);
	void load(PACKFILE *fp);
	bool add_target(int id);
};


#endif

