/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#include <string.h>

#include "allegro.h"
#include "main.h"
#include "dime.h"
#include "sub_mission.h"


sub_mission::sub_mission() {
	strcpy(name, "new");
	strcpy(text, "bla bla");

	event_id = 0;				//trigger on this event id
	triggered = FALSE;				//true when triggered
	completed = FALSE;				//true when the mission is completed
	failed = FALSE;

	primary = TRUE;				//true if mission is primary
	type = SM_DESTROY;			//type of mission (escort, defend, destroy, rescue)
	for(int i=0;i<MAX_TARGETS;i++)
		target[MAX_TARGETS] = -1;	//array of target ids

	success_event = 0;			//event to trigger on mission success
	fail_event = 0;				//event to trigger on mission failure

	strcpy(success_text, "Congrats!");	// text to show on success
	strcpy(fail_text, "Sucker!");	// text to show on failure

}
sub_mission::~sub_mission() {}

void sub_mission::props_dialog() {
	dialogf("Sub Mission Properties" , ALIGN_CENTER, ALIGN_CENTER, 300,
		"Name:%string[64]"
		"Start text:%string[1024]"
		"Primary mission:%bool[]"
		"Type:%int[0,9]"
		"          1=destroy, 2=defend, 3=escort, 4=transport, 5=strafe, 6=goto%nothing[]"
		"move to:%int[-1024,1024]"
		"do it in secs:%int[-1024,1024]"
		"how many must survive/die:%int[-1024,1024]"
		//"Parameter 4:%int[-1024,1024]"
		"Triggers %line[]"
		"Trigger mission on event id:%int[0,1023]"
		"Event id on success:%int[0,1023]"
		"Event id on fail:%int[0,1023]"
		"          1000=mission complete, 1001=snafu%nothing[]"
		"Completion:%line[]"
		"Success Text:%string[1024]"
		"Fail Text:%string[1024]",
		name, text, &primary, &type, &param[0], &param[1], &param[2], /*&param[3],*/ &event_id, &success_event, &fail_event, success_text, fail_text);
}

void sub_mission::save(PACKFILE *fp) {
	pack_fwrite(name, sizeof(name), fp);
	pack_fwrite(text, sizeof(text), fp);
	pack_fwrite(&event_id, sizeof(event_id), fp);
	pack_fwrite(&primary, sizeof(primary), fp);
	pack_fwrite(&type, sizeof(type), fp);
	pack_fwrite(param, sizeof(param), fp);
	for(int i=0;i<MAX_TARGETS;i++)
		pack_fwrite(&target[i], sizeof(target[i]), fp);
	pack_fwrite(&success_event, sizeof(success_event), fp);
	pack_fwrite(&fail_event, sizeof(fail_event), fp);
	pack_fwrite(success_text, sizeof(text), fp);
	pack_fwrite(fail_text, sizeof(text), fp);
}

void sub_mission::load(PACKFILE *fp) {
	int i;

	pack_fread(name, sizeof(name), fp);
	pack_fread(text, sizeof(text), fp);
	pack_fread(&event_id, sizeof(event_id), fp);
	pack_fread(&primary, sizeof(primary), fp);
	pack_fread(&type, sizeof(type), fp);
	pack_fread(&param, sizeof(param), fp);
	for(i=0;i<MAX_TARGETS;i++)
		pack_fread(&target[i], sizeof(target[i]), fp);
	pack_fread(&success_event, sizeof(success_event), fp);
	pack_fread(&fail_event, sizeof(fail_event), fp);
	pack_fread(success_text, sizeof(text), fp);
	pack_fread(fail_text, sizeof(text), fp);

	num_targets = 0;
	for(i=0;i<MAX_TARGETS;i++) 
		if (target[i] != -1) num_targets ++;
}

bool sub_mission::add_target(int id) {
	int i=0;
	while(target[i] != -1 && i<MAX_TARGETS) i++;
	if (i == MAX_TARGETS) return FALSE;
	target[i] = id;
	return TRUE;
}