/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#include "allegro.h"
#include "smoke.h"


smoke::	smoke(COLOR_MAP *cm, int xp, int yp, int sc, int cst, int sz, double sst) {
	cmap = cm;
	x = xp;
	y = yp;
	cstep = cst;
	size = sz;
	sstep = sst;
	life = 1;
	col = sc;
	sx = sy = 0;
}

smoke::~smoke() {
	;
};

void smoke::draw(BITMAP *bmp, DATAFILE *gfx, fixed ca, bool shadow) {
	color_map = cmap;
	int s1, s2;
	if (!cstep && size > 43) {
		s1 = MAX(1, 80 - size);
		s2 = MAX(1, 80 - size * 0.8);
	}
	else {
		s1 = size;
		s2 = size * 0.8;
	}
	circlefill(bmp, render_x, render_y, s1, col);
	circlefill(bmp, render_x, render_y, s2, col);
}

void smoke::update() {
	x += sx;
	y += sy;
	col += cstep;
	if (cstep == 0 && size > 96) life = 0;
	if (col > 255) {
		life = 0;
		col = 255;
	}
	if (life) {
		size += sstep;
	}
}

void smoke::set_speed(double xv, double yv) {
	sx = xv;
	sy = yv;
}