/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#ifndef _MISSION_H_
#define _MISSION_H_

#include "allegro.h"
#include "main.h"
#include "object.h"
#include "sub_mission.h"
#include "sector.h"
#include "debris.h"

#define MAX_PROJECTILES		1024
#define MAX_SMOKE			 512
#define MAX_NOISE			 256
#define NOISE_W				2048
#define MAX_ZONES			  16
#define MAX_DEBRIS			  64

typedef struct {
	int x1, y1, x2, y2;
	int active;
} Tzone;
typedef struct {
	int cx, cy;
} Tzone2;

class mission {

public:
	char name[64];			// mission name
	char text[1024];		// introduction text
	char gfx_file[1024];

	DATAFILE *gfx;
	DATAFILE *gen;

	class object *obj[MAX_OBJECTS];				// pointers to all objects
	class scenery *noise[MAX_NOISE];			// pointers to all noise-objects
	class projectile *proj[MAX_PROJECTILES];	// pointers to all projectile-objects
	class smoke *smk[MAX_SMOKE];				// pointers to all smoke-objects
	class debris *dbrs[MAX_DEBRIS];				// pointers to all debris-objects
	class sector_space *space;					// space, the final frontier...
	Tzone zone[MAX_ZONES];						// zones
	Tzone2 zone2[MAX_ZONES];						// zones

	sub_mission *sub[MAX_SUB_MISSIONS];	// pointers to all sub missions
	int event[MAX_EVENTS];				// event triggers
	int max_object;
	bool password;
	int micon;
	Toptions *o;

	mission(DATAFILE *df);
	~mission();

	bool add_object(object *o, bool any);
	bool add_projectile(projectile *p);
	bool add_smoke(smoke *s);
	bool add_debris(debris *d);
	bool add_zone(int x1, int y1, int x2, int y2);
	int  get_zone(int x, int y, bool top_right);
	void draw_zone(BITMAP *bmp, Tzone *z, int cx, int cy, int col, int num);
	void set_object(object *o, int i);
	void set_obj_image(int o_id, int im);
	bool add_sub_mission(sub_mission *s);
	void render(BITMAP *bmp, double cx, double cy, fixed angle);		// camera position
	void save(char *file_name);
	bool load(char *file_name);
	void to_string(char *str);
	void random_noise(int first, int last);
};


#endif