/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#ifndef _MENU_H_
#define _MENU_H_

#include "allegro.h"
#include "main.h"
#include "control.h"

// possible end selections	(returnValue)
#define IDM_NEWGAME				101
#define IDM_LOADGAME			102
#define IDM_OPTIONS				103
#define IDM_INSTRUCTIONS		104
#define IDM_HIGHSCORES			105
#define IDM_CREDITS				106
#define IDM_EXIT				107
#define IDM_VIDEO_OPTIONS		108
#define IDM_CONTROLS			109

#define IDM_INC_DETAIL			201
#define IDM_DEC_DETAIL			202
#define IDM_INC_SIZE			203
#define IDM_DEC_SIZE			204
#define IDM_INC_SOUND			205
#define IDM_DEC_SOUND			206
#define IDM_MUTE_SOUND			207
#define IDM_INC_MUSIC			208
#define IDM_DEC_MUSIC			209
#define IDM_MUTE_MUSIC			210
#define IDM_BACK				211
#define IDM_INC_FRAMES			212
#define IDM_DEC_FRAMES			213
#define IDM_TOGGLE_SHADOWS		214
#define IDM_TOGGLE_SMOKE		215
#define IDM_TOGGLE_CONTROL		216
#define IDM_TOGGLE_ANALOG		217
#define IDM_SET_KEYS			218
#define IDM_RESET_KEYS			219

#define IDM_RESUME				301
#define IDM_HELP				302
#define IDM_END					303

#define IDM_D_EASY				401
#define IDM_D_NORMAL			402
#define IDM_D_HARD				403


// flags for each post
#define MF_SELECTED				0x0001
#define MF_DRAW_SIZE			0x0002
#define MF_DRAW_DETAIL			0x0004
#define MF_DRAW_SOUND			0x0020
#define MF_DRAW_MUSIC			0x0040
#define MF_DRAW_FRAMES			0x0080
#define MF_LAST					0x0100
#define MF_DRAW_SHADOWS			0x0200
#define MF_DRAW_SMOKE			0x0400
#define MF_DRAW_CONTROL			0x0800
#define MF_DRAW_ANALOG			0x1000


typedef struct {
	char	caption[128];
	int		return_select;
	int		return_left;
	int		return_right;
	int		flags;
} Tmenu;


void init_menu(DATAFILE *dat, Toptions *o);
void reset_menu(Tmenu *m, int selPos);
int update_menu(BITMAP *bmp, Tmenu *m, control *ctrl, int x, int y, DATAFILE *snd);


#endif