/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#include <stdio.h>

#include "allegro.h"
#include "main.h"
#include "menu.h"
#include "control.h"

// datafiles headers
#include "../data/general.h"

BITMAP *menu_bmp;
bool initialized = FALSE;
DATAFILE *data;
Toptions *opt;

// inits all menu stuff
void init_menu(DATAFILE *dat, Toptions *o) {
	if (initialized) {
		my_alert("init_menu", "Already initialized!");
		return;
	}

	data = dat;
	menu_bmp = create_bitmap(320, 200);
	opt = o;
}

// builds the menu string into *dest
void build_menu_string(Tmenu *m, char *dest) {
	if (m->flags & MF_DRAW_DETAIL) {
		sprintf(dest, "%s: %s", m->caption, (opt->detail_level == DETAIL_HIGH ? "MUCH" : (opt->detail_level == DETAIL_MED ? "SOME" : "NONE")));
		return;
	}
	if (m->flags & MF_DRAW_SMOKE) {
		sprintf(dest, "%s: %s", m->caption, (opt->smoke ? "ON" : "OFF"));
		return;
	}
	if (m->flags & MF_DRAW_SHADOWS) {
		sprintf(dest, "%s: %s", m->caption, (opt->shadow ? "ON" : "OFF"));
		return;
	}
	if (m->flags & MF_DRAW_CONTROL) {
		sprintf(dest, "%s: %s", m->caption, (opt->use_joy ? "JOYSTICK" : "KEYBOARD"));
		return;
	}
	if (m->flags & MF_DRAW_ANALOG) {
		if (opt->use_joy) {
			sprintf(dest, "%s: %s", m->caption, (opt->analog_joy ? (opt->analog_joy == 2 ? "ANALOGUE 2" : "ANALOGUE 3") : "DIGITAL"));
		}
		else
			sprintf(dest, "%s: n/a", m->caption);
		return;
	}
	if (m->flags & MF_DRAW_SOUND) {
		if (!opt->sound_mute) sprintf(dest, "%s: ", m->caption);
		else sprintf(dest, "%s: %s", m->caption, "MUTE");
		return;
	}
	if (m->flags & MF_DRAW_MUSIC) {
		if (!opt->music_mute) sprintf(dest, "%s: ", m->caption);
		else sprintf(dest, "%s: %s", m->caption, "MUTE");
		return;
	}
	if (m->flags & MF_DRAW_FRAMES) {
		sprintf(dest, "%s: %d", m->caption, 50/opt->frame_step);
		return;
	}

	sprintf(dest, "%s", m->caption);
}

void draw_bar(BITMAP *bmp, int x, int y, int value, int step) {
	int n = value/step;
	int w = 6, h = 14, s = 8;
	for(int i=0;i<n;i++) {
		rect(bmp, x+i*s, y, x+i*s+w, y+h, 180);
		rectfill(bmp, x+i*s+1, y+1, x+i*s+w-1, y+h-1, 150);
		line(bmp, x+i*s, y, x+i*s+w, y, 120);
		line(bmp, x+i*s, y+1, x+i*s, y+h, 120);
	}
}

// draws a menu on specific bitmap at specified coordinates
void draw_menu(BITMAP *bmp, Tmenu *m, int x, int y) {
	int pos = -1;
	char str[256];
	int len;
	int rad;

	//clear(menu_bmp);

	do {
		pos++;
		build_menu_string(&m[pos], str);
		len = text_length((FONT*)data[FONT_MENU].dat, str);
		rad = len  + rand()%5;

		if (m[pos].flags & MF_SELECTED) 
			for(int i=0;i<16;i++) 
				ellipsefill(bmp, x+25+len/2, y+pos*25+17, rad/2+21-(i), 7-(i>>2), 250-rand()%50);

		textprintf(bmp, (FONT*)data[FONT_MENU].dat, x+25+2, y+pos*25+2, 15, "%s", str);
		textprintf(bmp, (FONT*)data[FONT_MENU].dat, x+25  , y+pos*25  , -1, "%s", str);

		if (m[pos].flags & MF_DRAW_SOUND && !opt->sound_mute)
			draw_bar(bmp, x+170, y+pos*25+10, opt->sound_volume, 25);
		if (m[pos].flags & MF_DRAW_MUSIC && !opt->music_mute)
			draw_bar(bmp, x+170, y+pos*25+10, opt->music_volume, 25);

	} while(!(m[pos].flags & MF_LAST));

	//masked_blit(menu_bmp, bmp, 0, 0, x, y, 320, 200);
}

// reset a menu
// sel_pos is the the menu pos to be selected
void reset_menu(Tmenu *m, int sel_pos) {
	int i=-1;

	// unselect all
	do {
		i++;
		m[i].flags &= ~MF_SELECTED;
	} while(!(m[i].flags & MF_LAST));

	// set first one to selected
	m[sel_pos].flags |= MF_SELECTED;
}

// handle a menu, returns selected slot
int update_menu(BITMAP *bmp, Tmenu *m, control *ctrl, int x, int y, DATAFILE *snd) {
	int num_posts, old_pos, pos=0;
	int return_value = 0;

	// find current pos and number of posts
	num_posts = -1; 
	do {
		num_posts++;
		if (m[num_posts].flags & MF_SELECTED) pos = num_posts;
	} while(!(m[num_posts].flags & MF_LAST));

	// draw the menu
	draw_menu(bmp, m, x, y);
	
	if (ctrl != NULL) {
		// check controls for action
		ctrl->poll_controls();
		old_pos = pos;
		if (ctrl->is_up() && pos) pos--; 
		if (ctrl->is_down() && pos<num_posts) pos++; 
		if (pos != old_pos) {
			m[old_pos].flags &= ~MF_SELECTED;
			m[pos].flags |= MF_SELECTED;
			play_sample((SAMPLE *)snd[11].dat, 200, 128, 1000, 0);
		}
		if (ctrl->is_menu_yes() || ctrl->is_fire1()) {
			return_value = m[pos].return_select;
			play_sample((SAMPLE *)snd[11].dat, 200, 128, 1000, 0);
		}
		if (ctrl->is_left()) return_value = m[pos].return_left;
		if (ctrl->is_right()) return_value = m[pos].return_right;
	}
		
	return return_value;
}
	

