/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#ifndef _CONTROL_H_
#define _CONTROL_H_

#include "main.h"

#define	K_LEFT		0x0001
#define	K_RIGHT		0x0002
#define K_UP		0x0004
#define K_DOWN		0x0008
#define	K_LAND		0x0010
#define	K_FIRE1		0x0020
#define	K_FIRE2		0x0040
#define	K_TOGGLE	0x0080
#define K_STRAFE	0x0100
#define K_STRAFE_L	0x0200
#define K_STRAFE_R	0x0400
#define K_MENU_YES  0x0800

class control {
public:
	control(bool joy);
	~control();
	void set_controls(int up, int down, int left, int right, int strafe, int fire1, int fire2, int toggle, int land, int sl, int sr);
	void poll_controls();
	bool is_up();
	bool is_down();
	bool is_left();
	bool is_right();
	bool is_strafe();
	bool is_strafe_r();
	bool is_strafe_l();
	bool is_fire1();
	bool is_menu_yes();
	bool is_fire2();
	bool is_toggle();
	bool is_land();
	bool is_any();
	int  get_axis(int a);
	unsigned int get_flags();
	void clear_flags();

	bool use_joy;
	bool analog_joy;

	int key_left,				// actual keys
		key_right,
		key_up,
		key_down,
		key_strafe,
		key_strafe_l,
		key_strafe_r,
		key_fire1,
		key_fire2,
		key_toggle,
		key_land,
		key_menu_yes;
	int axis[6];

private:
	unsigned int flags;					// bit field w/ info on which keys that are down
};


#endif
