/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#include "allegro.h"
#include "control.h"

// constructor
control::control(bool joy) {
	this->set_controls( KEY_UP,
						KEY_DOWN,
						KEY_LEFT,
						KEY_RIGHT,
						KEY_ALT,
						KEY_LCONTROL,
						KEY_LSHIFT,
						KEY_Z,
						KEY_SPACE,
						KEY_COMMA,
						KEY_STOP);
	key_menu_yes = KEY_ENTER;
	use_joy = joy;
	flags = 0;
}

// destructor
control::~control() {}

// sets the desired keys for the control unit
void control::set_controls(int up, int down, int left, int right, int strafe, int fire1, int fire2, int toggle, int land, int sl, int sr) {
	key_up     = up;
	key_down   = down;
	key_left   = left;
	key_right  = right;
	key_strafe = strafe;
	key_strafe_l = sl;
	key_strafe_r = sr;
	key_fire1  = fire1;
	key_fire2  = fire2;
	key_toggle = toggle;
	key_land   = land;
}

// updates the control unit
void control::poll_controls() {
	poll_joystick();

	flags = 0;

	if (use_joy) {
		if (joy[0].stick[0].axis[1].d1) flags |= K_UP;
		if (joy[0].stick[0].axis[1].d2) flags |= K_DOWN;
		if (joy[0].stick[0].axis[0].d1) flags |= K_LEFT;
		if (joy[0].stick[0].axis[0].d2) flags |= K_RIGHT;
		if (joy[0].button[0].b) flags |= K_FIRE1;
		if (joy[0].button[1].b) flags |= K_FIRE2;
		if (joy[0].button[3].b) flags |= K_TOGGLE;
		if (joy[0].button[4].b) flags |= K_STRAFE_L;
		if (joy[0].button[5].b) flags |= K_STRAFE_R;
		if (joy[0].button[2].b) flags |= K_LAND;
		if (joy[0].button[0].b) flags |= K_MENU_YES;
	
		if (analog_joy)
			for(int a=0;a<joy[0].stick[0].num_axis;a++)
				axis[a] = joy[0].stick[0].axis[a].pos;
	
	}

	if (key[key_up]) flags |= K_UP;
	if (key[key_down]) flags |= K_DOWN;
	if (key[key_left]) flags |= K_LEFT;
	if (key[key_right]) flags |= K_RIGHT;
	if (key[key_fire1]) flags |= K_FIRE1;
	if (key[key_fire2]) flags |= K_FIRE2;
	if (key[key_toggle]) flags |= K_TOGGLE;
	if (key[key_strafe]) flags |= K_STRAFE;
	if (key[key_strafe_l]) flags |= K_STRAFE_L;
	if (key[key_strafe_r]) flags |= K_STRAFE_R;
	if (key[key_land]) flags |= K_LAND;
	if (key[key_menu_yes]) flags |= K_MENU_YES;

}

unsigned int control::get_flags() { return flags; }
void control::clear_flags() { flags = 0; }

bool control::is_up()       { return (flags & K_UP ? TRUE : FALSE); }
bool control::is_down()     { return (flags & K_DOWN ? TRUE : FALSE); }
bool control::is_left()     { return (flags & K_LEFT ? TRUE : FALSE); }
bool control::is_right()    { return (flags & K_RIGHT ? TRUE : FALSE); }
bool control::is_strafe()   { return (flags & K_STRAFE ? TRUE : FALSE); }
bool control::is_strafe_l() { return (flags & K_STRAFE_L ? TRUE : FALSE); }
bool control::is_strafe_r() { return (flags & K_STRAFE_R ? TRUE : FALSE); }
bool control::is_fire1()    { return (flags & K_FIRE1 ? TRUE : FALSE); }
bool control::is_fire2()    { return (flags & K_FIRE2 ? TRUE : FALSE); }
bool control::is_toggle()   { return (flags & K_TOGGLE ? TRUE : FALSE); }
bool control::is_land()     { return (flags & K_LAND ? TRUE : FALSE); }
bool control::is_menu_yes() { return (flags & K_MENU_YES ? TRUE : FALSE); }
bool control::is_any()      { return (flags ? TRUE : FALSE); }
int control::get_axis(int a){ return axis[a]; }

