/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#include <stdio.h>

#include "allegro.h"
#include "main.h"
#include "object.h"
#include "scenery.h"
#include "dime.h"
#include "config.h"


// constructor
// sets some silly default values
scenery :: scenery() {
	type = OBJ_SCENERY;
	sprintf(name, "scenery[%d]", rand());
	altitude = GL_GROUND_FLAT_SCENERY;

	x = y = w = h = 0;
	smoking = 0;
	exist = TRUE;
	target = FALSE;
	detail_level = DETAIL_MED;
	angle = 0;
	base_image = 3;
	anim_pos = 0;
	anim_frames = 0;
	anim_rate = 0;
	anim_count = 0;
	armour = 200;
	shadow_dist	= 10;
	max_armour = armour;
	essential = FALSE;

	
	material = MAT_WOOD;
	size = SCEN_MED;
}

// destructor
scenery :: ~scenery() {
}

// copies data about object to str
void scenery::to_string(char *str) {
	sprintf(str, "%s", name);
}

// shows a property dialog
void scenery::props_dialog(DATAFILE *df) {
	dialogf("Scenery Properties" , ALIGN_CENTER, ALIGN_CENTER, 300,
		"Name:%string[32]",
		name);
}

void scenery::save(PACKFILE *fp) {
	pack_fwrite(name, sizeof(name), fp);
	pack_fwrite(&index, sizeof(index), fp);
	pack_fwrite(&inside, sizeof(inside), fp);
	pack_fwrite(&type, sizeof(type), fp);
	pack_fwrite(&altitude, sizeof(altitude), fp);
	pack_fwrite(&x, sizeof(x), fp);
	pack_fwrite(&y, sizeof(y), fp);
	pack_fwrite(&w, sizeof(w), fp);
	pack_fwrite(&h, sizeof(h), fp);
	pack_fwrite(&exist, sizeof(exist), fp);
	pack_fwrite(&target, sizeof(target), fp);
	pack_fwrite(&detail_level, sizeof(detail_level), fp);
	pack_fwrite(&angle, sizeof(angle), fp);
	pack_fwrite(&base_image, sizeof(base_image), fp);
	pack_fwrite(&shadow_image, sizeof(base_image), fp);
	pack_fwrite(&wreck_image, sizeof(base_image), fp);
	pack_fwrite(&anim_frames, sizeof(anim_frames), fp);
	pack_fwrite(&anim_rate, sizeof(anim_rate), fp);
	pack_fwrite(&armour, sizeof(armour), fp);
	pack_fwrite(&essential, sizeof(essential), fp);

	pack_fwrite(&material, sizeof(material), fp);
	pack_fwrite(&size, sizeof(size), fp);
}

void scenery::load(PACKFILE *fp) {
	pack_fread(name, sizeof(name), fp);
	pack_fread(&index, sizeof(index), fp);
	pack_fread(&inside, sizeof(inside), fp);
	pack_fread(&type, sizeof(type), fp);
	pack_fread(&altitude, sizeof(altitude), fp);
	pack_fread(&x, sizeof(x), fp);
	pack_fread(&y, sizeof(y), fp);
	pack_fread(&w, sizeof(w), fp);
	pack_fread(&h, sizeof(h), fp);
	pack_fread(&exist, sizeof(exist), fp);
	pack_fread(&target, sizeof(target), fp);
	pack_fread(&detail_level, sizeof(detail_level), fp);
	pack_fread(&angle, sizeof(angle), fp);
	pack_fread(&base_image, sizeof(base_image), fp);
	pack_fread(&shadow_image, sizeof(base_image), fp);
	pack_fread(&wreck_image, sizeof(base_image), fp);
	pack_fread(&anim_frames, sizeof(anim_frames), fp);
	pack_fread(&anim_rate, sizeof(anim_rate), fp);
	pack_fread(&armour, sizeof(armour), fp);
	pack_fread(&essential, sizeof(essential), fp);

	pack_fread(&material, sizeof(material), fp);
	pack_fread(&size, sizeof(size), fp);
}


void scenery::draw(BITMAP *bmp, DATAFILE *gfx, fixed ca, bool shadow) {
	if (altitude > GL_GROUND_FLAT_SCENERY && shadow) {
		// shadow
		BITMAP *s1 = create_bitmap(radius*2, radius*2);
		BITMAP *s2 = create_bitmap(radius*2, radius*2);
		clear(s1);
		clear(s2);
		rotate_sprite(s1, (BITMAP *)gfx[base_image].dat, radius-w/2, radius-h/2, angle - ca);
		draw_character(s2, s1, 0, 0, 15);
		//if (solid) draw_sprite(bmp, s2, render_x+shax*shadow_dist-radius, render_y+shay*shadow_dist-radius);
		draw_trans_sprite(bmp, s2, render_x+shax*shadow_dist-radius, render_y+shay*shadow_dist-radius);
		draw_sprite(bmp, s1, render_x-radius, render_y-radius);
		destroy_bitmap(s1);
		destroy_bitmap(s2);
	}
	else
		rotate_sprite(bmp, (BITMAP *)gfx[base_image].dat, render_x-w/2, render_y-h/2, angle - ca);

	//textprintf(bmp, font, render_x+10, render_y, 1, "%d", smoking);

}

void scenery::set_from_file(char *fname) {
	config *c = new config();
	if (c->load_data(fname)) {
		c->get_data_string("name", name);
		anim_frames = c->get_data_int("anim_frames");
		anim_rate = c->get_data_int("anim_rate");
		base_image = c->get_data_int("base_image");
		shadow_image = c->get_data_int("base_image");
		wreck_image = c->get_data_int("base_image");
		armour = c->get_data_int("armour");
	}
	c->~config();
}

