/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#include <math.h>
#include "allegro.h"
#include "projectile.h"
#include "vehicle.h"
#include "mission.h"
#include "sector.h"
#include "../data/general.h"


// constructor
projectile :: projectile(unit *u, int pt) {
	type = OBJ_PROJECTILE;
	p_type = pt;

	switch(p_type) {
		case P_BULLET : damage = 1; break;
		case P_BAZOOKA: damage = 10; break;
		case P_N_MISSILE: damage = 30; break;
		case P_HS_MISSILE: damage = 20; break;
		case P_PH_MISSILE: damage = 15 ; break;
	}

	if (u->type == OBJ_HELI) {
		x = u->x + rand()%7-3;
		y = u->y + rand()%7-3;
	}
	else {
		x = u->x;
		y = u->y;
	}

	bull_image = BULLET1;

	smoking = 0;
	team = u->team;
	if (u->type == OBJ_TANK || u->type == OBJ_TOWER) {
		vehicle *v = (vehicle *)u;
		angle = v->turret_angle-itofix(128);
	}
	else angle = u->angle-itofix(128);
	exist = TRUE;
	target = FALSE;
	detail_level = DETAIL_LOW;
	altitude = GL_MIDDLE;
	radius = 3;
	if (p_type == P_PH_MISSILE) radius = 16;
	bonus = 0;
	target = -1;

	base_image = 1;

	if (p_type == P_BULLET) {
		color = rand()%5+1;

		start_speed = 15;
		max_speed = 15;
		acc_speed = 1;
	}
	else {
		if (u->type == OBJ_HELI) {
			start_speed = 10;
			max_speed = 14;
			acc_speed = 0.2;
		}
		else {
			start_speed = 8;
			max_speed = 12;
			acc_speed = 0.1;
		}
	} 

	speed = start_speed;
	life = 100;
}

// destructor
projectile :: ~projectile() {}

void projectile::move(mission *m) {
	// adjust angle if neccesary
	if (target != -1) {
		if (m->obj[target] == NULL) {
			target = -1;
		}
		else {
			double dx = m->obj[target]->x - x;
			double dy = m->obj[target]->y - y;
			fixed tang = fatan2(ftofix(dy), ftofix(dx)) - itofix(64);

	        if (((angle-tang) & 0xFFFFFF) < itofix(128))
		        angle = (angle - itofix(4)) & 0xFFFFFF;
	        else
		        angle = (angle + itofix(4)) & 0xFFFFFF;
		}
	}

	double a = fixtof(angle)*2*PI/256 + PI/2;

	x = x + speed * cos(a);
	y = y + speed * sin(a);

	speed = MIN(speed + acc_speed, max_speed);
	life--;

}

void projectile::draw(BITMAP *bmp, DATAFILE *gfx, fixed ca, bool shadow) {
	if (p_type == P_BULLET) draw_sprite(bmp, (BITMAP *)gfx[bull_image].dat, render_x, render_y);
	else if (p_type == P_BAZOOKA) rotate_sprite(bmp, (BITMAP *)gfx[MISSILE_B].dat, render_x-1, render_y-3, angle - ca - itofix(128));
	else if (p_type == P_N_MISSILE) rotate_sprite(bmp, (BITMAP *)gfx[MISSILE_N].dat, render_x-1, render_y-5, angle - ca - itofix(128));
	else if (p_type == P_HS_MISSILE) {
		rotate_sprite(bmp, (BITMAP *)gfx[MISSILE_S].dat, render_x-1, render_y-5, angle - ca - itofix(128));
//		textprintf(bmp, font, render_x+5, render_y+5, 1, "%d", target);
	}
	else if (p_type == P_PH_MISSILE) rotate_sprite(bmp, (BITMAP *)gfx[MISSILE_P].dat, render_x-1, render_y-5, angle - ca - itofix(128));
}

void projectile::get_target(mission *m) {
	object *o;
	sector *s;
	int xp=0,yp=0;
	int trgt = -1;
	double dx, dy;
	fixed fang;

	for(xp=-1;xp<2;xp++)
		for(yp=-1;yp<2;yp++) {
			s = m->space->get_sector(x + xp * SECTOR_W, y + yp * SECTOR_H);
			if (s != NULL) {
				o = s->get_objects();
				while(o != NULL) {
					dx = o->x - x;
					dy = o->y - y;
					fang = fatan2(ftofix(dy), ftofix(dx)) - itofix(64);
			        if (((angle-fang) & 0xFFFFFF) < itofix(32) || ((angle-fang) & 0xFFFFFF) > itofix(224))
					if (o->is_unit() && o->team != 1) trgt = o->index;
					o = o->next;
				}
			}
		}

	if (trgt != -1) target = trgt;
}


