/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#ifndef _PLAYER_H_
#define _PLAYER_H_

#include "vehicle.h"
#include "soldier.h"

typedef struct {
	int fire_skill, fire_speed;
	int repair_skill, repair_speed;
	char callsign[32];
	char desc[256];
	int id;
} Tco_pilot;

class player {
public:
	unsigned long score;
	bool fired_missile;
	int ammo[8];
	Tco_pilot cop_info;
	int sec_weapon;
	bool got_sec_weapon;
	int armour_buffer;
	int repair_count;
	int lives;
	int dead;
	int knowledge;

	vehicle *heli;
	class soldier *cop;

	int landing;
	bool new_info;
	bool not_played;

	player();
	~player();

	void set_vehicle(object *o);
	void load(PACKFILE *fp);
	void save(PACKFILE *fp);
	void set_co_pilot(Tco_pilot *cp);
	double get_armour_percent(bool buffer);
	double get_armour_percent();
	double get_ammo_percent();
	int next_sec_weapon();
	void apply_pickup(int p_type);
	void update();
};


#endif
