/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#include <string.h>

#include "allegro.h"
#include "player.h"
#include "vehicle.h"
#include "soldier.h"
#include "pickup.h"

// constructor
player::player() {
	score = 0;
	landing = 0;
	sec_weapon = 0;
	got_sec_weapon = FALSE;
	cop = NULL;
	armour_buffer = 0;
	repair_count = 0;
	new_info = FALSE;
	not_played = FALSE;
	lives = 2;
	dead = false;
	knowledge = 0;
}

void player::set_vehicle(object *o) {
	heli = (vehicle *)o;
	
	heli->rot_step =0.1;
	heli->rot_fric = 0.92;

	heli->thr_step =0.02;
	heli->thr_fric = 0.95;

	heli->str_step =0.05;
	heli->str_fric = 0.85;

	heli->f_fric = 0.96;

	heli->heli_altitude = 0;
}

// destructor
player::~player() {}

double player::get_armour_percent(bool buffer) {
	if (buffer) return MIN((double)(heli->armour + armour_buffer/10) / (double)heli->max_armour, 1);
	return (double)heli->armour / (double)heli->max_armour;
}

void player::set_co_pilot(Tco_pilot *cp) {
	strcpy(cop_info.callsign, cp->callsign);
	strcpy(cop_info.desc, cp->desc);
	cop_info.fire_skill = cp->fire_skill;
	cop_info.fire_speed = cp->fire_speed;
	cop_info.repair_skill = cp->repair_skill;
	cop_info.repair_speed = cp->repair_speed;
	cop_info.id = cp->id;

	if (cop == NULL) cop = new soldier(OBJ_FOOT_SOLDIER);
	strcpy(cop->name, cop_info.callsign);
	cop->armour = 50;
	cop->team = 1;
	cop->pup_collector = TRUE;
	cop->base_image = cop->shadow_image = 82;
	cop->wreck_image = 86; 
	cop->jump_image = 87;
	cop->anim_frames = 4;
	cop->anim_rate = 10;
	cop->rot_step = 5;
	cop->rot_fric = 0;
	cop->thr_step = 0.1;
	cop->thr_fric = 0.5;
	cop->str_step = 1;
	cop->str_fric = 0.4;
	cop->f_fric = 0;
	cop->mag_size = 5;
	cop->sight_range = 600;
	cop->sight_angle = 360;
	cop->fire_range = 590;
	cop->fire_rate = 0;
	cop->reload_rate = 0;
	cop->fire_sound = 11;
	cop->reload_sound = -1;
	cop->die_sound = 2;
	cop->burn_sound = -1;
	cop->ply = this;
}

int player::next_sec_weapon() {
	int curr = sec_weapon;

	do {
		if (++sec_weapon>3) sec_weapon = 1;
		if (ammo[sec_weapon]) { got_sec_weapon = TRUE; return 1; }
	} while(curr != sec_weapon);
	got_sec_weapon = (ammo[sec_weapon] ? TRUE : FALSE); 
	return 0;
}

void player::apply_pickup(int p_type) {
	// todo: check roof in all cases
	switch (p_type) {
		case PUP_ARMOUR :
			armour_buffer += cop_info.repair_skill*(heli->max_armour>>1)/10;
			armour_buffer /= 10;
			armour_buffer = (armour_buffer+1)*10;
			break;
		case PUP_MACHINE_GUN :
			ammo[0] += 250;
			break;
		case PUP_N_MISSILE :
			ammo[1] += 8;
			sec_weapon = 1;
			break;
		case PUP_HS_MISSILE :
			ammo[2] += 8;
			sec_weapon = 2;
			break;
		case PUP_PH_MISSILE :
			ammo[3] += 8;
			sec_weapon = 3;
			break;
	}
}

void player::update() {
	double step = 5;

	if (armour_buffer && heli->armour == heli->max_armour) armour_buffer = 0;

	if (cop != NULL) {
		if (armour_buffer) {
			if (++repair_count > 10 - cop_info.repair_speed/10) repair_count = 0;
			if (!repair_count) {
				armour_buffer = MAX(armour_buffer - step, 0);
				if (!(armour_buffer%(10))) heli->armour = MIN(heli->armour + 1, heli->max_armour);
			}
		}
	}
}

