/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#include <stdio.h>

#include "allegro.h"
#include "main.h"
#include "object.h"
#include "pickup.h"
#include "dime.h"
#include "config.h"


// constructor
// sets some silly default values
pickup :: pickup(int t) {
	type = OBJ_PICKUP;
	p_type = t;
	sprintf(name, "pickup[%d]", rand());
	altitude = GL_GROUND_SCENERY;
	x = y = w = h = 0;
	exist = TRUE;
	target = FALSE;
	detail_level = DETAIL_LOW;
	smoking = 0;
	shadow_dist	= 3;
	angle = 0;
	anim_pos = 0;
	anim_frames = 0;
	anim_rate = 0;
	anim_count = 0;
	target_thrust = 1;
	essential = FALSE;

}

// destructor
pickup :: ~pickup() {
}

// copies data about object to str
void pickup::to_string(char *str) {
	sprintf(str, "%s", name);
}

// shows a property dialog
void pickup::props_dialog() {
	dialogf("Pickup Properties" , ALIGN_CENTER, ALIGN_CENTER, 300,
		"Name:%string[32]"
		"Type:%int[1,5]",
		name, &p_type);
}

void pickup::save(PACKFILE *fp) {
	pack_fwrite(name, sizeof(name), fp);
	pack_fwrite(&index, sizeof(index), fp);
	pack_fwrite(&inside, sizeof(inside), fp);
	pack_fwrite(&type, sizeof(type), fp);
	pack_fwrite(&altitude, sizeof(altitude), fp);
	pack_fwrite(&x, sizeof(x), fp);
	pack_fwrite(&y, sizeof(y), fp);
	pack_fwrite(&w, sizeof(w), fp);
	pack_fwrite(&h, sizeof(h), fp);
	pack_fwrite(&exist, sizeof(exist), fp);
	pack_fwrite(&target, sizeof(target), fp);
	pack_fwrite(&detail_level, sizeof(detail_level), fp);
	pack_fwrite(&angle, sizeof(angle), fp);
	pack_fwrite(&base_image, sizeof(base_image), fp);
	pack_fwrite(&shadow_image, sizeof(base_image), fp);
	pack_fwrite(&wreck_image, sizeof(base_image), fp);
	pack_fwrite(&anim_frames, sizeof(anim_frames), fp);
	pack_fwrite(&anim_rate, sizeof(anim_rate), fp);
	pack_fwrite(&armour, sizeof(armour), fp);
	pack_fwrite(&team, sizeof(team), fp);
	pack_fwrite(&essential, sizeof(essential), fp);

	pack_fwrite(&p_type, sizeof(p_type), fp);
}

void pickup::load(PACKFILE *fp) {
	pack_fread(name, sizeof(name), fp);
	pack_fread(&index, sizeof(index), fp);
	pack_fread(&inside, sizeof(inside), fp);
	pack_fread(&type, sizeof(type), fp);
	pack_fread(&altitude, sizeof(altitude), fp);
	pack_fread(&x, sizeof(x), fp);
	pack_fread(&y, sizeof(y), fp);
	pack_fread(&w, sizeof(w), fp);
	pack_fread(&h, sizeof(h), fp);
	pack_fread(&exist, sizeof(exist), fp);
	pack_fread(&target, sizeof(target), fp);
	pack_fread(&detail_level, sizeof(detail_level), fp);
	pack_fread(&angle, sizeof(angle), fp);
	pack_fread(&base_image, sizeof(base_image), fp);
	pack_fread(&shadow_image, sizeof(base_image), fp);
	pack_fread(&wreck_image, sizeof(base_image), fp);
	pack_fread(&anim_frames, sizeof(anim_frames), fp);
	pack_fread(&anim_rate, sizeof(anim_rate), fp);
	pack_fread(&armour, sizeof(armour), fp);
	pack_fread(&team, sizeof(team), fp);
	pack_fread(&essential, sizeof(essential), fp);

	pack_fread(&p_type, sizeof(p_type), fp);
}

void pickup::draw(BITMAP *bmp, DATAFILE *gfx, fixed ca, bool shadow) {
	// shadow
	if (shadow) {
		BITMAP *s1 = create_bitmap(w, h);
		BITMAP *s2 = create_bitmap(radius*2, radius*2);
		clear(s1);
		clear(s2);
		draw_character(s1, (BITMAP *)gfx[base_image].dat, 0, 0, 15);
		rotate_sprite(s2, s1, radius-w/2, radius-h/2, angle - ca);
		draw_trans_sprite(bmp, s2, render_x+shax*shadow_dist-radius, render_y+shay*shadow_dist-radius);
		destroy_bitmap(s1);
		destroy_bitmap(s2);
	}
	
	rotate_sprite(bmp, (BITMAP *)gfx[base_image+anim_pos].dat, render_x-w/2, render_y-h/2, angle - ca);
	rotate_sprite(bmp, (BITMAP *)gfx[base_image+9+p_type].dat, render_x-3, render_y-4, angle - ca);

	//if (inside) textout(bmp, font, "INSIDE", render_x+10, render_y, 1);
	//else textout(bmp, font, "OUTSIDE", render_x+10, render_y, 1);
}


void pickup::set_from_file(char *fname) { 
	config *c = new config();
	if (c->load_data(fname)) {
		c->get_data_string("name", name);
		anim_frames = c->get_data_int("anim_frames");
		anim_rate = c->get_data_int("anim_rate");
		base_image = c->get_data_int("base_image");
		shadow_image = c->get_data_int("shadow_image");
		wreck_image = c->get_data_int("wreck_image");
		armour = c->get_data_int("armour");
		p_type = c->get_data_int("p_type");
	}
	c->~config();
}